<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        $this->set('waluty', WalutaPeer::doSelect(new Criteria()));
    }              

    public function execute_show()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($waluta = WalutaPeer::retrieveBySlug($_GET['slug']))
        ) {
            $this->set('waluta', $waluta);
            
            $dane = $waluta->podajKursy();
            
            $minimum  = min($dane);
            $maksimum = max($dane);
            
            $dlugosc = $maksimum - $minimum;

            $minimum = $minimum - $dlugosc / 10;
            $maksimum = $maksimum + $dlugosc / 10;

            $krok = ($maksimum - $minimum) / 5;

            $etykiety = '';
            for ($i = 0; $i < 6; $i++) {
                $etykiety .= "|" . round($minimum + $i * $krok, 2);
            }

            $chd =
                't:' . implode(',', $dane) . '&amp;chds=' .
                $minimum . ',' . $maksimum;

            $url =
                'http://chart.apis.google.com/chart?' .
                'cht=lc&amp;' .
                'chd=' . $chd . '&amp;' .
                'chco=0b59b0&amp;' .
                'chls=1&amp;' .
                'chs=400x300&amp;' .
                'chxt=x,y&amp;' .
                'chxl=0:||1:' . $etykiety . '&amp;' .
                'chf=bg,s,d7e9fd&amp;' .
                'chm=B,9ac8fa,0,0,0&amp;' .
                'chg=100.0,10.0';
            
            $this->set('url', $url);

        } else {

            $this->execute_404();

        }

    }



}