<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl" lang="pl">
  <head>
    <title>Tablica wartości funkcji trygonometrycznych</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link rel="stylesheet" type="text/css" href="stopka.css" />
    <style type="text/css">
    body {
        font-family: Verdana, sans-serif;
        text-align: center;
    }    
    
    table {
        border-collapse: collapse;
        border: 1px solid black;
        margin: 0 auto;
    }

    td {
        border: solid black 1px;
        width: 100px;
        text-align: right;
    }

    th {
        text-align: right;
        color: white;
        background: black;
        font-weight: bold;
    }    
    </style>
  </head>
<body>

<h1>Tablica wartości funkcji trygonometrycznych</h1>

<table>
  <tr>
    <th>kąt</th>
    <th>sin</th>
    <th>cos</th>
    <th>tg</th>
    <th>ctg</th>
  </tr>
<?php

$prog = 0.000001;

for ($kat = 0; $kat <= 360; $kat += 30) {
    echo '  <tr>' . "\n";
    echo '    <th>' . $kat . '</th>' . "\n";

    echo '    <td>' . round(sin(deg2rad($kat)), 2) . '</td>' . "\n";
    echo '    <td>' . round(cos(deg2rad($kat)), 2) . '</td>' . "\n";

    if (abs(cos(deg2rad($kat))) < $prog) {
        echo '    <td></td>' . "\n";
    } else {
        echo '    <td>' . round(tan(deg2rad($kat)), 2) . '</td>' . "\n";
    }

    if (abs(sin(deg2rad($kat))) < $prog) {
        echo '    <td></td>' . "\n";
    } else {
        echo '    <td>' . round(1/tan(deg2rad($kat)), 2) . '</td>' . "\n";
    }

    echo '  </tr>' . "\n";
}

?>
</table>


</body>
</html>

