<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'zengardencss/Projekt.php';
Propel::init('zengardencss-conf.php');

require_once 'slugs.inc.php';

ProjektHasCzcionkaPeer::doDeleteAll();
CzcionkaPeer::doDeleteAll();
PlatformaPeer::doDeleteAll();
RodzinaPeer::doDeleteAll();
ProjektPeer::doDeleteAll();
ImgPeer::doDeleteAll();


$plk = file('dane/czcionki.txt');
shuffle($plk);
foreach ($plk as $l) {
    $str_czcionka = trim($l);
        
    $c = new Criteria();
    $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
    $czcionka = CzcionkaPeer::doSelectOne($c);
    if (!$czcionka) {
        $slug = string2slug($str_czcionka);
        
        $czcionka = new Czcionka();
        $czcionka->setNazwa($str_czcionka);
        $czcionka->setSlug($slug);        
            
        $preview = 'dane/img/img/' . $slug . '.png';
        $img = new Img();
        $img->setImage(file_get_contents($preview));
        $img->setSlug($slug);
        $img->save();
            
        $czcionka->setImg($img->getImgId());
            
        $lowercase = 'dane/img/lowercase/' . $slug . '.png';
        if (file_exists($lowercase)) {
            $czcionka->setPodglad(1);
                
            $img_lowercase = new Img();
            $img_lowercase->setImage(file_get_contents($lowercase));
            $img_lowercase->setSlug($slug . '-lower');            
            $img_lowercase->save();                            
                
            $uppercase = 'dane/img/uppercase/' . $slug . '.png';                
            $img_uppercase = new Img();
            $img_uppercase->setImage(file_get_contents($uppercase));
            $img_uppercase->setSlug($slug . '-upper');            
            $img_uppercase->save();                                            
                
            $czcionka->setLowercase($img_lowercase->getImgId());
            $czcionka->setUppercase($img_uppercase->getImgId());
        } else {
            $czcionka->setPodglad(0);
        }
            
        $czcionka->save();
    }        
        
}




$plk = file('dane/rodziny.txt');
shuffle($plk);
foreach ($plk as $l) {
    $e = explode('|', trim($l));
    $str_rodzina = $e[0];
    
    $c = new Criteria();
    $c->add(RodzinaPeer::NAZWA, $str_rodzina);
    $rodzina = RodzinaPeer::doSelectOne($c);
    if (!$rodzina) {
        $rodzina = new Rodzina();
        $rodzina->setNazwa($str_rodzina);
        $rodzina->setSlug(string2slug($str_rodzina));
        $rodzina->save();
    }
    
    $tmp = explode(',', trim($e[1]));
    foreach ($tmp as $str_czcionka) {
        $str_czcionka = trim($str_czcionka);
        
        $c = new Criteria();
        $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
        $czcionka = CzcionkaPeer::doSelectOne($c);
        $czcionka->setRodzina($rodzina);
        $czcionka->save();
    }
    
}



$plk = file('dane/platformy.txt');
shuffle($plk);
foreach ($plk as $l) {
    $e = explode('|', trim($l));
    $str_platforma = $e[0];
    
    $c = new Criteria();
    $c->add(PlatformaPeer::NAZWA, $str_platforma);
    $platforma = PlatformaPeer::doSelectOne($c);
    if (!$platforma) {
        $platforma = new Platforma();
        $platforma->setNazwa($str_platforma);
        $platforma->setSlug(string2slug($str_platforma));
        $platforma->save();
    }
    
    $tmp = explode(',', trim($e[1]));
    foreach ($tmp as $str_czcionka) {
        $str_czcionka = trim($str_czcionka);
        
        $c = new Criteria();
        $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
        $czcionka = CzcionkaPeer::doSelectOne($c);
        $czcionka->setPlatforma($platforma);
        $czcionka->save();
    }    
    
}


$plk = file('dane/projekty.txt');
shuffle($plk);
foreach ($plk as $l) {
    $e = explode('|', trim($l));
    $str_projekt = $e[0];
    
    $c = new Criteria();
    $c->add(ProjektPeer::NAZWA, $str_projekt);
    $projekt = ProjektPeer::doSelectOne($c);
    if (!$projekt) {
        $projekt = new Projekt();
        $projekt->setNazwa($str_projekt);
        $projekt->setSlug(string2slug($str_projekt));
        $projekt->save();
    }
    
    
    $tmp = explode(',', trim($e[1]));
    foreach ($tmp as $str_czcionka) {
        $str_czcionka = trim($str_czcionka);
        
        $c = new Criteria();
        $c->add(CzcionkaPeer::NAZWA, $str_czcionka);
        $czcionka = CzcionkaPeer::doSelectOne($c);
        if ($czcionka) {
            $phf = new ProjektHasCzcionka();
            $phf->setProjekt($projekt);
            $phf->setCzcionka($czcionka);
            $phf->save();
        }
        
        
    }        
    
    
    
}


