set names utf8;
drop database if exists kursywalut;
create database kursywalut default character set utf8 collate utf8_polish_ci;
grant all on kursywalut.* to admin@localhost identified by 'password';
flush privileges;
use kursywalut;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- waluta
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `waluta`;


CREATE TABLE `waluta`
(
	`waluta_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`przelicznik` VARCHAR(45),
	`kod` VARCHAR(45),
	`slug` VARCHAR(45),
	PRIMARY KEY (`waluta_id`),
	UNIQUE KEY `waluta_U_1` (`kod`(45))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- kurs
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kurs`;


CREATE TABLE `kurs`
(
	`kurs_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`kurssredni` FLOAT,
	`waluta_id` INTEGER,
	`tabela_id` INTEGER,
	PRIMARY KEY (`kurs_id`),
	INDEX `FI_kurs_waluta` (`waluta_id`),
	CONSTRAINT `fk_kurs_waluta`
		FOREIGN KEY (`waluta_id`)
		REFERENCES `waluta` (`waluta_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_kurs_tabela1` (`tabela_id`),
	CONSTRAINT `fk_kurs_tabela1`
		FOREIGN KEY (`tabela_id`)
		REFERENCES `tabela` (`tabela_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- tabela
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `tabela`;


CREATE TABLE `tabela`
(
	`tabela_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numertabeli` VARCHAR(45),
	`datapublikacji` DATE,
	`slug` VARCHAR(45),
	PRIMARY KEY (`tabela_id`),
	UNIQUE KEY `tabela_U_1` (`slug`(45))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
