<?php

header('Content-Type: text/plain;  charset=utf-8');

set_time_limit(0);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'pagedarts/Article.php';
Propel::init('pagedarts-conf.php');

require_once 'htmlarticle.class.php';
require_once 'slugs.inc.php';
require_once 'wskaznik-postepu.class.php';

ArticlePeer::doDeleteAll();
//FilePeer::doDeleteAll();
//PagePeer::doDeleteAll();

$plks = glob('xml/*');

$wsk = new WskaznikPostepu('artykuly stronicowane', count($plks), count($plks));

foreach ($plks as $plk) {

    $wsk->next();

    $art = new HTMLArticle($plk);
    
    $artykul = new Article();
    $artykul->setTitle($art->paged['title']);
    $artykul->setIntroduction($art->paged['introduction']);
    $artykul->setToc($art->paged['toc']);
    $artykul->setSlug(html2slug($art->paged['title']));
    $artykul->setDate($art->paged['date']);
    $artykul->setOnepage($art->singlepagearticle['toc'] . $art->singlepagearticle['text']);
    $artykul->setAddresses($art->paged['addresses']);
    $artykul->setDownload($art->paged['download']);
    $artykul->setExamples($art->paged['examples']);
    $artykul->save();
    
    foreach ($art->pages as $k=>$str_page) {
    
        $page = new Page();
        $page->setPage($str_page);
        $page->setNumber($k);
        $page->setArticle($artykul);
        $page->save();
    }
    
    foreach ($art->getFigures() as $figure) {
        $file = new File();
        $file->setData(base64_decode($figure['image']));
        $file->setSlug($figure['filename']);
        $file->setMime($figure['ext']);
        $file->setArticle($artykul);
        $file->save();
    }
    
    foreach ($art->getExamples() as $example) {
        $file = new File();
        $file->setData(base64_decode($example['data']));
        $file->setSlug($example['filename']);
        
        $path_parts = pathinfo($example['filename']);
        
        $file->setMime($path_parts['extension']);
        $file->setArticle($artykul);
        $file->save();
    }
    
    foreach ($art->getDownload() as $download) {
        $file = new File();
        $file->setData(base64_decode($download['data']));
        $file->setSlug($download['filename']);

        $path_parts = pathinfo($download['filename']);

        $file->setMime($path_parts['extension']);
        $file->setArticle($artykul);
        $file->save();
    }
    
    
    
    
    
}
