<?php


/**
 * This class adds structure of 'imie' table to 'imiona' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    imiona.map
 */
class ImieMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'imiona.map.ImieMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ImiePeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ImiePeer::TABLE_NAME);
		$tMap->setPhpName('Imie');
		$tMap->setClassname('Imie');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('IMIE_ID', 'ImieId', 'INTEGER', true, null);

		$tMap->addColumn('IMIE', 'Imie', 'VARCHAR', true, 45);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

	} // doBuild()

} // ImieMapBuilder
