set names utf8;
drop database if exists aparatyfoto;
create database aparatyfoto default character set utf8 collate utf8_polish_ci;
grant all on aparatyfoto.* to admin@localhost identified by 'password';
flush privileges;
use aparatyfoto;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- producent
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `producent`;


CREATE TABLE `producent`
(
	`producent_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	PRIMARY KEY (`producent_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- aparat
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `aparat`;


CREATE TABLE `aparat`
(
	`aparat_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`model` VARCHAR(45),
	`typ` VARCHAR(45),
	`megapixel` VARCHAR(45),
	`lcd` VARCHAR(45),
	`wymiar_matrycy` VARCHAR(45),
	`pamiec` VARCHAR(45),
	`mocowanie_obiektywu` VARCHAR(45),
	`mnoznik_ogniskowej` VARCHAR(45),
	`stabilizacja_obrazu` VARCHAR(45),
	`migawka` VARCHAR(45),
	`czulosc` VARCHAR(45),
	`autobraketing` VARCHAR(45),
	`podglad_glebi` VARCHAR(45),
	`balans_bieli` VARCHAR(45),
	`zdjecia_seryjne` VARCHAR(45),
	`pole_widzenia` VARCHAR(45),
	`korpus` VARCHAR(45),
	`baterie` VARCHAR(45),
	`cena` VARCHAR(45),
	`slug` VARCHAR(45),
	`producent_id` INTEGER,
	`matryca_id` INTEGER,
	PRIMARY KEY (`aparat_id`),
	INDEX `FI_aparat_producent` (`producent_id`),
	CONSTRAINT `fk_aparat_producent`
		FOREIGN KEY (`producent_id`)
		REFERENCES `producent` (`producent_id`),
	INDEX `FI_aparat_matryca1` (`matryca_id`),
	CONSTRAINT `fk_aparat_matryca1`
		FOREIGN KEY (`matryca_id`)
		REFERENCES `matryca` (`matryca_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- matryca
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `matryca`;


CREATE TABLE `matryca`
(
	`matryca_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	PRIMARY KEY (`matryca_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
