<?php

header('Content-Type: text/plain; charset=utf-8');

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'klasyfikacjazwierzat/Gromada.php';
Propel::init('klasyfikacjazwierzat-conf.php');

require_once 'XML/Unserializer.php';
require_once 'slugs.inc.php';

GromadaPeer::doDeleteAll();
RzadPeer::doDeleteAll();
RodzinaPeer::doDeleteAll();

$unserializer = new XML_Unserializer();
$options = array(
    'parseAttributes' => true,
    'forceEnum' => array('gromada', 'rzad', 'rodzina'),
);
$unserializer->setOptions($options);
$unserializer->unserialize('klasyfikacja-zwierzat.xml', true);
$dane = $unserializer->getUnserializedData();

foreach ($dane['gromada'] as $gromada) {

    $gromada_dane = array(
        'gromada' => $gromada['nazwa'],
        'slug' => string2slug($gromada['nazwa'])
    );
    $objGromada = GromadaPeer::insertIfNotExists($gromada_dane);

    foreach ($gromada['rzad'] as $rzad) {
    
        $rzad_dane = array(
            'rzad' => $rzad['nazwa'],
            'slug' => string2slug($rzad['nazwa']),
            'gromada_id' => $objGromada->getGromadaId()
        );

        $objRzad = RzadPeer::insertIfNotExists($rzad_dane);

        foreach ($rzad['rodzina'] as $rodzina) {
        
            $rodzina_dane = array(
                'rodzina' => $rodzina['nazwa'],
                'slug' => string2slug($rodzina['nazwa']),
                'rzad_id' => $objRzad->getRzadId()
            );

            $objRodzina = RodzinaPeer::insertIfNotExists($rodzina_dane);
        }
    }
}


