
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- gromada
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `gromada`;


CREATE TABLE `gromada`
(
	`gromada_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`gromada` VARCHAR(128),
	`slug` VARCHAR(128),
	PRIMARY KEY (`gromada_id`),
	UNIQUE KEY `gromada_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rzad
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rzad`;


CREATE TABLE `rzad`
(
	`rzad_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rzad` VARCHAR(128),
	`slug` VARCHAR(128),
	`gromada_id` INTEGER,
	PRIMARY KEY (`rzad_id`),
	UNIQUE KEY `rzad_U_1` (`slug`(128)),
	INDEX `FI_rzad_gromada1` (`gromada_id`),
	CONSTRAINT `fk_rzad_gromada1`
		FOREIGN KEY (`gromada_id`)
		REFERENCES `gromada` (`gromada_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzina
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzina`;


CREATE TABLE `rodzina`
(
	`rodzina_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rodzina` VARCHAR(128),
	`slug` VARCHAR(128),
	`rzad_id` INTEGER,
	PRIMARY KEY (`rodzina_id`),
	INDEX `FI_rodzina_rzad` (`rzad_id`),
	CONSTRAINT `fk_rodzina_rzad`
		FOREIGN KEY (`rzad_id`)
		REFERENCES `rzad` (`rzad_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
