<?php

require_once 'xmlarticle.class.php';

require_once 'Smarty.class.php';
require_once 'smartystring.class.php';
require_once 'toc.inc.php';

class HTMLArticle
{
    private $url = '';

    private $art;

    public $pages;
    public $pages_count = 0;

    public $template_prefix;    
    
    public $html;
    
    public $singlepagearticle;


    public function __construct($filename)
    {
        $this->art = new XMLArticle($filename);
        
        $this->setUrl();

        $this->html = array(
            'figures' => array(),
            'listings' => array(),
            'tables' => array(),
            'frames' => array(),
        );

        /*
         * ustalamy kod HTML:
         * Figures, Listings, Frames, Tables
         */        
        $this->processFLFTHTML();
        

        /*
         * ustalamy numerację tabel
         *  Examples, Download, Addresses
         */        
        $this->processEDANumbering();
        
        $this->processHTML();
        $this->processSinglepage();
        $this->processPages();
        
    }




    
    

    
    
    /*
     * Przygotowujemy kod HTML tabel, listingów, obrazów...
     *
     */   
    public function processFLFTHTML()
    {
    
        for ($i = 1; $i <= $this->art->getFiguresCount(); $i++) {
            $this->html['figures'][$i] = $this->getHTMLFigure($i);
        }
        
        for ($i = 1; $i <= $this->art->getListingsCount(); $i++) {
            $this->html['listings'][$i] = $this->getHTMLListing($i);
        }

        for ($i = 1; $i <= $this->art->getFramesCount(); $i++) {
            $this->html['frames'][$i] = $this->getHTMLFrame($i);
        }

        for ($i = 1; $i <= $this->art->getTablesCount(); $i++) {
            $this->html['tables'][$i] = $this->getHTMLTable($i);
        }
        
    }        
    
    
    public function processEDANumbering()
    {
        $this->art->processEDANumbering();

        if ($this->art->getExamplesCount() == 0) {
            $this->html['examples'] = '';
        } else {
            $this->html['examples'] = $this->getHTMLExamples();
        }

        if ($this->art->getDownloadCount() == 0) {
            $this->html['download'] = '';
        } else {
            $this->html['download'] = $this->getHTMLDownload();
        }

        if ($this->art->getAddressesCount() == 0) {
            $this->html['addresses'] = '';
        } else {
            $this->html['addresses'] = $this->getHTMLAddresses();
        }


    }

        
    public function processHTML()
    {
        $tmps = new SmartyString();
        $tmp = $this->art->getArticle();
        
        $tmps->addTemplate('content.tpl', $tmp);
        $tmps->assign('figures', $this->html['figures']);
        $tmps->assign('listings', $this->html['listings']);
        $tmps->assign('frames', $this->html['frames']);
        $tmps->assign('tables', $this->html['tables']);
        $tmps->left_delimiter = '#####{';
        $tmps->right_delimiter = '}#####';
        
        $this->html['article'] = $tmps->fetch('str:content.tpl');
    }
    
    public function processSinglepage()
    {
        $this->singlepagearticle = array();
        
        $toc_array = getTableOfContents($this->html['article']);
        $this->singlepagearticle['toc'] = getTableOfContentsAsString($toc_array);
        $this->singlepagearticle['text'] = replaceChapters($toc_array, $this->html['article']);
        
        $this->singlepagearticle['title']        = $this->art->getTitle();
        $this->singlepagearticle['introduction'] = $this->art->getIntroduction();
        $this->singlepagearticle['date']         = $this->art->getDate();
        $this->singlepagearticle['examples']     = $this->html['examples'];
        $this->singlepagearticle['addresses']    = $this->html['addresses'];
        $this->singlepagearticle['download']     = $this->html['download'];
    }
        

    public function simpleArticle($ATemplate = 'simple-article.tpl')
    {
        $s = new Smarty();
        $s->assign('article', $this->singlepagearticle);
        return $s->fetch($ATemplate);
    }


    public function getHTMLFigure($ANo)
    {
        $z = new Smarty();
        $z->assign('figure', $this->art->getFigure($ANo));
        return $z->fetch('figure.tpl');
    }
    
    public function getHTMLListing($ANo)
    {
        $z = new Smarty();
        $z->assign('listing', $this->art->getListing($ANo));
        return $z->fetch('listing.tpl');
    }
    
    public function getHTMLFrame($ANo)
    {
        $z = new Smarty();
        $z->assign('frame', $this->art->getFrame($ANo));
        return $z->fetch('frame.tpl');
    }
    
    public function getHTMLTable($ANo)
    {
        $z = new Smarty();
        $z->assign('table', $this->art->getTable($ANo));
        
        $x = $this->art->getTable($ANo);
        
        return $z->fetch('table.tpl');
    }

    public function getHTMLExamples()
    {
        $z = new Smarty();
        $z->assign('examples', $this->art->getExamples());
        return $z->fetch('examples.tpl');
    }

    public function getHTMLDownload()
    {
        $z = new Smarty();
        $z->assign('download', $this->art->getDownload());
        return $z->fetch('download.tpl');
    }

    public function getHTMLAddresses()
    {
        $z = new Smarty();
        $z->assign('addresses', $this->art->getAddresses());
        return $z->fetch('addresses.tpl');
    }

    public function processPages()
    {
        $this->paged = array();
        $this->pages = array();
        
        
        
        $this->paged['title']        = $this->art->getTitle();
        $this->paged['introduction'] = $this->art->getIntroduction();
        $this->paged['date']         = $this->art->getDate();
        $this->paged['examples']     = $this->html['examples'];
        $this->paged['addresses']    = $this->html['addresses'];
        $this->paged['download']     = $this->html['download'];
        
        $tablicaTOC  = getTableOfContents($this->html['article']);
        
        $this->paged['toc'] = getTableOfContentsAsStringPages($tablicaTOC, $this->url);
        
        $newContents = replaceChaptersPages($tablicaTOC, $this->html['article']);
        
        
        $podziel = preg_split(
            "/<h3>(.*)<\/h3>/Uis",
            $newContents
        );
        
        
        $this->pages_count = count($tablicaTOC);
        for ($i = 1; $i <= $this->pages_count; $i++) {

            $r_tekst = trim($podziel[$i]);
            $r_tytul = $tablicaTOC[$i]['title'];
            $r_numer = $i;
            $r_tekst = "<h3>{$r_numer}. {$r_tytul}</h3>" . $r_tekst;

            $this->pages[$i] = trim($r_tekst);
        }
        
        
        
    }
    
    public function setUrl()
    {
    }
    
    public function getFigures()
    {
        if (isset($this->art->a['figures']['item'])) {
            return $this->art->a['figures']['item'];
        } else {
            return array();
        }
    }
    
    public function getExamples()
    {
        if (isset($this->art->a['examples']['items']['item'])) {
            return $this->art->a['examples']['items']['item'];
        } else {
            return array();
        }
    }
    
    public function getDownload()
    {
        if (isset($this->art->a['download']['items']['item'])) {
            return $this->art->a['download']['items']['item'];
        } else {
            return array();
        }
    }

    
}

