<?php


/**
 * This class adds structure of 'page' table to 'pagedarts' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    pagedarts.map
 */
class PageMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'pagedarts.map.PageMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(PagePeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(PagePeer::TABLE_NAME);
		$tMap->setPhpName('Page');
		$tMap->setClassname('Page');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('PAGE_ID', 'PageId', 'INTEGER', true, null);

		$tMap->addColumn('PAGE', 'Page', 'LONGVARCHAR', false, null);

		$tMap->addForeignKey('ARTICLE_ID', 'ArticleId', 'INTEGER', 'article', 'ARTICLE_ID', false, null);

		$tMap->addColumn('NUMBER', 'Number', 'INTEGER', false, null);

	} // doBuild()

} // PageMapBuilder
