<?php


/**
 * This class adds structure of 'autor' table to 'artykulymi' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    artykulymi.map
 */
class AutorMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'artykulymi.map.AutorMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(AutorPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(AutorPeer::TABLE_NAME);
		$tMap->setPhpName('Autor');
		$tMap->setClassname('Autor');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('AUTOR_ID', 'AutorId', 'INTEGER', true, null);

		$tMap->addColumn('IMIE', 'Imie', 'VARCHAR', true, 255);

		$tMap->addColumn('NAZWISKO', 'Nazwisko', 'VARCHAR', true, 255);

		$tMap->addColumn('LICZBAARTYKULOW', 'Liczbaartykulow', 'INTEGER', false, null);

		$tMap->addColumn('LICZBASTRON', 'Liczbastron', 'INTEGER', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

	} // doBuild()

} // AutorMapBuilder
