<?php

require 'artykulymi/om/BasePodrubryka.php';


/**
 * Skeleton subclass for representing a row from the 'podrubryka' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class Podrubryka extends BasePodrubryka {

	/**
	 * Initializes internal state of Podrubryka object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getPodrubryka();
	}
	
    public function przeliczArtykuly()
    {
        $arts = $this->getArtykuls();
        $this->setLiczbaartykulow(count($arts));
        $liczba_stron = 0;
        foreach ($arts as $art) {
            $liczba_stron += $art->getLiczbastron();
        }
        $this->setLiczbastron($liczba_stron);
        $this->save();
    }
    
    public function setSlug($slug)
    {
        if (trim($slug) == '') {
            parent::setSlug('unknown');
        } else {
            parent::setSlug($slug);
        }
    }

} // Podrubryka
