<?php

require 'football2002/om/BaseLigaPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'liga' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    football2002
 */
class LigaPeer extends BaseLigaPeer {

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }
    
    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = parent::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Liga();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }


} // LigaPeer
