<?php

/**
 * Base static class for performing query and update operations on the 'aparat' table.
 *
 * 
 *
 * @package    aparatyfoto.om
 */
abstract class BaseAparatPeer {

	/** the default database name for this class */
	const DATABASE_NAME = 'aparatyfoto';

	/** the table name for this class */
	const TABLE_NAME = 'aparat';

	/** A class that can be returned by this peer. */
	const CLASS_DEFAULT = 'aparatyfoto.Aparat';

	/** The total number of columns. */
	const NUM_COLUMNS = 23;

	/** The number of lazy-loaded columns. */
	const NUM_LAZY_LOAD_COLUMNS = 0;

	/** the column name for the APARAT_ID field */
	const APARAT_ID = 'aparat.APARAT_ID';

	/** the column name for the MODEL field */
	const MODEL = 'aparat.MODEL';

	/** the column name for the TYP field */
	const TYP = 'aparat.TYP';

	/** the column name for the MEGAPIXEL field */
	const MEGAPIXEL = 'aparat.MEGAPIXEL';

	/** the column name for the LCD field */
	const LCD = 'aparat.LCD';

	/** the column name for the WYMIAR_MATRYCY field */
	const WYMIAR_MATRYCY = 'aparat.WYMIAR_MATRYCY';

	/** the column name for the PAMIEC field */
	const PAMIEC = 'aparat.PAMIEC';

	/** the column name for the MOCOWANIE_OBIEKTYWU field */
	const MOCOWANIE_OBIEKTYWU = 'aparat.MOCOWANIE_OBIEKTYWU';

	/** the column name for the MNOZNIK_OGNISKOWEJ field */
	const MNOZNIK_OGNISKOWEJ = 'aparat.MNOZNIK_OGNISKOWEJ';

	/** the column name for the STABILIZACJA_OBRAZU field */
	const STABILIZACJA_OBRAZU = 'aparat.STABILIZACJA_OBRAZU';

	/** the column name for the MIGAWKA field */
	const MIGAWKA = 'aparat.MIGAWKA';

	/** the column name for the CZULOSC field */
	const CZULOSC = 'aparat.CZULOSC';

	/** the column name for the AUTOBRAKETING field */
	const AUTOBRAKETING = 'aparat.AUTOBRAKETING';

	/** the column name for the PODGLAD_GLEBI field */
	const PODGLAD_GLEBI = 'aparat.PODGLAD_GLEBI';

	/** the column name for the BALANS_BIELI field */
	const BALANS_BIELI = 'aparat.BALANS_BIELI';

	/** the column name for the ZDJECIA_SERYJNE field */
	const ZDJECIA_SERYJNE = 'aparat.ZDJECIA_SERYJNE';

	/** the column name for the POLE_WIDZENIA field */
	const POLE_WIDZENIA = 'aparat.POLE_WIDZENIA';

	/** the column name for the KORPUS field */
	const KORPUS = 'aparat.KORPUS';

	/** the column name for the BATERIE field */
	const BATERIE = 'aparat.BATERIE';

	/** the column name for the CENA field */
	const CENA = 'aparat.CENA';

	/** the column name for the SLUG field */
	const SLUG = 'aparat.SLUG';

	/** the column name for the PRODUCENT_ID field */
	const PRODUCENT_ID = 'aparat.PRODUCENT_ID';

	/** the column name for the MATRYCA_ID field */
	const MATRYCA_ID = 'aparat.MATRYCA_ID';

	/**
	 * An identiy map to hold any loaded instances of Aparat objects.
	 * This must be public so that other peer classes can access this when hydrating from JOIN
	 * queries.
	 * @var        array Aparat[]
	 */
	public static $instances = array();

	/**
	 * The MapBuilder instance for this peer.
	 * @var        MapBuilder
	 */
	private static $mapBuilder = null;

	/**
	 * holds an array of fieldnames
	 *
	 * first dimension keys are the type constants
	 * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
	 */
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('AparatId', 'Model', 'Typ', 'Megapixel', 'Lcd', 'WymiarMatrycy', 'Pamiec', 'MocowanieObiektywu', 'MnoznikOgniskowej', 'StabilizacjaObrazu', 'Migawka', 'Czulosc', 'Autobraketing', 'PodgladGlebi', 'BalansBieli', 'ZdjeciaSeryjne', 'PoleWidzenia', 'Korpus', 'Baterie', 'Cena', 'Slug', 'ProducentId', 'MatrycaId', ),
		BasePeer::TYPE_STUDLYPHPNAME => array ('aparatId', 'model', 'typ', 'megapixel', 'lcd', 'wymiarMatrycy', 'pamiec', 'mocowanieObiektywu', 'mnoznikOgniskowej', 'stabilizacjaObrazu', 'migawka', 'czulosc', 'autobraketing', 'podgladGlebi', 'balansBieli', 'zdjeciaSeryjne', 'poleWidzenia', 'korpus', 'baterie', 'cena', 'slug', 'producentId', 'matrycaId', ),
		BasePeer::TYPE_COLNAME => array (self::APARAT_ID, self::MODEL, self::TYP, self::MEGAPIXEL, self::LCD, self::WYMIAR_MATRYCY, self::PAMIEC, self::MOCOWANIE_OBIEKTYWU, self::MNOZNIK_OGNISKOWEJ, self::STABILIZACJA_OBRAZU, self::MIGAWKA, self::CZULOSC, self::AUTOBRAKETING, self::PODGLAD_GLEBI, self::BALANS_BIELI, self::ZDJECIA_SERYJNE, self::POLE_WIDZENIA, self::KORPUS, self::BATERIE, self::CENA, self::SLUG, self::PRODUCENT_ID, self::MATRYCA_ID, ),
		BasePeer::TYPE_FIELDNAME => array ('aparat_id', 'model', 'typ', 'megapixel', 'lcd', 'wymiar_matrycy', 'pamiec', 'mocowanie_obiektywu', 'mnoznik_ogniskowej', 'stabilizacja_obrazu', 'migawka', 'czulosc', 'autobraketing', 'podglad_glebi', 'balans_bieli', 'zdjecia_seryjne', 'pole_widzenia', 'korpus', 'baterie', 'cena', 'slug', 'producent_id', 'matryca_id', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, )
	);

	/**
	 * holds an array of keys for quick access to the fieldnames array
	 *
	 * first dimension keys are the type constants
	 * e.g. self::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
	 */
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('AparatId' => 0, 'Model' => 1, 'Typ' => 2, 'Megapixel' => 3, 'Lcd' => 4, 'WymiarMatrycy' => 5, 'Pamiec' => 6, 'MocowanieObiektywu' => 7, 'MnoznikOgniskowej' => 8, 'StabilizacjaObrazu' => 9, 'Migawka' => 10, 'Czulosc' => 11, 'Autobraketing' => 12, 'PodgladGlebi' => 13, 'BalansBieli' => 14, 'ZdjeciaSeryjne' => 15, 'PoleWidzenia' => 16, 'Korpus' => 17, 'Baterie' => 18, 'Cena' => 19, 'Slug' => 20, 'ProducentId' => 21, 'MatrycaId' => 22, ),
		BasePeer::TYPE_STUDLYPHPNAME => array ('aparatId' => 0, 'model' => 1, 'typ' => 2, 'megapixel' => 3, 'lcd' => 4, 'wymiarMatrycy' => 5, 'pamiec' => 6, 'mocowanieObiektywu' => 7, 'mnoznikOgniskowej' => 8, 'stabilizacjaObrazu' => 9, 'migawka' => 10, 'czulosc' => 11, 'autobraketing' => 12, 'podgladGlebi' => 13, 'balansBieli' => 14, 'zdjeciaSeryjne' => 15, 'poleWidzenia' => 16, 'korpus' => 17, 'baterie' => 18, 'cena' => 19, 'slug' => 20, 'producentId' => 21, 'matrycaId' => 22, ),
		BasePeer::TYPE_COLNAME => array (self::APARAT_ID => 0, self::MODEL => 1, self::TYP => 2, self::MEGAPIXEL => 3, self::LCD => 4, self::WYMIAR_MATRYCY => 5, self::PAMIEC => 6, self::MOCOWANIE_OBIEKTYWU => 7, self::MNOZNIK_OGNISKOWEJ => 8, self::STABILIZACJA_OBRAZU => 9, self::MIGAWKA => 10, self::CZULOSC => 11, self::AUTOBRAKETING => 12, self::PODGLAD_GLEBI => 13, self::BALANS_BIELI => 14, self::ZDJECIA_SERYJNE => 15, self::POLE_WIDZENIA => 16, self::KORPUS => 17, self::BATERIE => 18, self::CENA => 19, self::SLUG => 20, self::PRODUCENT_ID => 21, self::MATRYCA_ID => 22, ),
		BasePeer::TYPE_FIELDNAME => array ('aparat_id' => 0, 'model' => 1, 'typ' => 2, 'megapixel' => 3, 'lcd' => 4, 'wymiar_matrycy' => 5, 'pamiec' => 6, 'mocowanie_obiektywu' => 7, 'mnoznik_ogniskowej' => 8, 'stabilizacja_obrazu' => 9, 'migawka' => 10, 'czulosc' => 11, 'autobraketing' => 12, 'podglad_glebi' => 13, 'balans_bieli' => 14, 'zdjecia_seryjne' => 15, 'pole_widzenia' => 16, 'korpus' => 17, 'baterie' => 18, 'cena' => 19, 'slug' => 20, 'producent_id' => 21, 'matryca_id' => 22, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, )
	);

	/**
	 * Get a (singleton) instance of the MapBuilder for this peer class.
	 * @return     MapBuilder The map builder for this peer
	 */
	public static function getMapBuilder()
	{
		if (self::$mapBuilder === null) {
			self::$mapBuilder = new AparatMapBuilder();
		}
		return self::$mapBuilder;
	}
	/**
	 * Translates a fieldname to another type
	 *
	 * @param      string $name field name
	 * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @param      string $toType   One of the class type constants
	 * @return     string translated name of the field.
	 * @throws     PropelException - if the specified name could not be found in the fieldname mappings.
	 */
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	/**
	 * Returns an array of field names.
	 *
	 * @param      string $type The type of fieldnames to return:
	 *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     array A list of field names
	 */

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	/**
	 * Convenience method which changes table.column to alias.column.
	 *
	 * Using this method you can maintain SQL abstraction while using column aliases.
	 * <code>
	 *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
	 *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
	 * </code>
	 * @param      string $alias The alias for the current table.
	 * @param      string $column The column name for current table. (i.e. AparatPeer::COLUMN_NAME).
	 * @return     string
	 */
	public static function alias($alias, $column)
	{
		return str_replace(AparatPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	/**
	 * Add all the columns needed to create a new object.
	 *
	 * Note: any columns that were marked with lazyLoad="true" in the
	 * XML schema will not be added to the select list and only loaded
	 * on demand.
	 *
	 * @param      criteria object containing the columns to add.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(AparatPeer::APARAT_ID);

		$criteria->addSelectColumn(AparatPeer::MODEL);

		$criteria->addSelectColumn(AparatPeer::TYP);

		$criteria->addSelectColumn(AparatPeer::MEGAPIXEL);

		$criteria->addSelectColumn(AparatPeer::LCD);

		$criteria->addSelectColumn(AparatPeer::WYMIAR_MATRYCY);

		$criteria->addSelectColumn(AparatPeer::PAMIEC);

		$criteria->addSelectColumn(AparatPeer::MOCOWANIE_OBIEKTYWU);

		$criteria->addSelectColumn(AparatPeer::MNOZNIK_OGNISKOWEJ);

		$criteria->addSelectColumn(AparatPeer::STABILIZACJA_OBRAZU);

		$criteria->addSelectColumn(AparatPeer::MIGAWKA);

		$criteria->addSelectColumn(AparatPeer::CZULOSC);

		$criteria->addSelectColumn(AparatPeer::AUTOBRAKETING);

		$criteria->addSelectColumn(AparatPeer::PODGLAD_GLEBI);

		$criteria->addSelectColumn(AparatPeer::BALANS_BIELI);

		$criteria->addSelectColumn(AparatPeer::ZDJECIA_SERYJNE);

		$criteria->addSelectColumn(AparatPeer::POLE_WIDZENIA);

		$criteria->addSelectColumn(AparatPeer::KORPUS);

		$criteria->addSelectColumn(AparatPeer::BATERIE);

		$criteria->addSelectColumn(AparatPeer::CENA);

		$criteria->addSelectColumn(AparatPeer::SLUG);

		$criteria->addSelectColumn(AparatPeer::PRODUCENT_ID);

		$criteria->addSelectColumn(AparatPeer::MATRYCA_ID);

	}

	/**
	 * Returns the number of rows matching criteria.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
	 * @param      PropelPDO $con
	 * @return     int Number of matching rows.
	 */
	public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
	{
		// we may modify criteria, so copy it first
		$criteria = clone $criteria;

		// We need to set the primary table name, since in the case that there are no WHERE columns
		// it will be impossible for the BasePeer::createSelectSql() method to determine which
		// tables go into the FROM clause.
		$criteria->setPrimaryTableName(AparatPeer::TABLE_NAME);

		if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->setDistinct();
		}

		if (!$criteria->hasSelectClause()) {
			AparatPeer::addSelectColumns($criteria);
		}

		$criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
		$criteria->setDbName(self::DATABASE_NAME); // Set the correct dbName

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}
		// BasePeer returns a PDOStatement
		$stmt = BasePeer::doCount($criteria, $con);

		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$count = (int) $row[0];
		} else {
			$count = 0; // no rows returned; we infer that means 0 matches.
		}
		$stmt->closeCursor();
		return $count;
	}
	/**
	 * Method to select one object from the DB.
	 *
	 * @param      Criteria $criteria object used to create the SELECT statement.
	 * @param      PropelPDO $con
	 * @return     Aparat
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = AparatPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	/**
	 * Method to do selects.
	 *
	 * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
	 * @param      PropelPDO $con
	 * @return     array Array of selected Objects
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelect(Criteria $criteria, PropelPDO $con = null)
	{
		return AparatPeer::populateObjects(AparatPeer::doSelectStmt($criteria, $con));
	}
	/**
	 * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
	 *
	 * Use this method directly if you want to work with an executed statement durirectly (for example
	 * to perform your own object hydration).
	 *
	 * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
	 * @param      PropelPDO $con The connection to use
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 * @return     PDOStatement The executed PDOStatement object.
	 * @see        BasePeer::doSelect()
	 */
	public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		if (!$criteria->hasSelectClause()) {
			$criteria = clone $criteria;
			AparatPeer::addSelectColumns($criteria);
		}

		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		// BasePeer returns a PDOStatement
		return BasePeer::doSelect($criteria, $con);
	}
	/**
	 * Adds an object to the instance pool.
	 *
	 * Propel keeps cached copies of objects in an instance pool when they are retrieved
	 * from the database.  In some cases -- especially when you override doSelect*()
	 * methods in your stub classes -- you may need to explicitly add objects
	 * to the cache in order to ensure that the same objects are always returned by doSelect*()
	 * and retrieveByPK*() calls.
	 *
	 * @param      Aparat $value A Aparat object.
	 * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
	 */
	public static function addInstanceToPool(Aparat $obj, $key = null)
	{
		if (Propel::isInstancePoolingEnabled()) {
			if ($key === null) {
				$key = (string) $obj->getAparatId();
			} // if key === null
			self::$instances[$key] = $obj;
		}
	}

	/**
	 * Removes an object from the instance pool.
	 *
	 * Propel keeps cached copies of objects in an instance pool when they are retrieved
	 * from the database.  In some cases -- especially when you override doDelete
	 * methods in your stub classes -- you may need to explicitly remove objects
	 * from the cache in order to prevent returning objects that no longer exist.
	 *
	 * @param      mixed $value A Aparat object or a primary key value.
	 */
	public static function removeInstanceFromPool($value)
	{
		if (Propel::isInstancePoolingEnabled() && $value !== null) {
			if (is_object($value) && $value instanceof Aparat) {
				$key = (string) $value->getAparatId();
			} elseif (is_scalar($value)) {
				// assume we've been passed a primary key
				$key = (string) $value;
			} else {
				$e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Aparat object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
				throw $e;
			}

			unset(self::$instances[$key]);
		}
	} // removeInstanceFromPool()

	/**
	 * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
	 *
	 * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
	 * a multi-column primary key, a serialize()d version of the primary key will be returned.
	 *
	 * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
	 * @return     Aparat Found object or NULL if 1) no instance exists for specified key or 2) instance pooling has been disabled.
	 * @see        getPrimaryKeyHash()
	 */
	public static function getInstanceFromPool($key)
	{
		if (Propel::isInstancePoolingEnabled()) {
			if (isset(self::$instances[$key])) {
				return self::$instances[$key];
			}
		}
		return null; // just to be explicit
	}
	
	/**
	 * Clear the instance pool.
	 *
	 * @return     void
	 */
	public static function clearInstancePool()
	{
		self::$instances = array();
	}
	
	/**
	 * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
	 *
	 * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
	 * a multi-column primary key, a serialize()d version of the primary key will be returned.
	 *
	 * @param      array $row PropelPDO resultset row.
	 * @param      int $startcol The 0-based offset for reading from the resultset row.
	 * @return     string A string version of PK or NULL if the components of primary key in result array are all null.
	 */
	public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
	{
		// If the PK cannot be derived from the row, return NULL.
		if ($row[$startcol + 0] === null) {
			return null;
		}
		return (string) $row[$startcol + 0];
	}

	/**
	 * The returned array will contain objects of the default type or
	 * objects that inherit from the default.
	 *
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function populateObjects(PDOStatement $stmt)
	{
		$results = array();
	
		// set the class once to avoid overhead in the loop
		$cls = AparatPeer::getOMClass();
		$cls = substr('.'.$cls, strrpos('.'.$cls, '.') + 1);
		// populate the object(s)
		while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$key = AparatPeer::getPrimaryKeyHashFromRow($row, 0);
			if (null !== ($obj = AparatPeer::getInstanceFromPool($key))) {
				// We no longer rehydrate the object, since this can cause data loss.
				// See http://propel.phpdb.org/trac/ticket/509
				// $obj->hydrate($row, 0, true); // rehydrate
				$results[] = $obj;
			} else {
		
				$obj = new $cls();
				$obj->hydrate($row);
				$results[] = $obj;
				AparatPeer::addInstanceToPool($obj, $key);
			} // if key exists
		}
		$stmt->closeCursor();
		return $results;
	}

	/**
	 * Returns the number of rows matching criteria, joining the related Producent table
	 *
	 * @param      Criteria $c
	 * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     int Number of matching rows.
	 */
	public static function doCountJoinProducent(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		// we're going to modify criteria, so copy it first
		$criteria = clone $criteria;

		// We need to set the primary table name, since in the case that there are no WHERE columns
		// it will be impossible for the BasePeer::createSelectSql() method to determine which
		// tables go into the FROM clause.
		$criteria->setPrimaryTableName(AparatPeer::TABLE_NAME);

		if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->setDistinct();
		}

		if (!$criteria->hasSelectClause()) {
			AparatPeer::addSelectColumns($criteria);
		}
		
		$criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
		
		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		$criteria->addJoin(array(AparatPeer::PRODUCENT_ID,), array(ProducentPeer::PRODUCENT_ID,), $join_behavior);
		$stmt = BasePeer::doCount($criteria, $con);

		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$count = (int) $row[0];
		} else {
			$count = 0; // no rows returned; we infer that means 0 matches.
		}
		$stmt->closeCursor();
		return $count;
	}


	/**
	 * Returns the number of rows matching criteria, joining the related Matryca table
	 *
	 * @param      Criteria $c
	 * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     int Number of matching rows.
	 */
	public static function doCountJoinMatryca(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		// we're going to modify criteria, so copy it first
		$criteria = clone $criteria;

		// We need to set the primary table name, since in the case that there are no WHERE columns
		// it will be impossible for the BasePeer::createSelectSql() method to determine which
		// tables go into the FROM clause.
		$criteria->setPrimaryTableName(AparatPeer::TABLE_NAME);

		if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->setDistinct();
		}

		if (!$criteria->hasSelectClause()) {
			AparatPeer::addSelectColumns($criteria);
		}
		
		$criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
		
		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		$criteria->addJoin(array(AparatPeer::MATRYCA_ID,), array(MatrycaPeer::MATRYCA_ID,), $join_behavior);
		$stmt = BasePeer::doCount($criteria, $con);

		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$count = (int) $row[0];
		} else {
			$count = 0; // no rows returned; we infer that means 0 matches.
		}
		$stmt->closeCursor();
		return $count;
	}


	/**
	 * Selects a collection of Aparat objects pre-filled with their Producent objects.
	 * @param      Criteria  $c
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     array Array of Aparat objects.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectJoinProducent(Criteria $c, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		$c = clone $c;

		// Set the correct dbName if it has not been overridden
		if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		AparatPeer::addSelectColumns($c);
		$startcol = (AparatPeer::NUM_COLUMNS - AparatPeer::NUM_LAZY_LOAD_COLUMNS);
		ProducentPeer::addSelectColumns($c);

		$c->addJoin(array(AparatPeer::PRODUCENT_ID,), array(ProducentPeer::PRODUCENT_ID,), $join_behavior);
		$stmt = BasePeer::doSelect($c, $con);
		$results = array();

		while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$key1 = AparatPeer::getPrimaryKeyHashFromRow($row, 0);
			if (null !== ($obj1 = AparatPeer::getInstanceFromPool($key1))) {
				// We no longer rehydrate the object, since this can cause data loss.
				// See http://propel.phpdb.org/trac/ticket/509
				// $obj1->hydrate($row, 0, true); // rehydrate
			} else {

				$omClass = AparatPeer::getOMClass();

				$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
				$obj1 = new $cls();
				$obj1->hydrate($row);
				AparatPeer::addInstanceToPool($obj1, $key1);
			} // if $obj1 already loaded

			$key2 = ProducentPeer::getPrimaryKeyHashFromRow($row, $startcol);
			if ($key2 !== null) {
				$obj2 = ProducentPeer::getInstanceFromPool($key2);
				if (!$obj2) {

					$omClass = ProducentPeer::getOMClass();

					$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
					$obj2 = new $cls();
					$obj2->hydrate($row, $startcol);
					ProducentPeer::addInstanceToPool($obj2, $key2);
				} // if obj2 already loaded

				// Add the $obj1 (Aparat) to $obj2 (Producent)
				$obj2->addAparat($obj1);

			} // if joined row was not null

			$results[] = $obj1;
		}
		$stmt->closeCursor();
		return $results;
	}


	/**
	 * Selects a collection of Aparat objects pre-filled with their Matryca objects.
	 * @param      Criteria  $c
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     array Array of Aparat objects.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectJoinMatryca(Criteria $c, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		$c = clone $c;

		// Set the correct dbName if it has not been overridden
		if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		AparatPeer::addSelectColumns($c);
		$startcol = (AparatPeer::NUM_COLUMNS - AparatPeer::NUM_LAZY_LOAD_COLUMNS);
		MatrycaPeer::addSelectColumns($c);

		$c->addJoin(array(AparatPeer::MATRYCA_ID,), array(MatrycaPeer::MATRYCA_ID,), $join_behavior);
		$stmt = BasePeer::doSelect($c, $con);
		$results = array();

		while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$key1 = AparatPeer::getPrimaryKeyHashFromRow($row, 0);
			if (null !== ($obj1 = AparatPeer::getInstanceFromPool($key1))) {
				// We no longer rehydrate the object, since this can cause data loss.
				// See http://propel.phpdb.org/trac/ticket/509
				// $obj1->hydrate($row, 0, true); // rehydrate
			} else {

				$omClass = AparatPeer::getOMClass();

				$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
				$obj1 = new $cls();
				$obj1->hydrate($row);
				AparatPeer::addInstanceToPool($obj1, $key1);
			} // if $obj1 already loaded

			$key2 = MatrycaPeer::getPrimaryKeyHashFromRow($row, $startcol);
			if ($key2 !== null) {
				$obj2 = MatrycaPeer::getInstanceFromPool($key2);
				if (!$obj2) {

					$omClass = MatrycaPeer::getOMClass();

					$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
					$obj2 = new $cls();
					$obj2->hydrate($row, $startcol);
					MatrycaPeer::addInstanceToPool($obj2, $key2);
				} // if obj2 already loaded

				// Add the $obj1 (Aparat) to $obj2 (Matryca)
				$obj2->addAparat($obj1);

			} // if joined row was not null

			$results[] = $obj1;
		}
		$stmt->closeCursor();
		return $results;
	}


	/**
	 * Returns the number of rows matching criteria, joining all related tables
	 *
	 * @param      Criteria $c
	 * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     int Number of matching rows.
	 */
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		// we're going to modify criteria, so copy it first
		$criteria = clone $criteria;

		// We need to set the primary table name, since in the case that there are no WHERE columns
		// it will be impossible for the BasePeer::createSelectSql() method to determine which
		// tables go into the FROM clause.
		$criteria->setPrimaryTableName(AparatPeer::TABLE_NAME);

		if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->setDistinct();
		}

		if (!$criteria->hasSelectClause()) {
			AparatPeer::addSelectColumns($criteria);
		}
		
		$criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
		
		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		$criteria->addJoin(array(AparatPeer::PRODUCENT_ID,), array(ProducentPeer::PRODUCENT_ID,), $join_behavior);
		$criteria->addJoin(array(AparatPeer::MATRYCA_ID,), array(MatrycaPeer::MATRYCA_ID,), $join_behavior);
		$stmt = BasePeer::doCount($criteria, $con);

		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$count = (int) $row[0];
		} else {
			$count = 0; // no rows returned; we infer that means 0 matches.
		}
		$stmt->closeCursor();
		return $count;
	}

	/**
	 * Selects a collection of Aparat objects pre-filled with all related objects.
	 *
	 * @param      Criteria  $c
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     array Array of Aparat objects.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectJoinAll(Criteria $c, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		$c = clone $c;

		// Set the correct dbName if it has not been overridden
		if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		AparatPeer::addSelectColumns($c);
		$startcol2 = (AparatPeer::NUM_COLUMNS - AparatPeer::NUM_LAZY_LOAD_COLUMNS);

		ProducentPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + (ProducentPeer::NUM_COLUMNS - ProducentPeer::NUM_LAZY_LOAD_COLUMNS);

		MatrycaPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + (MatrycaPeer::NUM_COLUMNS - MatrycaPeer::NUM_LAZY_LOAD_COLUMNS);

		$c->addJoin(array(AparatPeer::PRODUCENT_ID,), array(ProducentPeer::PRODUCENT_ID,), $join_behavior);
		$c->addJoin(array(AparatPeer::MATRYCA_ID,), array(MatrycaPeer::MATRYCA_ID,), $join_behavior);
		$stmt = BasePeer::doSelect($c, $con);
		$results = array();

		while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$key1 = AparatPeer::getPrimaryKeyHashFromRow($row, 0);
			if (null !== ($obj1 = AparatPeer::getInstanceFromPool($key1))) {
				// We no longer rehydrate the object, since this can cause data loss.
				// See http://propel.phpdb.org/trac/ticket/509
				// $obj1->hydrate($row, 0, true); // rehydrate
			} else {
				$omClass = AparatPeer::getOMClass();

				$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
				$obj1 = new $cls();
				$obj1->hydrate($row);
				AparatPeer::addInstanceToPool($obj1, $key1);
			} // if obj1 already loaded

			// Add objects for joined Producent rows

			$key2 = ProducentPeer::getPrimaryKeyHashFromRow($row, $startcol2);
			if ($key2 !== null) {
				$obj2 = ProducentPeer::getInstanceFromPool($key2);
				if (!$obj2) {

					$omClass = ProducentPeer::getOMClass();


					$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
					$obj2 = new $cls();
					$obj2->hydrate($row, $startcol2);
					ProducentPeer::addInstanceToPool($obj2, $key2);
				} // if obj2 loaded

				// Add the $obj1 (Aparat) to the collection in $obj2 (Producent)
				$obj2->addAparat($obj1);
			} // if joined row not null

			// Add objects for joined Matryca rows

			$key3 = MatrycaPeer::getPrimaryKeyHashFromRow($row, $startcol3);
			if ($key3 !== null) {
				$obj3 = MatrycaPeer::getInstanceFromPool($key3);
				if (!$obj3) {

					$omClass = MatrycaPeer::getOMClass();


					$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
					$obj3 = new $cls();
					$obj3->hydrate($row, $startcol3);
					MatrycaPeer::addInstanceToPool($obj3, $key3);
				} // if obj3 loaded

				// Add the $obj1 (Aparat) to the collection in $obj3 (Matryca)
				$obj3->addAparat($obj1);
			} // if joined row not null

			$results[] = $obj1;
		}
		$stmt->closeCursor();
		return $results;
	}


	/**
	 * Returns the number of rows matching criteria, joining the related Producent table
	 *
	 * @param      Criteria $c
	 * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     int Number of matching rows.
	 */
	public static function doCountJoinAllExceptProducent(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		// we're going to modify criteria, so copy it first
		$criteria = clone $criteria;

		// We need to set the primary table name, since in the case that there are no WHERE columns
		// it will be impossible for the BasePeer::createSelectSql() method to determine which
		// tables go into the FROM clause.
		$criteria->setPrimaryTableName(AparatPeer::TABLE_NAME);
		
		if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->setDistinct();
		}

		if (!$criteria->hasSelectClause()) {
			AparatPeer::addSelectColumns($criteria);
		}
		
		$criteria->clearOrderByColumns(); // ORDER BY should not affect count
		
		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}
	
				$criteria->addJoin(array(AparatPeer::MATRYCA_ID,), array(MatrycaPeer::MATRYCA_ID,), $join_behavior);
		$stmt = BasePeer::doCount($criteria, $con);

		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$count = (int) $row[0];
		} else {
			$count = 0; // no rows returned; we infer that means 0 matches.
		}
		$stmt->closeCursor();
		return $count;
	}


	/**
	 * Returns the number of rows matching criteria, joining the related Matryca table
	 *
	 * @param      Criteria $c
	 * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     int Number of matching rows.
	 */
	public static function doCountJoinAllExceptMatryca(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		// we're going to modify criteria, so copy it first
		$criteria = clone $criteria;

		// We need to set the primary table name, since in the case that there are no WHERE columns
		// it will be impossible for the BasePeer::createSelectSql() method to determine which
		// tables go into the FROM clause.
		$criteria->setPrimaryTableName(AparatPeer::TABLE_NAME);
		
		if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->setDistinct();
		}

		if (!$criteria->hasSelectClause()) {
			AparatPeer::addSelectColumns($criteria);
		}
		
		$criteria->clearOrderByColumns(); // ORDER BY should not affect count
		
		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}
	
				$criteria->addJoin(array(AparatPeer::PRODUCENT_ID,), array(ProducentPeer::PRODUCENT_ID,), $join_behavior);
		$stmt = BasePeer::doCount($criteria, $con);

		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$count = (int) $row[0];
		} else {
			$count = 0; // no rows returned; we infer that means 0 matches.
		}
		$stmt->closeCursor();
		return $count;
	}


	/**
	 * Selects a collection of Aparat objects pre-filled with all related objects except Producent.
	 *
	 * @param      Criteria  $c
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     array Array of Aparat objects.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectJoinAllExceptProducent(Criteria $c, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		$c = clone $c;

		// Set the correct dbName if it has not been overridden
		// $c->getDbName() will return the same object if not set to another value
		// so == check is okay and faster
		if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		AparatPeer::addSelectColumns($c);
		$startcol2 = (AparatPeer::NUM_COLUMNS - AparatPeer::NUM_LAZY_LOAD_COLUMNS);

		MatrycaPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + (MatrycaPeer::NUM_COLUMNS - MatrycaPeer::NUM_LAZY_LOAD_COLUMNS);

				$c->addJoin(array(AparatPeer::MATRYCA_ID,), array(MatrycaPeer::MATRYCA_ID,), $join_behavior);

		$stmt = BasePeer::doSelect($c, $con);
		$results = array();

		while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$key1 = AparatPeer::getPrimaryKeyHashFromRow($row, 0);
			if (null !== ($obj1 = AparatPeer::getInstanceFromPool($key1))) {
				// We no longer rehydrate the object, since this can cause data loss.
				// See http://propel.phpdb.org/trac/ticket/509
				// $obj1->hydrate($row, 0, true); // rehydrate
			} else {
				$omClass = AparatPeer::getOMClass();

				$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
				$obj1 = new $cls();
				$obj1->hydrate($row);
				AparatPeer::addInstanceToPool($obj1, $key1);
			} // if obj1 already loaded

				// Add objects for joined Matryca rows

				$key2 = MatrycaPeer::getPrimaryKeyHashFromRow($row, $startcol2);
				if ($key2 !== null) {
					$obj2 = MatrycaPeer::getInstanceFromPool($key2);
					if (!$obj2) {
	
						$omClass = MatrycaPeer::getOMClass();


					$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
					$obj2 = new $cls();
					$obj2->hydrate($row, $startcol2);
					MatrycaPeer::addInstanceToPool($obj2, $key2);
				} // if $obj2 already loaded

				// Add the $obj1 (Aparat) to the collection in $obj2 (Matryca)
				$obj2->addAparat($obj1);

			} // if joined row is not null

			$results[] = $obj1;
		}
		$stmt->closeCursor();
		return $results;
	}


	/**
	 * Selects a collection of Aparat objects pre-filled with all related objects except Matryca.
	 *
	 * @param      Criteria  $c
	 * @param      PropelPDO $con
	 * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
	 * @return     array Array of Aparat objects.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectJoinAllExceptMatryca(Criteria $c, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		$c = clone $c;

		// Set the correct dbName if it has not been overridden
		// $c->getDbName() will return the same object if not set to another value
		// so == check is okay and faster
		if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		AparatPeer::addSelectColumns($c);
		$startcol2 = (AparatPeer::NUM_COLUMNS - AparatPeer::NUM_LAZY_LOAD_COLUMNS);

		ProducentPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + (ProducentPeer::NUM_COLUMNS - ProducentPeer::NUM_LAZY_LOAD_COLUMNS);

				$c->addJoin(array(AparatPeer::PRODUCENT_ID,), array(ProducentPeer::PRODUCENT_ID,), $join_behavior);

		$stmt = BasePeer::doSelect($c, $con);
		$results = array();

		while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$key1 = AparatPeer::getPrimaryKeyHashFromRow($row, 0);
			if (null !== ($obj1 = AparatPeer::getInstanceFromPool($key1))) {
				// We no longer rehydrate the object, since this can cause data loss.
				// See http://propel.phpdb.org/trac/ticket/509
				// $obj1->hydrate($row, 0, true); // rehydrate
			} else {
				$omClass = AparatPeer::getOMClass();

				$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
				$obj1 = new $cls();
				$obj1->hydrate($row);
				AparatPeer::addInstanceToPool($obj1, $key1);
			} // if obj1 already loaded

				// Add objects for joined Producent rows

				$key2 = ProducentPeer::getPrimaryKeyHashFromRow($row, $startcol2);
				if ($key2 !== null) {
					$obj2 = ProducentPeer::getInstanceFromPool($key2);
					if (!$obj2) {
	
						$omClass = ProducentPeer::getOMClass();


					$cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);
					$obj2 = new $cls();
					$obj2->hydrate($row, $startcol2);
					ProducentPeer::addInstanceToPool($obj2, $key2);
				} // if $obj2 already loaded

				// Add the $obj1 (Aparat) to the collection in $obj2 (Producent)
				$obj2->addAparat($obj1);

			} // if joined row is not null

			$results[] = $obj1;
		}
		$stmt->closeCursor();
		return $results;
	}

	/**
	 * Returns the TableMap related to this peer.
	 * This method is not needed for general use but a specific application could have a need.
	 * @return     TableMap
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	/**
	 * The class that the Peer will make instances of.
	 *
	 * This uses a dot-path notation which is tranalted into a path
	 * relative to a location on the PHP include_path.
	 * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
	 *
	 * @return     string path.to.ClassName
	 */
	public static function getOMClass()
	{
		return AparatPeer::CLASS_DEFAULT;
	}

	/**
	 * Method perform an INSERT on the database, given a Aparat or Criteria object.
	 *
	 * @param      mixed $values Criteria or Aparat object containing data that is used to create the INSERT statement.
	 * @param      PropelPDO $con the PropelPDO connection to use
	 * @return     mixed The new primary key.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doInsert($values, PropelPDO $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; // rename for clarity
		} else {
			$criteria = $values->buildCriteria(); // build Criteria from Aparat object
		}

		if ($criteria->containsKey(AparatPeer::APARAT_ID) && $criteria->keyContainsValue(AparatPeer::APARAT_ID) ) {
			throw new PropelException('Cannot insert a value for auto-increment primary key ('.AparatPeer::APARAT_ID.')');
		}


		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		try {
			// use transaction because $criteria could contain info
			// for more than one table (I guess, conceivably)
			$con->beginTransaction();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollBack();
			throw $e;
		}

		return $pk;
	}

	/**
	 * Method perform an UPDATE on the database, given a Aparat or Criteria object.
	 *
	 * @param      mixed $values Criteria or Aparat object containing data that is used to create the UPDATE statement.
	 * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
	 * @return     int The number of affected rows (if supported by underlying database driver).
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doUpdate($values, PropelPDO $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; // rename for clarity

			$comparison = $criteria->getComparison(AparatPeer::APARAT_ID);
			$selectCriteria->add(AparatPeer::APARAT_ID, $criteria->remove(AparatPeer::APARAT_ID), $comparison);

		} else { // $values is Aparat object
			$criteria = $values->buildCriteria(); // gets full criteria
			$selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
		}

		// set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		return BasePeer::doUpdate($selectCriteria, $criteria, $con);
	}

	/**
	 * Method to DELETE all rows from the aparat table.
	 *
	 * @return     int The number of affected rows (if supported by underlying database driver).
	 */
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		$affectedRows = 0; // initialize var to track total num of affected rows
		try {
			// use transaction because $criteria could contain info
			// for more than one table or we could emulating ON DELETE CASCADE, etc.
			$con->beginTransaction();
			$affectedRows += BasePeer::doDeleteAll(AparatPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Method perform a DELETE on the database, given a Aparat or Criteria object OR a primary key value.
	 *
	 * @param      mixed $values Criteria or Aparat object or primary key or array of primary keys
	 *              which is used to create the DELETE statement
	 * @param      PropelPDO $con the connection to use
	 * @return     int 	The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
	 *				if supported by native driver or if emulated using Propel.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	 public static function doDelete($values, PropelPDO $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}

		if ($values instanceof Criteria) {
			// invalidate the cache for all objects of this type, since we have no
			// way of knowing (without running a query) what objects should be invalidated
			// from the cache based on this Criteria.
			AparatPeer::clearInstancePool();

			// rename for clarity
			$criteria = clone $values;
		} elseif ($values instanceof Aparat) {
			// invalidate the cache for this single object
			AparatPeer::removeInstanceFromPool($values);
			// create criteria based on pk values
			$criteria = $values->buildPkeyCriteria();
		} else {
			// it must be the primary key



			$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(AparatPeer::APARAT_ID, (array) $values, Criteria::IN);

			foreach ((array) $values as $singleval) {
				// we can invalidate the cache for this single object
				AparatPeer::removeInstanceFromPool($singleval);
			}
		}

		// Set the correct dbName
		$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; // initialize var to track total num of affected rows

		try {
			// use transaction because $criteria could contain info
			// for more than one table or we could emulating ON DELETE CASCADE, etc.
			$con->beginTransaction();
			
			$affectedRows += BasePeer::doDelete($criteria, $con);

			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Validates all modified columns of given Aparat object.
	 * If parameter $columns is either a single column name or an array of column names
	 * than only those columns are validated.
	 *
	 * NOTICE: This does not apply to primary or foreign keys for now.
	 *
	 * @param      Aparat $obj The object to validate.
	 * @param      mixed $cols Column name or array of column names.
	 *
	 * @return     mixed TRUE if all columns are valid or the error message of the first invalid column.
	 */
	public static function doValidate(Aparat $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(AparatPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(AparatPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach ($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		return BasePeer::doValidate(AparatPeer::DATABASE_NAME, AparatPeer::TABLE_NAME, $columns);
	}

	/**
	 * Retrieve a single object by pkey.
	 *
	 * @param      int $pk the primary key.
	 * @param      PropelPDO $con the connection to use
	 * @return     Aparat
	 */
	public static function retrieveByPK($pk, PropelPDO $con = null)
	{

		if (null !== ($obj = AparatPeer::getInstanceFromPool((string) $pk))) {
			return $obj;
		}

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		$criteria = new Criteria(AparatPeer::DATABASE_NAME);
		$criteria->add(AparatPeer::APARAT_ID, $pk);

		$v = AparatPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	/**
	 * Retrieve multiple objects by pkey.
	 *
	 * @param      array $pks List of primary keys
	 * @param      PropelPDO $con the connection to use
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function retrieveByPKs($pks, PropelPDO $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria(AparatPeer::DATABASE_NAME);
			$criteria->add(AparatPeer::APARAT_ID, $pks, Criteria::IN);
			$objs = AparatPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} // BaseAparatPeer

// This is the static code needed to register the MapBuilder for this table with the main Propel class.
//
// NOTE: This static code cannot call methods on the AparatPeer class, because it is not defined yet.
// If you need to use overridden methods, you can add this code to the bottom of the AparatPeer class:
//
// Propel::getDatabaseMap(AparatPeer::DATABASE_NAME)->addTableBuilder(AparatPeer::TABLE_NAME, AparatPeer::getMapBuilder());
//
// Doing so will effectively overwrite the registration below.

Propel::getDatabaseMap(BaseAparatPeer::DATABASE_NAME)->addTableBuilder(BaseAparatPeer::TABLE_NAME, BaseAparatPeer::getMapBuilder());

