<?php

/**
 * Base class that represents a row from the 'aparat' table.
 *
 * 
 *
 * @package    aparatyfoto.om
 */
abstract class BaseAparat extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        AparatPeer
	 */
	protected static $peer;

	/**
	 * The value for the aparat_id field.
	 * @var        int
	 */
	protected $aparat_id;

	/**
	 * The value for the model field.
	 * @var        string
	 */
	protected $model;

	/**
	 * The value for the typ field.
	 * @var        string
	 */
	protected $typ;

	/**
	 * The value for the megapixel field.
	 * @var        string
	 */
	protected $megapixel;

	/**
	 * The value for the lcd field.
	 * @var        string
	 */
	protected $lcd;

	/**
	 * The value for the wymiar_matrycy field.
	 * @var        string
	 */
	protected $wymiar_matrycy;

	/**
	 * The value for the pamiec field.
	 * @var        string
	 */
	protected $pamiec;

	/**
	 * The value for the mocowanie_obiektywu field.
	 * @var        string
	 */
	protected $mocowanie_obiektywu;

	/**
	 * The value for the mnoznik_ogniskowej field.
	 * @var        string
	 */
	protected $mnoznik_ogniskowej;

	/**
	 * The value for the stabilizacja_obrazu field.
	 * @var        string
	 */
	protected $stabilizacja_obrazu;

	/**
	 * The value for the migawka field.
	 * @var        string
	 */
	protected $migawka;

	/**
	 * The value for the czulosc field.
	 * @var        string
	 */
	protected $czulosc;

	/**
	 * The value for the autobraketing field.
	 * @var        string
	 */
	protected $autobraketing;

	/**
	 * The value for the podglad_glebi field.
	 * @var        string
	 */
	protected $podglad_glebi;

	/**
	 * The value for the balans_bieli field.
	 * @var        string
	 */
	protected $balans_bieli;

	/**
	 * The value for the zdjecia_seryjne field.
	 * @var        string
	 */
	protected $zdjecia_seryjne;

	/**
	 * The value for the pole_widzenia field.
	 * @var        string
	 */
	protected $pole_widzenia;

	/**
	 * The value for the korpus field.
	 * @var        string
	 */
	protected $korpus;

	/**
	 * The value for the baterie field.
	 * @var        string
	 */
	protected $baterie;

	/**
	 * The value for the cena field.
	 * @var        string
	 */
	protected $cena;

	/**
	 * The value for the slug field.
	 * @var        string
	 */
	protected $slug;

	/**
	 * The value for the producent_id field.
	 * @var        int
	 */
	protected $producent_id;

	/**
	 * The value for the matryca_id field.
	 * @var        int
	 */
	protected $matryca_id;

	/**
	 * @var        Producent
	 */
	protected $aProducent;

	/**
	 * @var        Matryca
	 */
	protected $aMatryca;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseAparat object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [aparat_id] column value.
	 * 
	 * @return     int
	 */
	public function getAparatId()
	{
		return $this->aparat_id;
	}

	/**
	 * Get the [model] column value.
	 * 
	 * @return     string
	 */
	public function getModel()
	{
		return $this->model;
	}

	/**
	 * Get the [typ] column value.
	 * 
	 * @return     string
	 */
	public function getTyp()
	{
		return $this->typ;
	}

	/**
	 * Get the [megapixel] column value.
	 * 
	 * @return     string
	 */
	public function getMegapixel()
	{
		return $this->megapixel;
	}

	/**
	 * Get the [lcd] column value.
	 * 
	 * @return     string
	 */
	public function getLcd()
	{
		return $this->lcd;
	}

	/**
	 * Get the [wymiar_matrycy] column value.
	 * 
	 * @return     string
	 */
	public function getWymiarMatrycy()
	{
		return $this->wymiar_matrycy;
	}

	/**
	 * Get the [pamiec] column value.
	 * 
	 * @return     string
	 */
	public function getPamiec()
	{
		return $this->pamiec;
	}

	/**
	 * Get the [mocowanie_obiektywu] column value.
	 * 
	 * @return     string
	 */
	public function getMocowanieObiektywu()
	{
		return $this->mocowanie_obiektywu;
	}

	/**
	 * Get the [mnoznik_ogniskowej] column value.
	 * 
	 * @return     string
	 */
	public function getMnoznikOgniskowej()
	{
		return $this->mnoznik_ogniskowej;
	}

	/**
	 * Get the [stabilizacja_obrazu] column value.
	 * 
	 * @return     string
	 */
	public function getStabilizacjaObrazu()
	{
		return $this->stabilizacja_obrazu;
	}

	/**
	 * Get the [migawka] column value.
	 * 
	 * @return     string
	 */
	public function getMigawka()
	{
		return $this->migawka;
	}

	/**
	 * Get the [czulosc] column value.
	 * 
	 * @return     string
	 */
	public function getCzulosc()
	{
		return $this->czulosc;
	}

	/**
	 * Get the [autobraketing] column value.
	 * 
	 * @return     string
	 */
	public function getAutobraketing()
	{
		return $this->autobraketing;
	}

	/**
	 * Get the [podglad_glebi] column value.
	 * 
	 * @return     string
	 */
	public function getPodgladGlebi()
	{
		return $this->podglad_glebi;
	}

	/**
	 * Get the [balans_bieli] column value.
	 * 
	 * @return     string
	 */
	public function getBalansBieli()
	{
		return $this->balans_bieli;
	}

	/**
	 * Get the [zdjecia_seryjne] column value.
	 * 
	 * @return     string
	 */
	public function getZdjeciaSeryjne()
	{
		return $this->zdjecia_seryjne;
	}

	/**
	 * Get the [pole_widzenia] column value.
	 * 
	 * @return     string
	 */
	public function getPoleWidzenia()
	{
		return $this->pole_widzenia;
	}

	/**
	 * Get the [korpus] column value.
	 * 
	 * @return     string
	 */
	public function getKorpus()
	{
		return $this->korpus;
	}

	/**
	 * Get the [baterie] column value.
	 * 
	 * @return     string
	 */
	public function getBaterie()
	{
		return $this->baterie;
	}

	/**
	 * Get the [cena] column value.
	 * 
	 * @return     string
	 */
	public function getCena()
	{
		return $this->cena;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Get the [producent_id] column value.
	 * 
	 * @return     int
	 */
	public function getProducentId()
	{
		return $this->producent_id;
	}

	/**
	 * Get the [matryca_id] column value.
	 * 
	 * @return     int
	 */
	public function getMatrycaId()
	{
		return $this->matryca_id;
	}

	/**
	 * Set the value of [aparat_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setAparatId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->aparat_id !== $v) {
			$this->aparat_id = $v;
			$this->modifiedColumns[] = AparatPeer::APARAT_ID;
		}

		return $this;
	} // setAparatId()

	/**
	 * Set the value of [model] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setModel($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->model !== $v) {
			$this->model = $v;
			$this->modifiedColumns[] = AparatPeer::MODEL;
		}

		return $this;
	} // setModel()

	/**
	 * Set the value of [typ] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setTyp($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->typ !== $v) {
			$this->typ = $v;
			$this->modifiedColumns[] = AparatPeer::TYP;
		}

		return $this;
	} // setTyp()

	/**
	 * Set the value of [megapixel] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setMegapixel($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->megapixel !== $v) {
			$this->megapixel = $v;
			$this->modifiedColumns[] = AparatPeer::MEGAPIXEL;
		}

		return $this;
	} // setMegapixel()

	/**
	 * Set the value of [lcd] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setLcd($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->lcd !== $v) {
			$this->lcd = $v;
			$this->modifiedColumns[] = AparatPeer::LCD;
		}

		return $this;
	} // setLcd()

	/**
	 * Set the value of [wymiar_matrycy] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setWymiarMatrycy($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->wymiar_matrycy !== $v) {
			$this->wymiar_matrycy = $v;
			$this->modifiedColumns[] = AparatPeer::WYMIAR_MATRYCY;
		}

		return $this;
	} // setWymiarMatrycy()

	/**
	 * Set the value of [pamiec] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setPamiec($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->pamiec !== $v) {
			$this->pamiec = $v;
			$this->modifiedColumns[] = AparatPeer::PAMIEC;
		}

		return $this;
	} // setPamiec()

	/**
	 * Set the value of [mocowanie_obiektywu] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setMocowanieObiektywu($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->mocowanie_obiektywu !== $v) {
			$this->mocowanie_obiektywu = $v;
			$this->modifiedColumns[] = AparatPeer::MOCOWANIE_OBIEKTYWU;
		}

		return $this;
	} // setMocowanieObiektywu()

	/**
	 * Set the value of [mnoznik_ogniskowej] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setMnoznikOgniskowej($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->mnoznik_ogniskowej !== $v) {
			$this->mnoznik_ogniskowej = $v;
			$this->modifiedColumns[] = AparatPeer::MNOZNIK_OGNISKOWEJ;
		}

		return $this;
	} // setMnoznikOgniskowej()

	/**
	 * Set the value of [stabilizacja_obrazu] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setStabilizacjaObrazu($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->stabilizacja_obrazu !== $v) {
			$this->stabilizacja_obrazu = $v;
			$this->modifiedColumns[] = AparatPeer::STABILIZACJA_OBRAZU;
		}

		return $this;
	} // setStabilizacjaObrazu()

	/**
	 * Set the value of [migawka] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setMigawka($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->migawka !== $v) {
			$this->migawka = $v;
			$this->modifiedColumns[] = AparatPeer::MIGAWKA;
		}

		return $this;
	} // setMigawka()

	/**
	 * Set the value of [czulosc] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setCzulosc($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->czulosc !== $v) {
			$this->czulosc = $v;
			$this->modifiedColumns[] = AparatPeer::CZULOSC;
		}

		return $this;
	} // setCzulosc()

	/**
	 * Set the value of [autobraketing] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setAutobraketing($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->autobraketing !== $v) {
			$this->autobraketing = $v;
			$this->modifiedColumns[] = AparatPeer::AUTOBRAKETING;
		}

		return $this;
	} // setAutobraketing()

	/**
	 * Set the value of [podglad_glebi] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setPodgladGlebi($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->podglad_glebi !== $v) {
			$this->podglad_glebi = $v;
			$this->modifiedColumns[] = AparatPeer::PODGLAD_GLEBI;
		}

		return $this;
	} // setPodgladGlebi()

	/**
	 * Set the value of [balans_bieli] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setBalansBieli($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->balans_bieli !== $v) {
			$this->balans_bieli = $v;
			$this->modifiedColumns[] = AparatPeer::BALANS_BIELI;
		}

		return $this;
	} // setBalansBieli()

	/**
	 * Set the value of [zdjecia_seryjne] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setZdjeciaSeryjne($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->zdjecia_seryjne !== $v) {
			$this->zdjecia_seryjne = $v;
			$this->modifiedColumns[] = AparatPeer::ZDJECIA_SERYJNE;
		}

		return $this;
	} // setZdjeciaSeryjne()

	/**
	 * Set the value of [pole_widzenia] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setPoleWidzenia($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->pole_widzenia !== $v) {
			$this->pole_widzenia = $v;
			$this->modifiedColumns[] = AparatPeer::POLE_WIDZENIA;
		}

		return $this;
	} // setPoleWidzenia()

	/**
	 * Set the value of [korpus] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setKorpus($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->korpus !== $v) {
			$this->korpus = $v;
			$this->modifiedColumns[] = AparatPeer::KORPUS;
		}

		return $this;
	} // setKorpus()

	/**
	 * Set the value of [baterie] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setBaterie($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->baterie !== $v) {
			$this->baterie = $v;
			$this->modifiedColumns[] = AparatPeer::BATERIE;
		}

		return $this;
	} // setBaterie()

	/**
	 * Set the value of [cena] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setCena($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->cena !== $v) {
			$this->cena = $v;
			$this->modifiedColumns[] = AparatPeer::CENA;
		}

		return $this;
	} // setCena()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      string $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = AparatPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Set the value of [producent_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setProducentId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->producent_id !== $v) {
			$this->producent_id = $v;
			$this->modifiedColumns[] = AparatPeer::PRODUCENT_ID;
		}

		if ($this->aProducent !== null && $this->aProducent->getProducentId() !== $v) {
			$this->aProducent = null;
		}

		return $this;
	} // setProducentId()

	/**
	 * Set the value of [matryca_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Aparat The current object (for fluent API support)
	 */
	public function setMatrycaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->matryca_id !== $v) {
			$this->matryca_id = $v;
			$this->modifiedColumns[] = AparatPeer::MATRYCA_ID;
		}

		if ($this->aMatryca !== null && $this->aMatryca->getMatrycaId() !== $v) {
			$this->aMatryca = null;
		}

		return $this;
	} // setMatrycaId()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->aparat_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->model = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->typ = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->megapixel = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->lcd = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->wymiar_matrycy = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->pamiec = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
			$this->mocowanie_obiektywu = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
			$this->mnoznik_ogniskowej = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
			$this->stabilizacja_obrazu = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
			$this->migawka = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
			$this->czulosc = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
			$this->autobraketing = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
			$this->podglad_glebi = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
			$this->balans_bieli = ($row[$startcol + 14] !== null) ? (string) $row[$startcol + 14] : null;
			$this->zdjecia_seryjne = ($row[$startcol + 15] !== null) ? (string) $row[$startcol + 15] : null;
			$this->pole_widzenia = ($row[$startcol + 16] !== null) ? (string) $row[$startcol + 16] : null;
			$this->korpus = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
			$this->baterie = ($row[$startcol + 18] !== null) ? (string) $row[$startcol + 18] : null;
			$this->cena = ($row[$startcol + 19] !== null) ? (string) $row[$startcol + 19] : null;
			$this->slug = ($row[$startcol + 20] !== null) ? (string) $row[$startcol + 20] : null;
			$this->producent_id = ($row[$startcol + 21] !== null) ? (int) $row[$startcol + 21] : null;
			$this->matryca_id = ($row[$startcol + 22] !== null) ? (int) $row[$startcol + 22] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 23; // 23 = AparatPeer::NUM_COLUMNS - AparatPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Aparat object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aProducent !== null && $this->producent_id !== $this->aProducent->getProducentId()) {
			$this->aProducent = null;
		}
		if ($this->aMatryca !== null && $this->matryca_id !== $this->aMatryca->getMatrycaId()) {
			$this->aMatryca = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = AparatPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aProducent = null;
			$this->aMatryca = null;
		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			AparatPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AparatPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			AparatPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aProducent !== null) {
				if ($this->aProducent->isModified() || $this->aProducent->isNew()) {
					$affectedRows += $this->aProducent->save($con);
				}
				$this->setProducent($this->aProducent);
			}

			if ($this->aMatryca !== null) {
				if ($this->aMatryca->isModified() || $this->aMatryca->isNew()) {
					$affectedRows += $this->aMatryca->save($con);
				}
				$this->setMatryca($this->aMatryca);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = AparatPeer::APARAT_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = AparatPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setAparatId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += AparatPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aProducent !== null) {
				if (!$this->aProducent->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProducent->getValidationFailures());
				}
			}

			if ($this->aMatryca !== null) {
				if (!$this->aMatryca->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aMatryca->getValidationFailures());
				}
			}


			if (($retval = AparatPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AparatPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getAparatId();
				break;
			case 1:
				return $this->getModel();
				break;
			case 2:
				return $this->getTyp();
				break;
			case 3:
				return $this->getMegapixel();
				break;
			case 4:
				return $this->getLcd();
				break;
			case 5:
				return $this->getWymiarMatrycy();
				break;
			case 6:
				return $this->getPamiec();
				break;
			case 7:
				return $this->getMocowanieObiektywu();
				break;
			case 8:
				return $this->getMnoznikOgniskowej();
				break;
			case 9:
				return $this->getStabilizacjaObrazu();
				break;
			case 10:
				return $this->getMigawka();
				break;
			case 11:
				return $this->getCzulosc();
				break;
			case 12:
				return $this->getAutobraketing();
				break;
			case 13:
				return $this->getPodgladGlebi();
				break;
			case 14:
				return $this->getBalansBieli();
				break;
			case 15:
				return $this->getZdjeciaSeryjne();
				break;
			case 16:
				return $this->getPoleWidzenia();
				break;
			case 17:
				return $this->getKorpus();
				break;
			case 18:
				return $this->getBaterie();
				break;
			case 19:
				return $this->getCena();
				break;
			case 20:
				return $this->getSlug();
				break;
			case 21:
				return $this->getProducentId();
				break;
			case 22:
				return $this->getMatrycaId();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = AparatPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getAparatId(),
			$keys[1] => $this->getModel(),
			$keys[2] => $this->getTyp(),
			$keys[3] => $this->getMegapixel(),
			$keys[4] => $this->getLcd(),
			$keys[5] => $this->getWymiarMatrycy(),
			$keys[6] => $this->getPamiec(),
			$keys[7] => $this->getMocowanieObiektywu(),
			$keys[8] => $this->getMnoznikOgniskowej(),
			$keys[9] => $this->getStabilizacjaObrazu(),
			$keys[10] => $this->getMigawka(),
			$keys[11] => $this->getCzulosc(),
			$keys[12] => $this->getAutobraketing(),
			$keys[13] => $this->getPodgladGlebi(),
			$keys[14] => $this->getBalansBieli(),
			$keys[15] => $this->getZdjeciaSeryjne(),
			$keys[16] => $this->getPoleWidzenia(),
			$keys[17] => $this->getKorpus(),
			$keys[18] => $this->getBaterie(),
			$keys[19] => $this->getCena(),
			$keys[20] => $this->getSlug(),
			$keys[21] => $this->getProducentId(),
			$keys[22] => $this->getMatrycaId(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AparatPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setAparatId($value);
				break;
			case 1:
				$this->setModel($value);
				break;
			case 2:
				$this->setTyp($value);
				break;
			case 3:
				$this->setMegapixel($value);
				break;
			case 4:
				$this->setLcd($value);
				break;
			case 5:
				$this->setWymiarMatrycy($value);
				break;
			case 6:
				$this->setPamiec($value);
				break;
			case 7:
				$this->setMocowanieObiektywu($value);
				break;
			case 8:
				$this->setMnoznikOgniskowej($value);
				break;
			case 9:
				$this->setStabilizacjaObrazu($value);
				break;
			case 10:
				$this->setMigawka($value);
				break;
			case 11:
				$this->setCzulosc($value);
				break;
			case 12:
				$this->setAutobraketing($value);
				break;
			case 13:
				$this->setPodgladGlebi($value);
				break;
			case 14:
				$this->setBalansBieli($value);
				break;
			case 15:
				$this->setZdjeciaSeryjne($value);
				break;
			case 16:
				$this->setPoleWidzenia($value);
				break;
			case 17:
				$this->setKorpus($value);
				break;
			case 18:
				$this->setBaterie($value);
				break;
			case 19:
				$this->setCena($value);
				break;
			case 20:
				$this->setSlug($value);
				break;
			case 21:
				$this->setProducentId($value);
				break;
			case 22:
				$this->setMatrycaId($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AparatPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setAparatId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setModel($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setTyp($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setMegapixel($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setLcd($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setWymiarMatrycy($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setPamiec($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setMocowanieObiektywu($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setMnoznikOgniskowej($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setStabilizacjaObrazu($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setMigawka($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setCzulosc($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setAutobraketing($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setPodgladGlebi($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setBalansBieli($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setZdjeciaSeryjne($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setPoleWidzenia($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setKorpus($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setBaterie($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setCena($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setSlug($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setProducentId($arr[$keys[21]]);
		if (array_key_exists($keys[22], $arr)) $this->setMatrycaId($arr[$keys[22]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(AparatPeer::DATABASE_NAME);

		if ($this->isColumnModified(AparatPeer::APARAT_ID)) $criteria->add(AparatPeer::APARAT_ID, $this->aparat_id);
		if ($this->isColumnModified(AparatPeer::MODEL)) $criteria->add(AparatPeer::MODEL, $this->model);
		if ($this->isColumnModified(AparatPeer::TYP)) $criteria->add(AparatPeer::TYP, $this->typ);
		if ($this->isColumnModified(AparatPeer::MEGAPIXEL)) $criteria->add(AparatPeer::MEGAPIXEL, $this->megapixel);
		if ($this->isColumnModified(AparatPeer::LCD)) $criteria->add(AparatPeer::LCD, $this->lcd);
		if ($this->isColumnModified(AparatPeer::WYMIAR_MATRYCY)) $criteria->add(AparatPeer::WYMIAR_MATRYCY, $this->wymiar_matrycy);
		if ($this->isColumnModified(AparatPeer::PAMIEC)) $criteria->add(AparatPeer::PAMIEC, $this->pamiec);
		if ($this->isColumnModified(AparatPeer::MOCOWANIE_OBIEKTYWU)) $criteria->add(AparatPeer::MOCOWANIE_OBIEKTYWU, $this->mocowanie_obiektywu);
		if ($this->isColumnModified(AparatPeer::MNOZNIK_OGNISKOWEJ)) $criteria->add(AparatPeer::MNOZNIK_OGNISKOWEJ, $this->mnoznik_ogniskowej);
		if ($this->isColumnModified(AparatPeer::STABILIZACJA_OBRAZU)) $criteria->add(AparatPeer::STABILIZACJA_OBRAZU, $this->stabilizacja_obrazu);
		if ($this->isColumnModified(AparatPeer::MIGAWKA)) $criteria->add(AparatPeer::MIGAWKA, $this->migawka);
		if ($this->isColumnModified(AparatPeer::CZULOSC)) $criteria->add(AparatPeer::CZULOSC, $this->czulosc);
		if ($this->isColumnModified(AparatPeer::AUTOBRAKETING)) $criteria->add(AparatPeer::AUTOBRAKETING, $this->autobraketing);
		if ($this->isColumnModified(AparatPeer::PODGLAD_GLEBI)) $criteria->add(AparatPeer::PODGLAD_GLEBI, $this->podglad_glebi);
		if ($this->isColumnModified(AparatPeer::BALANS_BIELI)) $criteria->add(AparatPeer::BALANS_BIELI, $this->balans_bieli);
		if ($this->isColumnModified(AparatPeer::ZDJECIA_SERYJNE)) $criteria->add(AparatPeer::ZDJECIA_SERYJNE, $this->zdjecia_seryjne);
		if ($this->isColumnModified(AparatPeer::POLE_WIDZENIA)) $criteria->add(AparatPeer::POLE_WIDZENIA, $this->pole_widzenia);
		if ($this->isColumnModified(AparatPeer::KORPUS)) $criteria->add(AparatPeer::KORPUS, $this->korpus);
		if ($this->isColumnModified(AparatPeer::BATERIE)) $criteria->add(AparatPeer::BATERIE, $this->baterie);
		if ($this->isColumnModified(AparatPeer::CENA)) $criteria->add(AparatPeer::CENA, $this->cena);
		if ($this->isColumnModified(AparatPeer::SLUG)) $criteria->add(AparatPeer::SLUG, $this->slug);
		if ($this->isColumnModified(AparatPeer::PRODUCENT_ID)) $criteria->add(AparatPeer::PRODUCENT_ID, $this->producent_id);
		if ($this->isColumnModified(AparatPeer::MATRYCA_ID)) $criteria->add(AparatPeer::MATRYCA_ID, $this->matryca_id);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AparatPeer::DATABASE_NAME);

		$criteria->add(AparatPeer::APARAT_ID, $this->aparat_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getAparatId();
	}

	/**
	 * Generic method to set the primary key (aparat_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setAparatId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Aparat (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setModel($this->model);

		$copyObj->setTyp($this->typ);

		$copyObj->setMegapixel($this->megapixel);

		$copyObj->setLcd($this->lcd);

		$copyObj->setWymiarMatrycy($this->wymiar_matrycy);

		$copyObj->setPamiec($this->pamiec);

		$copyObj->setMocowanieObiektywu($this->mocowanie_obiektywu);

		$copyObj->setMnoznikOgniskowej($this->mnoznik_ogniskowej);

		$copyObj->setStabilizacjaObrazu($this->stabilizacja_obrazu);

		$copyObj->setMigawka($this->migawka);

		$copyObj->setCzulosc($this->czulosc);

		$copyObj->setAutobraketing($this->autobraketing);

		$copyObj->setPodgladGlebi($this->podglad_glebi);

		$copyObj->setBalansBieli($this->balans_bieli);

		$copyObj->setZdjeciaSeryjne($this->zdjecia_seryjne);

		$copyObj->setPoleWidzenia($this->pole_widzenia);

		$copyObj->setKorpus($this->korpus);

		$copyObj->setBaterie($this->baterie);

		$copyObj->setCena($this->cena);

		$copyObj->setSlug($this->slug);

		$copyObj->setProducentId($this->producent_id);

		$copyObj->setMatrycaId($this->matryca_id);


		$copyObj->setNew(true);

		$copyObj->setAparatId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Aparat Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     AparatPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AparatPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Producent object.
	 *
	 * @param      Producent $v
	 * @return     Aparat The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setProducent(Producent $v = null)
	{
		if ($v === null) {
			$this->setProducentId(NULL);
		} else {
			$this->setProducentId($v->getProducentId());
		}

		$this->aProducent = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Producent object, it will not be re-added.
		if ($v !== null) {
			$v->addAparat($this);
		}

		return $this;
	}


	/**
	 * Get the associated Producent object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Producent The associated Producent object.
	 * @throws     PropelException
	 */
	public function getProducent(PropelPDO $con = null)
	{
		if ($this->aProducent === null && ($this->producent_id !== null)) {
			$this->aProducent = ProducentPeer::retrieveByPK($this->producent_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aProducent->addAparats($this);
			 */
		}
		return $this->aProducent;
	}

	/**
	 * Declares an association between this object and a Matryca object.
	 *
	 * @param      Matryca $v
	 * @return     Aparat The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setMatryca(Matryca $v = null)
	{
		if ($v === null) {
			$this->setMatrycaId(NULL);
		} else {
			$this->setMatrycaId($v->getMatrycaId());
		}

		$this->aMatryca = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Matryca object, it will not be re-added.
		if ($v !== null) {
			$v->addAparat($this);
		}

		return $this;
	}


	/**
	 * Get the associated Matryca object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Matryca The associated Matryca object.
	 * @throws     PropelException
	 */
	public function getMatryca(PropelPDO $con = null)
	{
		if ($this->aMatryca === null && ($this->matryca_id !== null)) {
			$this->aMatryca = MatrycaPeer::retrieveByPK($this->matryca_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aMatryca->addAparats($this);
			 */
		}
		return $this->aMatryca;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
		} // if ($deep)

			$this->aProducent = null;
			$this->aMatryca = null;
	}

} // BaseAparat
