<?php

require 'aparatyfoto/om/BaseMatrycaPeer.php';

require_once 'slugs.inc.php';


/**
 * Skeleton subclass for performing query and update operations on the 'matryca' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    aparatyfoto
 */
class MatrycaPeer extends BaseMatrycaPeer {

    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(self::NAZWA);
        return parent::doSelect($criteria, $con);
    }

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }
    
    public function insertIfNotExists($str)
    {
        $c = new Criteria();
        $c->add(MatrycaPeer::NAZWA, $str);
        $obj = MatrycaPeer::doSelectOne($c);
        if (!$obj) {
            $obj = new Matryca();
            $obj->setNazwa($str);
            $obj->setSlug(string2slug($str));
            $obj->save();
        }
        return $obj;
    }




} // MatrycaPeer
