<?php

class Actions extends ActionsBase
{

    public function execute_showjpg()
    {
    
        $wymiary = array('mini', 'popup', 'max', 'preview');
       
        if (
            isset($_GET['numerdvd']) &&
            str_ivslug($_GET['numerdvd']) &&
            ($dvd = DvdPeer::retrieveByNumer($_GET['numerdvd'])) &&
            isset($_GET['rozmiar']) &&          
            in_array($_GET['rozmiar'], $wymiary) &&
            isset($_GET['kategoria']) &&
            str_ivslug($_GET['kategoria']) &&
            isset($_GET['slug']) &&  
            str_ivslug($_GET['slug']) &&
            ($kategoria = KategoriaPeer::retrieveBySlug($dvd->getDvdId(), $_GET['kategoria']))
        ) {    
            $this->noLayout();

            $c = new Criteria();
            $c->add(FotkaPeer::KATEGORIA_ID, $kategoria->getKategoriaId());
            $c->add(FotkaPeer::SLUG, $_GET['slug']);

            $fotka = FotkaPeer::doSelectOne($c);

            if ($fotka) {
                header('Content-Type: image/jpg');
                switch ($_GET['rozmiar']) {
                case 'mini':
                    echo stream_get_contents($fotka->getMini());                
                    break;
                
                case 'max':
                    echo stream_get_contents($fotka->getMax());                
                    break;
                
                case 'popup':
                    echo stream_get_contents($fotka->getPopup());                
                    break;
                    
                case 'preview':
                    echo stream_get_contents($fotka->getPreview());                
                    break;                    
                
                }


            };
            
        };
        
        $this->execute_404();
    }              
    
    
    public function execute_show()
    {
    
        if (
            isset($_GET['numerdvd']) &&
            str_ivslug($_GET['numerdvd']) &&
            ($dvd = DvdPeer::retrieveByNumer($_GET['numerdvd'])) &&
            isset($_GET['kategoria']) &&
            str_ivslug($_GET['kategoria']) &&
            isset($_GET['slug']) &&  
            str_ivslug($_GET['slug']) &&
            ($kategoria = KategoriaPeer::retrieveBySlug($dvd->getDvdId(), $_GET['kategoria']))
        ) {    
            $this->set('dvd', $dvd);
        
            $c = new Criteria();
            $c->add(FotkaPeer::KATEGORIA_ID, $kategoria->getKategoriaId());
            $c->add(FotkaPeer::SLUG, $_GET['slug']);

            $fotka = FotkaPeer::doSelectOne($c);

            if ($fotka) {
                $this->set('fotka', $fotka);
                $this->set('kategoria', $kategoria);                
                $this->set('kategorie', $dvd->getKategorias());                            
                
                $wskaznik_fotki = new WskaznikFotki($fotka, $kategoria);
                $this->set('wskaznik_fotki', $wskaznik_fotki->getPointers());
                
            } else {
                $this->execute_404();            
            }
            
        } else {
            $this->execute_404();        
        }
        
    }    
    
}