<?php


/**
 * This class adds structure of 'fotka' table to 'sklep' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    sklep.map
 */
class FotkaMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'sklep.map.FotkaMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(FotkaPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(FotkaPeer::TABLE_NAME);
		$tMap->setPhpName('Fotka');
		$tMap->setClassname('Fotka');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('FOTKA_ID', 'FotkaId', 'INTEGER', true, null);

		$tMap->addColumn('MAX', 'Max', 'BLOB', false, null);

		$tMap->addColumn('PREVIEW', 'Preview', 'BLOB', false, null);

		$tMap->addColumn('POPUP', 'Popup', 'BLOB', false, null);

		$tMap->addColumn('MINI', 'Mini', 'BLOB', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'INTEGER', false, null);

		$tMap->addForeignKey('KATEGORIA_ID', 'KategoriaId', 'INTEGER', 'kategoria', 'KATEGORIA_ID', false, null);

	} // doBuild()

} // FotkaMapBuilder
