<?php

require 'sklep/om/BaseDvdPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'dvd' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    sklep
 */
class DvdPeer extends BaseDvdPeer {


    public function usun($numer_plyty)
    {
        $c = new Criteria();
        $c->add(DvdPeer::NUMER, $numer_plyty);
        $dvd = DvdPeer::doSelectOne($c);
        if ($dvd) {
            $dvd->delete();
        }
    }
    
    public static function wstaw($dane)
    {
        $tmp = new Dvd();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }

    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(self::NUMER);                    
        return parent::doSelect($criteria, $con);
    }

    static public function retrieveByNumer($numerdvd)
    {
        $c = new Criteria();
        $c->add(self::NUMER, $numerdvd);
        return parent::doSelectOne($c);
    }
    
    static public function zliczRekordy()
    {
        $plyty = DvdPeer::doSelect(new Criteria());
        foreach ($plyty as $dvd) {
        
            $c = new Criteria();
            $c->add(KategoriaPeer::DVD_ID, $dvd->getDvdId());
            $liczbakategorii = KategoriaPeer::doCount($c);
            $dvd->setLiczbakategorii($liczbakategorii);
        
            $c = new Criteria();
            $c->add(DvdPeer::DVD_ID, $dvd->getDvdId());
            $c->addJoin(DvdPeer::DVD_ID, KategoriaPeer::DVD_ID);
            $c->addJoin(KategoriaPeer::KATEGORIA_ID, FotkaPeer::KATEGORIA_ID);
            $liczbafotek = FotkaPeer::doCount($c);
            $dvd->setLiczbafotek($liczbafotek);
            
            $dvd->save();
            
        }
    
    }
    


} // DvdPeer
