
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- dvd
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `dvd`;


CREATE TABLE `dvd`
(
	`dvd_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numer` INTEGER,
	`liczbafotek` INTEGER,
	`liczbakategorii` INTEGER,
	`datawydania` VARCHAR(128),
	`wydanie` VARCHAR(45),
	`okladka` LONGBLOB,
	`okladka_print` LONGBLOB,
	PRIMARY KEY (`dvd_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- kategoria
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kategoria`;


CREATE TABLE `kategoria`
(
	`kategoria_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128),
	`liczbafotek` INTEGER,
	`dvd_id` INTEGER,
	PRIMARY KEY (`kategoria_id`),
	INDEX `FI_kategoria_dvd1` (`dvd_id`),
	CONSTRAINT `fk_kategoria_dvd1`
		FOREIGN KEY (`dvd_id`)
		REFERENCES `dvd` (`dvd_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- fotka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `fotka`;


CREATE TABLE `fotka`
(
	`fotka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`max` LONGBLOB,
	`preview` LONGBLOB,
	`popup` LONGBLOB,
	`mini` LONGBLOB,
	`slug` INTEGER,
	`kategoria_id` INTEGER,
	PRIMARY KEY (`fotka_id`),
	INDEX `FI_fotka_kategoria1` (`kategoria_id`),
	CONSTRAINT `fk_fotka_kategoria1`
		FOREIGN KEY (`kategoria_id`)
		REFERENCES `kategoria` (`kategoria_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- menu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `menu`;


CREATE TABLE `menu`
(
	`menu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(128),
	`tresc` TEXT,
	`slug` VARCHAR(128),
	PRIMARY KEY (`menu_id`),
	UNIQUE KEY `menu_U_1` (`slug`(128))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
