<?php

class Actions extends ActionsBase
{
    public function execute_chmura()
    {
        $cloud = new HTML_TagCloud(30, 18);
    
        $c = new Criteria();
        $c->add(
            TagPeer::IMGS_COUNT,
            OGRANICZENIE_CHMURY,
            Criteria::GREATER_THAN
        );
    
        $tags = TagPeer::doSelect($c);

        
        foreach ($tags as $tag) {
            $cloud->addElement(
    	    $tag->getTag() . '(' . $tag->getImgsCount() . ')', 
    	    'index.php?module=tag&action=show&slug=' . $tag->getSlug() . '&page=1', 
    	    $tag->getImgsCount()
            );
        }
        
        $this->set('tags_cloud_html', $cloud->buildHTML());
    }
    
 
    public function execute_show()
    {    
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($tag = TagPeer::retrieveBySlug($_GET['slug']))                    
        ) {    
            $this->set('tag', $tag);
            
            if (isset($_GET['page'])) {    
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];                
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }
            
            $c = new Criteria();
            $c->add(TagPeer::TAG_ID, $tag->getTagId());
            $c->addJoin(ImgHasTagPeer::IMG_ID, ImgPeer::IMG_ID);
            $c->addJoin(TagPeer::TAG_ID, ImgHasTagPeer::TAG_ID);

            $pager = new Pager('Img', ILE_NA_STRONIE, $c);
            
            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                $pager->setBaseURL(
                    'index.php?module=tag&action=show&slug=' .
                    $tag->getSlug() . '&page='
                );
                $this->set('pager', $pager);            
            } else {
                $this->execute_404();
            }        

            
        } else {
            $this->execute_404();
        }    
    }
    
    public function execute_listaa()
    {
        $c = new Criteria();
        $c->addAscendingOrderByColumn(TagPeer::TAG);
        $tags = TagPeer::doSelect($c);
        $tags = array_1dim_to_2dimV($tags, LICZBA_KOLUMN);
        $this->set('tags', $tags['items']);
    }
    
    
    public function execute_listan()
    {
        $c = new Criteria();
        $c->addDescendingOrderByColumn(TagPeer::IMGS_COUNT);
        $tags = TagPeer::doSelect($c);
        $tags = array_1dim_to_2dimV($tags, LICZBA_KOLUMN);
        $this->set('tags', $tags['items']);
    }

    
    
}