<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'tcs/Turniej.php';
Propel::init('tcs-conf.php');

require_once 'slugs.inc.php';

ZawodnikPeer::doDeleteAll();
PanstwoPeer::doDeleteAll();
TurniejPeer::doDeleteAll();

$tcs = simplexml_load_file('tcs.xml');

foreach ($tcs->turniej as $turniej) {

    $dane_turnieju = array(
        'rok'  => $turniej->rok,
        'slug' => string2slug($turniej->rok)
    );
    
    $objTurniej = TurniejPeer::insertIfNotExists($dane_turnieju);

    foreach ($turniej->miejsce as $miejsce) {
    
    
        $dane_panstwa = array(
            'panstwo'  => $miejsce->sportowiec->panstwo,
            'slug' => string2slug($miejsce->sportowiec->panstwo)
        );
        
        $objPanstwo = PanstwoPeer::insertIfNotExists($dane_panstwa);
        
        $dane_zawodnika = array(
            'imie'     =>  $miejsce->sportowiec->imie,
            'nazwisko' => $miejsce->sportowiec->nazwisko,
            'panstwo_id' => $objPanstwo->getPanstwoId(),
            'slug' => string2slug($miejsce->sportowiec->nazwisko . ' ' . $miejsce->sportowiec->imie)
        );
        
        $objZawodnik = ZawodnikPeer::insertIfNotExists($dane_zawodnika);

        
        $thz = new TurniejHasZawodnik();
        $thz->setZawodnik($objZawodnik);
        $thz->setTurniej($objTurniej);
        $thz->setMiejsce($miejsce->numer);
        try {
            $thz->save();
        } catch (PropelException $e) {
            echo 'ERROR: ' . $e->getMessage() . "\n";
        }
        
    }
}