<?php


/**
 * This class adds structure of 'zawodnik' table to 'tcs' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    tcs.map
 */
class ZawodnikMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'tcs.map.ZawodnikMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ZawodnikPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ZawodnikPeer::TABLE_NAME);
		$tMap->setPhpName('Zawodnik');
		$tMap->setClassname('Zawodnik');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('ZAWODNIK_ID', 'ZawodnikId', 'INTEGER', true, null);

		$tMap->addColumn('IMIE', 'Imie', 'VARCHAR', false, 45);

		$tMap->addColumn('NAZWISKO', 'Nazwisko', 'VARCHAR', false, 45);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 128);

		$tMap->addForeignKey('PANSTWO_ID', 'PanstwoId', 'INTEGER', 'panstwo', 'PANSTWO_ID', false, null);

	} // doBuild()

} // ZawodnikMapBuilder
