<?php


/**
 * This class adds structure of 'turniej_has_zawodnik' table to 'tcs' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    tcs.map
 */
class TurniejHasZawodnikMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'tcs.map.TurniejHasZawodnikMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(TurniejHasZawodnikPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(TurniejHasZawodnikPeer::TABLE_NAME);
		$tMap->setPhpName('TurniejHasZawodnik');
		$tMap->setClassname('TurniejHasZawodnik');

		$tMap->setUseIdGenerator(false);

		$tMap->addForeignPrimaryKey('TURNIEJ_ID', 'TurniejId', 'INTEGER' , 'turniej', 'TURNIEJ_ID', true, null);

		$tMap->addForeignPrimaryKey('ZAWODNIK_ID', 'ZawodnikId', 'INTEGER' , 'zawodnik', 'ZAWODNIK_ID', true, null);

		$tMap->addColumn('MIEJSCE', 'Miejsce', 'INTEGER', false, null);

	} // doBuild()

} // TurniejHasZawodnikMapBuilder
