set names utf8;
drop database if exists noth;
create database noth default character set utf8 collate utf8_polish_ci;
grant all on noth.* to admin@localhost identified by 'password';
flush privileges;
use noth;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- menu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `menu`;


CREATE TABLE `menu`
(
	`menu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`tresc` TEXT,
	`slug` VARCHAR(128),
	PRIMARY KEY (`menu_id`),
	UNIQUE KEY `menu_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- pu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `pu`;


CREATE TABLE `pu`
(
	`pu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`tresc` TEXT,
	`slug` VARCHAR(128),
	PRIMARY KEY (`pu_id`),
	UNIQUE KEY `pu_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- skroty
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `skroty`;


CREATE TABLE `skroty`
(
	`skroty_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`slug` VARCHAR(128),
	PRIMARY KEY (`skroty_id`),
	UNIQUE KEY `skroty_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- skrot
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `skrot`;


CREATE TABLE `skrot`
(
	`skrot_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`skrot` VARCHAR(2),
	`opis` VARCHAR(255),
	`kod` VARCHAR(255),
	`grupa_id` INTEGER,
	PRIMARY KEY (`skrot_id`),
	INDEX `FI_skrot_grupa1` (`grupa_id`),
	CONSTRAINT `fk_skrot_grupa1`
		FOREIGN KEY (`grupa_id`)
		REFERENCES `grupa` (`grupa_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- grupa
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `grupa`;


CREATE TABLE `grupa`
(
	`grupa_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`skroty_id` INTEGER,
	PRIMARY KEY (`grupa_id`),
	INDEX `FI_grupa_skroty` (`skroty_id`),
	CONSTRAINT `fk_grupa_skroty`
		FOREIGN KEY (`skroty_id`)
		REFERENCES `skroty` (`skroty_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- img
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `img`;


CREATE TABLE `img`
(
	`img_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`slug` VARCHAR(128),
	`img` LONGBLOB,
	PRIMARY KEY (`img_id`),
	UNIQUE KEY `img_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- plik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `plik`;


CREATE TABLE `plik`
(
	`plik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`dane` LONGBLOB,
	`slug` VARCHAR(128),
	`typmime` VARCHAR(128),
	PRIMARY KEY (`plik_id`),
	UNIQUE KEY `plik_U_1` (`slug`(128))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
