set names utf8;
drop database if exists fotki;
create database fotki default character set utf8 collate utf8_polish_ci;
grant all on fotki.* to admin@localhost identified by 'password';
flush privileges;
use fotki;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- img
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `img`;


CREATE TABLE `img`
(
	`img_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`slug` VARCHAR(128),
	`img` LONGBLOB,
	PRIMARY KEY (`img_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
