<?php

require_once 'XML/Serializer.php';
require_once 'XML/Unserializer.php';
require_once 'Smarty.class.php';
require_once 'Spreadsheet/Excel/Writer.php';
require_once 'Excel/reader.php';
require_once 'pl.inc.php';


function newfilename($filename, $ext)
{
    return 'wyniki/' .
        preg_replace('/\.\w{3}$/', $ext, basename($filename));
}


function f_in_xml($str)
{
    $str = str_replace("\r", ' ', $str);
    $str = str_replace("\n", ' ', $str);
    $str = preg_replace('/ +/', ' ', $str);
    return trim($str);
}

function parse_xml($filename)
{
    $unserializer = new XML_Unserializer();

    $options = array(
        'tagMap' => array(
            'autor' => ''
        ),
        'encodeFunction' =>  'f_in_xml'
    );
    $unserializer->setOptions($options);
    $unserializer->unserialize(file_get_contents($filename));
    return $unserializer->getUnserializedData();
}



/*

function parse_xml($filename)
{
    $tmp = simplexml_load_file($filename);

    $w = array();
    $w['rocznik'] =  f_in_xml((string)$tmp->rok);
    $w['numer'] =  f_in_xml((string)$tmp->numer);
    $w['odstrony'] =  f_in_xml((string)$tmp->odstrony);
    $w['dostrony'] =  f_in_xml((string)$tmp->dostrony);
    $w['tytul'] =  f_in_xml((string)$tmp->tytul);
    $w['lid'] =  f_in_xml((string)$tmp->lid);
    $w['rubryka'] =  f_in_xml((string)$tmp->rubryka);
    $w['podrubryka'] =  f_in_xml((string)$tmp->podrubryka);
    
    $autorzy = array();
    
    $i = 0;
    
    while (isset($tmp->autorzy->autor[$i])) {
        $a = array();
        $a['imie'] = f_in_xml((string)$tmp->autorzy->autor[$i]->imie);
        $a['nazwisko'] = f_in_xml((string)$tmp->autorzy->autor[$i]->nazwisko);
        array_push($autorzy, $a);
        $i++;
    }
    
    $w['autorzy'] = $autorzy;
    return $w;
}
*/




function parse_txt($filename)
{
    $p = file($filename);

    $w = array();
        
    if (preg_match('/^ROK:(.*)$/', trim($p[0]), $m)) {
        $w['rocznik'] = trim($m[1]);
    } else {
        $w['rocznik'] = '';
    }
    
    if (preg_match('/^NUMER:(.*)$/', trim($p[1]), $m)) {
        $w['numer'] = trim($m[1]);
    } else {
        $w['numer'] = '';
    }    
    
    if (preg_match('/^STRONY:([0-9]+),([0-9]+)$/', trim($p[2]), $m)) {
        $w['odstrony'] = trim($m[1]);
        $w['dostrony'] = trim($m[2]);
    } else {
        $w['odstrony'] = '';
        $w['dostrony'] = '';
    }        
    
    if (preg_match('/^TYTUŁ:(.*)$/', trim($p[3]), $m)) {
        $w['tytul'] = trim($m[1]);
    } else {
        $w['tytul'] = '';
    }    
    
    if (preg_match('/^LID:(.*)$/', trim($p[4]), $m)) {
        $w['lid'] = trim($m[1]);
    } else {
        $w['lid'] = '';
    }        
    
    if (preg_match('/^RUBRYKA:(.*)$/', trim($p[5]), $m)) {
        $tmp = explode('.', $m[1]);
        $w['rubryka'] = trim($tmp[0]);
        $w['podrubryka'] = trim($tmp[1]);
    } else {
        $w['rubryka'] = '';
        $w['podrubryka'] = '';
    }           
    
    $autorzy = array();    
    if (preg_match('/^AUTOR:(.*)$/', trim($p[6]), $m)) {
        $a = $m[1];
        $tmp = explode(',', trim($a));
        foreach ($tmp as $tmp_autor) {
            $n = explode(' ', trim($tmp_autor));
            $autor = array();
            $autor['imie'] = trim($n[0]);
            $autor['nazwisko'] = trim($n[1]);
            array_push($autorzy, $autor);
        }
    };
    
    $w['autorzy'] = $autorzy;
    
    return $w;
}



function f_in_xls($str)
{
    $str = trim(pl_win2utf8($str));
    return $str;       
}


function parse_xls($filename)
{
    $xls = new Spreadsheet_Excel_Reader();
    $xls->setOutputEncoding('cp1250');
    $xls->read($filename);
    
    //lid
    if (!isset($xls->sheets[1]['cells'][1][1])) {
        $xls->sheets[1]['cells'][1][1] = '';
    }
    
    //podrubryka
    if (!isset($xls->sheets[0]['cells'][7][2])) {
        $xls->sheets[0]['cells'][7][2] = '';
    }    
    
    //imie pierwszego autora
    if (!isset($xls->sheets[0]['cells'][8][2])) {
        $xls->sheets[0]['cells'][8][2] = '-';
    }        
    
    //nazwisko pierwszego autora    
    if (!isset($xls->sheets[0]['cells'][8][3])) {
        $xls->sheets[0]['cells'][8][3] = '-';
    }            
    

    $w = array();
    $w['rocznik'] = f_in_xls($xls->sheets[0]['cells'][1][2]);
    $w['numer'] = f_in_xls($xls->sheets[0]['cells'][2][2]);    
    $w['odstrony'] = f_in_xls($xls->sheets[0]['cells'][3][2]);        
    $w['dostrony'] = f_in_xls($xls->sheets[0]['cells'][4][2]);            
    $w['tytul'] = f_in_xls($xls->sheets[0]['cells'][5][2]);            
    $w['lid'] = f_in_xls($xls->sheets[1]['cells'][1][1]);
    $w['rubryka'] = f_in_xls($xls->sheets[0]['cells'][6][2]);                
    $w['podrubryka'] = f_in_xls($xls->sheets[0]['cells'][7][2]);                
    
    $autorzy = array();
    $i = 0;
    while(
        isset($xls->sheets[0]['cells'][8 + $i][2]) &&
        isset($xls->sheets[0]['cells'][8 + $i][3]) &&
        trim($xls->sheets[0]['cells'][8 + $i][2]) &&        
        trim($xls->sheets[0]['cells'][8 + $i][3])
    ) {
        $autorzy[$i]['imie'] = f_in_xls($xls->sheets[0]['cells'][8 + $i][2]);                
        $autorzy[$i]['nazwisko'] = f_in_xls($xls->sheets[0]['cells'][8 + $i][3]);    
        $i++;
    }
    

    $w['autorzy'] = $autorzy;
    
    return $w;
}



function array2xml($a)
{
    $serializer = new XML_Serializer();
    $options = array(
        'addDecl'  => true,
        'indent'   => '    ',
        'rootName' => 'artykul',
        'encoding' => 'utf-8',
        'defaultTagName' => array(
            'autorzy' => 'autor'
        )
    );
    $serializer->setOptions($options);
    $serializer->serialize($a);
    return $serializer->getSerializedData();
}


function array2txt($a)
{
    $s = new Smarty();
    $s->assign('art', $a);
    $tmp = $s->fetch('txt.tpl');
    return $tmp;
}

function array2xls($article)
{
    $xls = new Spreadsheet_Excel_Writer($filename);
    $sheetArt = $xls->addWorksheet(pl_utf82win('Artykuł'));

    $sheetArt->setColumn(0, 0, 20);
    $sheetArt->setColumn(1, 1, 80);
    $sheetArt->setColumn(2, 2, 20);

    $format = $xls->addFormat();
    $format->setBold();
    $format->setSize('12');

    $sheetArt->write(0, 0, 'Rok', $format);
    $sheetArt->write(1, 0, 'Numer', $format);
    $sheetArt->write(2, 0, 'Od strony', $format);
    $sheetArt->write(3, 0, 'Do strony', $format);
    $sheetArt->write(4, 0, pl_utf82win('Tytuł'), $format);
    $sheetArt->write(5, 0, 'Rubryka', $format);
    $sheetArt->write(6, 0, 'Podrubryka', $format);
    $sheetArt->write(7, 0, 'Autor', $format);

    $sheetArt->write(0, 1, $article['rocznik']);
    $sheetArt->write(1, 1, $article['numer']);
    $sheetArt->write(2, 1, $article['odstrony']);
    $sheetArt->write(3, 1, $article['dostrony']);
    $sheetArt->write(4, 1, pl_utf82win($article['tytul']));
    $sheetArt->write(5, 1, pl_utf82win($article['rubryka']));
    $sheetArt->write(6, 1, pl_utf82win($article['podrubryka']));

    for ($i = 0; $i < count($article['autorzy']); $i++) {
        $sheetArt->write(7 + $i, 1, pl_utf82win($article['autorzy'][$i]['imie']));
        $sheetArt->write(7 + $i, 2, pl_utf82win($article['autorzy'][$i]['nazwisko']));
    }

    $format2 = $xls->addFormat();
    $format2->setTextWrap();

    $sheetLid = $xls->addWorksheet(pl_utf82win('Wstęp'));
    $sheetLid->setColumn(0, 0, 100);
    $sheetLid->setRow(0, 100);
    $sheetLid->write(0, 0, pl_utf82win($article['lid']), $format2);

    ob_start();
    $xls->close();
    $wynik = ob_get_clean();
    return $wynik;
}

