SET NAMES utf8 COLLATE utf8_polish_ci;

DROP DATABASE IF EXISTS studenci;

CREATE DATABASE studenci DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci;

GRANT
    ALL
ON
    studenci.*
TO
    studenciadm@localhost
IDENTIFIED BY
    'studencipass';

FLUSH PRIVILEGES;

USE studenci;
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- student
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `student`;


CREATE TABLE `student`
(
	`student_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45),
	`nazwisko` VARCHAR(45),
	`plec` VARCHAR(20),
	`wiek` INTEGER,
	`numerindeksu` VARCHAR(20),
	`kierunek` VARCHAR(20),
	PRIMARY KEY (`student_id`)
)Type=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 2.11.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 15 Maj 2008, 08:27
-- Wersja serwera: 5.0.45
-- Wersja PHP: 5.2.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Baza danych: `studenci`
--

--
-- Zrzut danych tabeli `student`
--

INSERT INTO `student` (`student_id`, `imie`, `nazwisko`, `plec`, `wiek`, `numerindeksu`, `kierunek`) VALUES(1, 'Piotr', 'Kowalski', 'M', 22, '431240312', 'matematyka');
INSERT INTO `student` (`student_id`, `imie`, `nazwisko`, `plec`, `wiek`, `numerindeksu`, `kierunek`) VALUES(2, 'Adam', 'Nowak', 'M', 23, '554235455', 'socjologia');
INSERT INTO `student` (`student_id`, `imie`, `nazwisko`, `plec`, `wiek`, `numerindeksu`, `kierunek`) VALUES(3, 'Anna', 'Jakakolwiek', 'K', 20, '5454235455', 'filozofia');
