<?php


class Actions extends ActionsBase
{

    public function execute_showimg()
    {
    
        $rodzaje = array('png', 'minipng', 'svg');
       
        if (
            isset($_GET['slug']) &&  
            str_ivslug($_GET['slug']) &&
            ($img = ImgPeer::retrieveBySlug($_GET['slug'])) &&        
            isset($_GET['rodzaj']) &&                      
            in_array($_GET['rodzaj'], $rodzaje)            
        ) {    
            switch ($_GET['rodzaj']) {
            case 'png':
                if ($img->getHasPreview()) {
                    header('Content-Type: image/png');            
                    echo stream_get_contents($img->getPng());                                
                    exit();
                };
                break;
            
            case 'minipng':
                if ($img->getHasPreview()) {
                    header('Content-Type: image/png');            
                    echo stream_get_contents($img->getMinipng());                                
                    exit();
                };
                break;
            
            case 'svg':
                header('Content-Type: image/svg+xml');            
                echo stream_get_contents($img->getSvg());                                
                exit();
                break;
            
            }
        };
        
        $this->execute_404();
    }              
    
    public function execute_show()
    {
    
        if (
            isset($_GET['slug']) &&  
            str_ivslug($_GET['slug']) &&
            ($img = ImgPeer::retrieveBySlug($_GET['slug']))
        ) {    
            $this->set('img', $img);
            
            $cloud = new HTML_TagCloud(30, 18);
            
            $ihts = $img->getImgHasTagsJoinTag();
            
            foreach ($ihts as $iht) {
                $cloud->addElement(
                    $iht->getTag()->getTag() . '(' . $iht->getTag()->getImgsCount() . ')',
                   'index.php?module=tag&action=show&slug=' . $iht->getTag()->getSlug() . '&page=1',
                    $iht->getTag()->getImgsCount()
                );
            }
            
            $this->set('tags_cloud_html', $cloud->buildHTML());

        } else {
        
            $this->execute_404();
                
        }

    }                  

}