<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        $kolumny = new TabelaPodrubryk();

        if ($kolumny->incorrectVars()) {
            $this->execute_404();
            return;
        } else if ($kolumny->correctVars()) {
            $kolumny->setIndex($_GET['orderslug']);
            $kolumny->setOrder($_GET['order']);
        }

        $kolumny->assignCurrent();
        $c = $kolumny->getCriteria();
        $kolumny->reverseOrder();
        $kolumny->addURLs('index.php?module=podrubryka&action=list');
        $this->set('kolumny', $kolumny->getColumns());

        if (isset($_GET['page'])) {
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Podrubryka', ILE_NA_STRONIE, $c);

        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();
            $pager->setBaseURL(
                'index.php?module=podrubryka&action=list&order=' .
                    $kolumny->getCurrentOrder() .
                    '&orderslug=' .
                    $kolumny->getIndex() .
                    '&page='
            );
            $this->set('pager', $pager);

        } else {
            $this->execute_404();
        }

    }


    public function execute_show()
    {
        if (
            str_ivslug($_GET['slug']) &&
            isset($_GET['slug']) &&
            ($podrubryka = PodrubrykaPeer::retrieveBySlug($_GET['slug']))
        ) {

            $this->set('podrubryka', $podrubryka);
            $wskaznik = new WskaznikPodrubryki($podrubryka);
            $this->set('wskaznik', $wskaznik->getPointers());


            $kolumny = new TabelaArtykulow();

            if ($kolumny->incorrectVars()) {
                $this->execute_404();
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);
                $kolumny->setOrder($_GET['order']);
            }

            $kolumny->assignCurrent();

            $c = $kolumny->getCriteria();
            $kolumny->reverseOrder();
            $kolumny->addURLs('index.php?module=podrubryka&action=show&slug=' . $podrubryka->getSlug());
            $this->set('kolumny', $kolumny->getColumns());

            if (isset($_GET['page'])) {
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }


            $c->addJoin(PodrubrykaPeer::PODRUBRYKA_ID, ArtykulPeer::PODRUBRYKA_ID);
            $c->add(PodrubrykaPeer::PODRUBRYKA_ID, $podrubryka->getPodrubrykaId());
            $pager = new Pager('Artykul', ILE_NA_STRONIE, $c);

            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                $pager->setBaseURL(
                    'index.php?module=podrubryka&action=show&slug=' . $podrubryka->getSlug() . '&order=' .
                        $kolumny->getCurrentOrder() .
                        '&orderslug=' .
                        $kolumny->getIndex() .
                        '&page='
                );
                $this->set('pager', $pager);

            } else {
                $this->execute_404();
            }


        } else {

            $this->execute_404();

        }


    }
   
    
}