
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- marka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `marka`;


CREATE TABLE `marka`
(
	`marka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`marka_id`),
	UNIQUE KEY `marka_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- model
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `model`;


CREATE TABLE `model`
(
	`model_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`marka_id` INTEGER  NOT NULL,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`model_id`),
	UNIQUE KEY `model_U_1` (`slug`(128)),
	INDEX `FI_model_marka` (`marka_id`),
	CONSTRAINT `fk_model_marka`
		FOREIGN KEY (`marka_id`)
		REFERENCES `marka` (`marka_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- wyposazenie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `wyposazenie`;


CREATE TABLE `wyposazenie`
(
	`wyposazenie_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`skrot` VARCHAR(20),
	`opis` VARCHAR(255),
	`slug` VARCHAR(20)  NOT NULL,
	PRIMARY KEY (`wyposazenie_id`),
	UNIQUE KEY `wyposazenie_U_1` (`slug`(20))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- auto
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `auto`;


CREATE TABLE `auto`
(
	`auto_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rocznik` INTEGER,
	`cena` INTEGER,
	`pojemnosc` FLOAT,
	`przebieg` INTEGER,
	`kolor` VARCHAR(255),
	`typ` VARCHAR(20),
	`paliwo` VARCHAR(20),
	`uwagi` TEXT,
	`slug` VARCHAR(255)  NOT NULL,
	`model_id` INTEGER  NOT NULL,
	PRIMARY KEY (`auto_id`),
	UNIQUE KEY `auto_U_1` (`slug`(255)),
	INDEX `FI_auto_model1` (`model_id`),
	CONSTRAINT `fk_auto_model1`
		FOREIGN KEY (`model_id`)
		REFERENCES `model` (`model_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- auto_has_wyposazenie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `auto_has_wyposazenie`;


CREATE TABLE `auto_has_wyposazenie`
(
	`auto_id` INTEGER  NOT NULL,
	`wyposazenie_id` INTEGER  NOT NULL,
	PRIMARY KEY (`auto_id`,`wyposazenie_id`),
	CONSTRAINT `fk_auto_has_wyposazenie_auto1`
		FOREIGN KEY (`auto_id`)
		REFERENCES `auto` (`auto_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_auto_has_wyposazenie_wyposazenie1` (`wyposazenie_id`),
	CONSTRAINT `fk_auto_has_wyposazenie_wyposazenie1`
		FOREIGN KEY (`wyposazenie_id`)
		REFERENCES `wyposazenie` (`wyposazenie_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
