<?php

require 'zengardencss/om/BasePlatforma.php';


/**
 * Skeleton subclass for representing a row from the 'platforma' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    zengardencss
 */
class Platforma extends BasePlatforma {

	/**
	 * Initializes internal state of Platforma object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	function liczbaProjektow()
	{
	    $id = $this->getPlatformaId();

            $connection = Propel::getConnection();
            $query = "
            
                select count(distinct(projekt_id)) from projekt 
                    left join projekt_has_czcionka using(projekt_id)
                    left join czcionka using(czcionka_id)
                where czcionka_id in 
                    (select czcionka_id from czcionka where platforma_id = {$id})

            ";

            $statement = $connection->prepare($query);
            $statement->execute();
            $result = $statement->fetch(PDO::FETCH_NUM);
            
            return $result[0];
	}
	
	
	function ustalLiczbeProjektow()
	{
	    $this->setLiczbaprojektow($this->liczbaProjektow());
        $this->save();
	}
	
	function ustalLiczbeCzcionek()
	{
        $c = new Criteria();
        $c->add(CzcionkaPeer::PLATFORMA_ID, $this->getPlatformaId());
        $liczba_czcionek = PlatformaPeer::doCount($c);
        $this->setLiczbaczcionek($liczba_czcionek);
        $this->save();
	}
	
	

	
	
	public function __toString()
	{
	    return $this->getNazwa();
	}	
	

} // Platforma
