<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        $kolumny = new TabelaAutorow();

        if ($kolumny->incorrectVars()) {
            $this->execute_404();
            return;
        } else if ($kolumny->correctVars()) {
            $kolumny->setIndex($_GET['orderslug']);
            $kolumny->setOrder($_GET['order']);
        }

        $kolumny->assignCurrent();
        $c = $kolumny->getCriteria();
        $kolumny->reverseOrder();
        $kolumny->addURLs('index.php?module=autor&action=list');
        $this->set('kolumny', $kolumny->getColumns());
        
        if (isset($_GET['page'])) {
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Autor', ILE_NA_STRONIE, $c);

        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();
            $pager->setBaseURL(
                'index.php?module=autor&action=list&order=' .
                    $kolumny->getCurrentOrder() .
                    '&orderslug=' .
                    $kolumny->getIndex() .
                    '&page='
            );
            
            $this->set('pager', $pager);
            
        } else {
            $this->execute_404();
        }

    }              
    
    
    public function execute_show()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($autor = AutorPeer::retrieveBySlug($_GET['slug']))
        ) {

            $this->set('autor', $autor);
            $wskaznik = new WskaznikAutora($autor);
            $this->set('wskaznik', $wskaznik->getPointers());
            

            $kolumny = new TabelaArtykulow();

            if ($kolumny->incorrectVars()) {
                $this->execute_404();
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);
                $kolumny->setOrder($_GET['order']);
            }

            $kolumny->assignCurrent();
            $c = $kolumny->getCriteria();
            $kolumny->reverseOrder();
            $kolumny->addURLs('index.php?module=autor&action=show&slug=' . $autor->getSlug());
            $this->set('kolumny', $kolumny->getColumns());
            
            if (isset($_GET['page'])) {
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }


            $c->addJoin(ArtykulPeer::ARTYKUL_ID, ArtykulHasAutorPeer::ARTYKUL_ID);
            $c->addJoin(ArtykulHasAutorPeer::AUTOR_ID, AutorPeer::AUTOR_ID);
            $c->add(AutorPeer::AUTOR_ID, $autor->getAutorId());

            $pager = new Pager('Artykul', ILE_NA_STRONIE, $c);

            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                
                $pager->setBaseURL(
                    'index.php?module=autor&action=show&slug=' . $autor->getSlug() . '&order=' .
                        $kolumny->getCurrentOrder() .
                        '&orderslug=' .
                        $kolumny->getIndex() .
                        '&page='
                );

                $this->set('pager', $pager);
                
            } else {
                $this->execute_404();
            }


        } else {

            $this->execute_404();

        }
    }
   
    
}