<?php



class WskaznikRubryki extends Pointer
{

    protected function getFirst()
    {
        $c = new Criteria();
        $c->setLimit(1);
        $c->addAscendingOrderByColumn(RubrykaPeer::RUBRYKA);
        if ($tmp = RubrykaPeer::doSelectOne($c)) {
            $this->ptr_first = $tmp;
            if ($this->ptr_current && ($this->ptr_first->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_first = false;
            }
        }    
    }
    
    
    protected function getPrevious()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->add(RubrykaPeer::RUBRYKA, $this->ptr_current->getRubryka(), Criteria::LESS_THAN);
            $c->setLimit(1);
            $c->addDescendingOrderByColumn(RubrykaPeer::RUBRYKA);
            if ($tmp = RubrykaPeer::doSelectOne($c)) {
                $this->ptr_previous = $tmp;
            }            
        };    
    }    
    
    protected function getNext()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->add(RubrykaPeer::RUBRYKA, $this->ptr_current->getRubryka(), Criteria::GREATER_THAN);
            $c->setLimit(1);          
            $c->addAscendingOrderByColumn(RubrykaPeer::RUBRYKA);
            if ($tmp = RubrykaPeer::doSelectOne($c)) {
                $this->ptr_next = $tmp;
            }            
        }
    }        
    
    
    protected function getLast()
    {
        $c = new Criteria();
        $c->setLimit(1);                                
        $c->addDescendingOrderByColumn(RubrykaPeer::RUBRYKA);
        if ($tmp = RubrykaPeer::doSelectOne($c)) {
            $this->ptr_last = $tmp;
            if ($this->ptr_current && ($this->ptr_last->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_last = false;
            }
        }    
    }    
    
    



}