<?php



class WskaznikArtykulu extends Pointer
{

    protected function getFirst()
    {
        $c = new Criteria();
        $c->setLimit(1);
        $c->addAscendingOrderByColumn(ArtykulPeer::TYTUL);
        if ($tmp = ArtykulPeer::doSelectOne($c)) {
            $this->ptr_first = $tmp;
            if ($this->ptr_current && ($this->ptr_first->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_first = false;
            }
        }    
    }
    
    
    protected function getPrevious()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->add(ArtykulPeer::TYTUL, $this->ptr_current->getTytul(), Criteria::LESS_THAN);
            $c->setLimit(1);
            $c->addDescendingOrderByColumn(ArtykulPeer::TYTUL);
            if ($tmp = ArtykulPeer::doSelectOne($c)) {
                $this->ptr_previous = $tmp;
            }            
        };    
    }    
    
    protected function getNext()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->add(ArtykulPeer::TYTUL, $this->ptr_current->getTytul(), Criteria::GREATER_THAN);
            $c->setLimit(1);          
            $c->addAscendingOrderByColumn(ArtykulPeer::TYTUL);
            if ($tmp = ArtykulPeer::doSelectOne($c)) {
                $this->ptr_next = $tmp;
            }            
        }
    }        
    
    
    protected function getLast()
    {
        $c = new Criteria();
        $c->setLimit(1);                                
        $c->addDescendingOrderByColumn(ArtykulPeer::TYTUL);
        if ($tmp = ArtykulPeer::doSelectOne($c)) {
            $this->ptr_last = $tmp;
            if ($this->ptr_current && ($this->ptr_last->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_last = false;
            }
        }    
    }    
    
    



}