<?php

require_once 'XML/Serializer.php';
require_once 'XML/Unserializer.php';


/*

   Metody odczytujące pliki tekstowe:
       loadDate   
       loadListings
       loadFigures
       ...

   Metody ustalające wartości pól:
       setTitle
       setDate
       ...

   Metody zwracające wartości pól:
       getTitle
       getDate
       ...


   Metody zwracające kod HTML:
       getHTMLExamples
       getHTMLDownload       
       getHTMLFigure(nr)
       getHTMLTable(nr)
       ...

   Metody przetwarzajace surowy text w html
       processHTML
       processPages
       ....

*/


require_once 'vh-array.inc.php';

class TXTArticle
{

    private $directory = '';
    private $xml = '';


    public $title = '';
    public $title_short = '';
    public $date = '';
    public $introduction = '';
    public $article = '';
    

    /*
     * $figures[$i]['no']
     * $figures[$i]['ext']
     * $figures[$i]['filename']
     * $figures[$i]['caption']
     * $figures[$i]['image']
     */
    public $figures_count = 0;
    public $figures;



    /*
     * $listings[$i]['no']
     * $listings[$i]['caption']
     * $listings[$i]['code']
     * $listings[$i]['escaped_code']
     */
    public $listings_count = 0;
    public $listings;



    /*
     * $frames[$i]['no']
     * $frames[$i]['caption']
     * $frames[$i]['text']
     */
    public $frames_count = 0;
    public $frames;



    /*
     * $table[$i]['no']
     * $table[$i]['caption']
     * $table[$i]['numbering']
     * $table[$i]['rowscount']
     * $table[$i]['colscount']
     * $table[$i]['items']
     * $table[$i]['items'][0] - wiersz nagłówkowy
     * $table[$i]['items'][1] - pierwszy wiersz danych
     * $table[$i]['items'][2] - drugi wiersz danych
     * ...
     */
    public $tables_count = 0;
    public $tables;



    /*
     * $examples['items'][$i]['no']
     * $examples['items'][$i]['caption']
     * $examples['items'][$i]['filename']
     * $examples['items'][$i]['data']
     */
    public $examples_count = 0;
    public $examples;



    /*
     * $download['items'][$i]['no']
     * $download['items'][$i]['caption']
     * $download['items'][$i]['filename']
     * $download['items'][$i]['data']
     */
    public $download_count = 0;
    public $download;




    /*
     * $addresses['items'][$i]['no']
     * $addresses['items'][$i]['caption']
     * $addresses['items'][$i]['url']
     */
    public $addresses_count = 0;
    public $addresses;



    public function __construct($ADirectory)
    {
        $this->directory = $ADirectory;
        
        $this->loadArticle();
        $this->loadDate();
        $this->loadIntroduction();        
        $this->loadTitle();
        
        $this->loadFigures();
        $this->loadListings();
        $this->loadFrames();        
        $this->loadTables();                
        
        $this->loadExamples();                        
        $this->loadDownload();                                
        $this->loadAddresses();                                        
    }


    protected function loadDate()
    {
        $filename = $this->directory . '/date.txt';
        
        if (file_exists($filename)) {
            $this->date = trim(file_get_contents($filename));
        };
    }
    
    
    protected function loadArticle()
    {
        $filename = $this->directory . '/article.txt';
        
        if (file_exists($filename)) {
            $this->article = trim(file_get_contents($filename));
        }    
    }     


    protected function loadIntroduction()
    {
        $filename = $this->directory . '/introduction.txt';
        
        if (file_exists($filename)) {
            $this->introduction = trim(file_get_contents($filename));            
        }        
    }


    protected function loadTitle()
    {
        $this->title = '';
        
        $filename = $this->directory . '/title.txt';
        
        if (file_exists($filename)) {
            $this->title = trim(file_get_contents($filename));            
        }            
        
    }    
    
    
    protected function loadFigures()
    {
        $this->figures_count = 0;
        $this->figures = array();
	        
        $filename = $this->directory . '/figures.txt';
        
        if (file_exists($filename)) {
            $tmp = trim(file_get_contents($filename));
            $d = string2HArray($tmp);
            $this->figures_count = $d['rows'];
            for ($i = 0; $i < $this->figures_count; $i++) {
                $tmp_figure = array();
                $tmp_figure['no'] = $i + 1;
                $tmp_figure['ext'] = $d['items'][$i][1];
                $tmp_figure['filename'] = $tmp_figure['no'] . '.' . $tmp_figure['ext'];
                $tmp_figure['caption'] = $d['items'][$i][0];
                $tmp_figure['image'] = file_get_contents(
                    $this->directory . '/figures/' . $tmp_figure['filename']
                );
                $tmp_figure['image'] = base64_encode($tmp_figure['image']);
                
                $this->figures[$i + 1] = $tmp_figure;
            }            
        }            
    }    


    protected function loadListings()
    {
        $this->listings_count = 0;
        $this->listings = array();
	        
        $filename = $this->directory . '/listings.txt';
        
        if (file_exists($filename)) {
            $tmp = file($filename);
            $this->listings_count = count($tmp);
            $this->listings_count_p1 = $this->listings_count + 1;
            for ($i = 0; $i < $this->listings_count; $i++) {
                $tmp_listing = array();
                $tmp_listing['no'] = $i + 1;
                $tmp_listing['caption'] = trim($tmp[$i]);
                $tmp_listing['code'] = file_get_contents($this->directory . '/listings/' . ($i + 1) . '.txt');
                $tmp_listing['escaped_code'] = htmlspecialchars($tmp_listing['code']);
                $this->listings[$i + 1] = $tmp_listing;
            }        
        }            
    }    
    
    
    protected function loadFrames()
    {
        $this->frames_count = 0;
        $this->frames = array();
	        
        $filename = $this->directory . '/frames.txt';
        
        if (file_exists($filename)) {
            $tmp = file($filename);
            $this->frames_count = count($tmp);
            for ($i = 0; $i < $this->frames_count; $i++) {
                $tmp_frame = array();
                $tmp_frame['no'] = $i + 1;
                $tmp_frame['caption'] = trim($tmp[$i]);
                $tmp_frame['text'] = file_get_contents($this->directory . '/frames/' . ($i + 1) . '.txt');
                $this->frames[$i + 1] = $tmp_frame;
            }        
        }            
    }        
    
    
    protected function loadTables()
    {
        $this->tables_count = 0;    
        $this->tables = array();

        $filename = $this->directory . '/tables.txt';
        
        if (file_exists($filename)) {
            $tmp = file($filename);
            $this->tables_count = count($tmp);
            for ($i = 0; $i < $this->tables_count; $i++) {
                $d = string2HArray(trim($tmp[$i]));
                
                $tmp_table = array();
                $tmp_table['no'] = $i + 1;
                $tmp_table['caption'] = $d['items'][0][0];
                $tmp_table['numbering'] = ($d['items'][0][1] == '+');

                $tmptab = trim(file_get_contents($this->directory . '/tables/' . ($i + 1) . '.txt'));
                $d = string2HArray($tmptab, "\t");

                $tmp_table['rowscount'] = $d['rows'];
                $tmp_table['colscount'] = $d['cols'];
                $tmp_table['items'] = $d['items'];
                
                $this->tables[$i + 1] = $tmp_table;
            }        
        }            
    }        
    
    
    protected function loadExamples()
    {
        $this->examples_count = 0;
        $this->examples = array();

        $filename = $this->directory . '/examples.txt';
        
        if (file_exists($filename)) {
            $tmp = trim(file_get_contents($filename));
            $d = string2HArray($tmp);
            $this->examples_count = $d['rows'];
            $this->examples['items'] = array();
            for ($i = 0; $i < $this->examples_count; $i++) {
                $tmp_example = array();
                $tmp_example['no'] = $i + 1;
                $tmp_example['caption'] = $d['items'][$i][0];
                $tmp_example['filename'] = $d['items'][$i][1];
                $tmp_example['data'] = file_get_contents(
                    $this->directory . '/examples/' . $tmp_example['filename']
                );
                $tmp_example['data'] = base64_encode($tmp_example['data']);
                $this->examples['items'][$i] = $tmp_example;
            }
        }            
    }            

    
    protected function loadDownload()
    {
        $this->download_count = 0;
        $this->download = array();

        $filename = $this->directory . '/download.txt';
        
        if (file_exists($filename)) {
        
            $tmp = trim(file_get_contents($filename));
            $d = string2HArray($tmp);
            $this->download_count = $d['rows'];
            $this->download = array();
            $this->download['items'] = array();
            for ($i = 0; $i < $this->download_count; $i++) {
                $tmp_download = array();
                $tmp_download['no'] = $i + 1;
                $tmp_download['caption'] = $d['items'][$i][0];
                $tmp_download['filename'] = $d['items'][$i][1];
                $tmp_download['data'] = file_get_contents(
                    $this->directory . '/download/' . $tmp_download['filename']
                );
                $tmp_download['data'] = base64_encode($tmp_download['data']);
                $this->download['items'][$i] = $tmp_download;
            }            
        }            
    }            
    
    
    protected function loadAddresses()
    {
        $this->addresses_count = 0;
        $this->addresses = array();

        $filename = $this->directory . '/addresses.txt';
        
        if (file_exists($filename)) {
            $tmp = trim(file_get_contents($filename));
            $d = string2HArray($tmp);
            $this->addresses_count = $d['rows'];
            $this->addresses = array();
            $this->addresses['items'] = array();
            for ($i = 0; $i < $this->addresses_count; $i++) {
                $tmp_address = array();
                $tmp_address['no'] = $i + 1;
                $tmp_address['caption'] = $d['items'][$i][0];
                $tmp_address['url'] = $d['items'][$i][1];
                $this->addresses['items'][$i] = $tmp_address;
            }        
        }            
    }            
    
    public function getXml()
    {
        $serializer = new XML_Serializer();

        $options = array(
            'addDecl'  => true,
            'indent'   => '    ',
            'rootName' => 'artykul',
            'encoding' => 'utf-8',
            'defaultTagName' => 'item',
        );

        $serializer->setOptions($options);
        $serializer->serialize($this);
        $this->xml = $serializer->getSerializedData();
        return $this->xml;
    }
    
    public function saveXml($filename, $compress = true)
    {
        if ($compress) {
            if (substr($filename, -3) != '.gz') {
                $filename .= '.gz';
            }
            $gzfile = gzopen($filename, 'w9');
            if ($gzfile === false) {
                throw new Exception('TxtArticle::saveXML() exception');
            }
            if ($this->xml == '') {
                $this->getXml();
            }
            gzwrite($gzfile, $this->xml);
            gzclose($gzfile);
        } else {
            if ($this->xml == '') {
                $this->getXml();
            }
            file_put_contents($filename, $this->xml);
        }
    }


}