<?php

class Actions extends ActionsBase
{
    private $kolumna = 5;

    private $kolumny = array(
        1 => array(
            'nazwa' => 'Klub',
            'order' => 'asc',
        ),
        array(
            'nazwa' => 'Mecze',
            'order' => 'desc',
        ),
        array(
            'nazwa' => 'Bramki strzelone',
            'order' => 'desc',
        ),
        array(
            'nazwa' => 'Bramki stracone',
            'order' => 'desc',
        ),
        array(
            'nazwa' => 'Punkty',
            'order' => 'desc',
        )
    );

    public function strInvertSort($s)
    {
        if ($s == 'asc') {
            return 'desc';
        } else {
            return 'asc';
        }
    }
    
    public function strGetSort($s)
    {
        if ($s == 'asc') {
            return SORT_ASC;
        } else {
            return SORT_DESC;
        }
    }
    
    public function getCurrentSort()
    {
        $tmp = $this->kolumny[$this->kolumna]['order'];
        return $this->strGetSort($tmp);
    }
    
    public function invertCurrentSort()
    {
        $tmp = $this->kolumny[$this->kolumna]['order'];
        $this->kolumny[$this->kolumna]['order'] = $this->strInvertSort($tmp);
    }
    
    public function sort()
    {
        switch ($this->kolumna) {
        case 1:
            array_multisort(
                $this->tabela['items'][0], $this->getCurrentSort(),
                $this->tabela['items'][1],
                $this->tabela['items'][2],
                $this->tabela['items'][3],
                $this->tabela['items'][4]
            );
            break;

        case 2:
            array_multisort(
                $this->tabela['items'][1], $this->getCurrentSort(),
                $this->tabela['items'][0],
                $this->tabela['items'][2],
                $this->tabela['items'][3],
                $this->tabela['items'][4]
            );
            break;

        case 3:
            array_multisort(
                $this->tabela['items'][2], $this->getCurrentSort(),
                $this->tabela['items'][0],
                $this->tabela['items'][1],
                $this->tabela['items'][3],
                $this->tabela['items'][4]
            );
            break;

        case 4:
            array_multisort(
                $this->tabela['items'][3], $this->getCurrentSort(),
                $this->tabela['items'][0],
                $this->tabela['items'][1],
                $this->tabela['items'][2],
                $this->tabela['items'][4]
            );
            break;

        case 5:
            array_multisort(
                $this->tabela['items'][4], $this->getCurrentSort(),
                $this->tabela['items'][0],
                $this->tabela['items'][1],
                $this->tabela['items'][2],
                $this->tabela['items'][3]
            );
            break;
        }
    }

    public function execute_show()
    {
        if (
            isset($_GET['liga']) &&
            str_ivslug($_GET['liga']) &&
            in_array($_GET['liga'], $this->controller->slugi)
        ) {
            $liga = $_GET['liga'];
        } else {
            $liga = $this->controller->dane[0][0];
        }

        if (
            isset($_GET['kolumna']) &&
            str_ievpifr($_GET['kolumna'], 1, 5)
        ) {
            $this->kolumna = $_GET['kolumna'];
        }

        if (
            isset($_GET['order']) &&
            in_array($_GET['order'], array('asc', 'desc'))
        ) {
            $this->kolumny[$this->kolumna]['order'] = $_GET['order'];
        }
    
        $indeks = array_search($liga, $this->controller->slugi);
        $tmp = $this->controller->dane[$indeks][1];
        $this->tabela = string2VArray(file_get_contents('../scripts/dane/' . $tmp . '.txt'));
        
        $this->sort();
        
        $this->invertCurrentSort();
        
        $this->set('kolumny', $this->kolumny);
        $this->set('liga', $liga);
        $this->set('tabela', $this->tabela);
    }
    
}