<?php


/**
 * This class adds structure of 'rodzina' table to 'zengardencss' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    zengardencss.map
 */
class RodzinaMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'zengardencss.map.RodzinaMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(RodzinaPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(RodzinaPeer::TABLE_NAME);
		$tMap->setPhpName('Rodzina');
		$tMap->setClassname('Rodzina');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('RODZINA_ID', 'RodzinaId', 'INTEGER', true, null);

		$tMap->addColumn('NAZWA', 'Nazwa', 'VARCHAR', false, 128);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 128);

		$tMap->addColumn('LICZBACZCIONEK', 'Liczbaczcionek', 'INTEGER', false, null);

		$tMap->addColumn('LICZBAPROJEKTOW', 'Liczbaprojektow', 'INTEGER', false, null);

	} // doBuild()

} // RodzinaMapBuilder
