<?php

require 'angaze/om/BaseKierunek.php';


/**
 * Skeleton subclass for representing a row from the 'kierunek' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    angaze
 */
class Kierunek extends BaseKierunek {

    /**
     * Initializes internal state of Kierunek object.
     * @see        parent::__construct()
     */
    public function __construct()
    {
        // Make sure that parent constructor is always invoked, since that
        // is where any default values for this object are set.
        parent::__construct();
    }

    public function __toString()
    {
        return $this->getNazwa();
    }

    function przedmiotySemestru($semestr)
    {
        $c = new Criteria();
        $c->add(PrzedmiotPeer::SEMESTR, $semestr);
        return self::getPrzedmiots($c);
    }

    function obsadaKierunku()
    {
        $obsadaKierunku = array();
        for ($i = 1; $i <= $this->getRodzajstudiow()->getLata(); $i++) {
            $rok = $i;
            $semestrZima = round($rok * 2 - 1);
            $semestrLato = round($rok * 2);

            $przedmiotySemestruZima = $this->przedmiotySemestru($semestrZima);
            $przedmiotySemestruLato = $this->przedmiotySemestru($semestrLato);

            $obsadaKierunku[] = array(
                'rok' => $rok,
                'semestrZima' => $semestrZima,
                'semestrLato' => $semestrLato,
                'przedmiotySemestruZima' => $przedmiotySemestruZima,
                'przedmiotySemestruLato' =>$przedmiotySemestruLato,
            );
        }
        return $obsadaKierunku;
    }

    public function isValid_semestr($semestr)
    {
        return str_ievpifr($semestr, 1, $this->getRodzajstudiow()->getSemestry());
    }
    
    public function isValid_rok($rok)
    {
        return str_ievpifr($rok, 1, $this->getRodzajstudiow()->getLata());
    }


} // Kierunek
