set names utf8;
drop database if exists angaze;
create database angaze default character set utf8 collate utf8_polish_ci;
grant all on angaze.* to admin@localhost identified by 'password';
flush privileges;
use angaze;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- wydzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `wydzial`;


CREATE TABLE `wydzial`
(
	`wydzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`wydzial_id`),
	UNIQUE KEY `wydzial_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- pokoj
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `pokoj`;


CREATE TABLE `pokoj`
(
	`pokoj_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numer` VARCHAR(20),
	`telefon` VARCHAR(20),
	`slug` VARCHAR(128)  NOT NULL,
	`sortowanie` INTEGER default 999999999,
	PRIMARY KEY (`pokoj_id`),
	UNIQUE KEY `pokoj_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- stanowisko
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `stanowisko`;


CREATE TABLE `stanowisko`
(
	`stanowisko_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`pensum` INTEGER,
	`sortowanie` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`stanowisko_id`),
	UNIQUE KEY `stanowisko_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzajstudiow
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzajstudiow`;


CREATE TABLE `rodzajstudiow`
(
	`rodzajstudiow_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`semestry` INTEGER,
	`lata` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rodzajstudiow_id`),
	UNIQUE KEY `rodzajstudiow_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzajzajec
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzajzajec`;


CREATE TABLE `rodzajzajec`
(
	`rodzajzajec_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`grupy` INTEGER,
	`sortowanie` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rodzajzajec_id`),
	UNIQUE KEY `rodzajzajec_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- katedra
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `katedra`;


CREATE TABLE `katedra`
(
	`katedra_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`wydzial_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`katedra_id`),
	UNIQUE KEY `katedra_U_1` (`slug`(128)),
	INDEX `FI_katedra_wydzial1` (`wydzial_id`),
	CONSTRAINT `fk_katedra_wydzial1`
		FOREIGN KEY (`wydzial_id`)
		REFERENCES `wydzial` (`wydzial_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- kierunek
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kierunek`;


CREATE TABLE `kierunek`
(
	`kierunek_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`skrot` VARCHAR(20),
	`sortowanie` INTEGER,
	`wydzial_id` INTEGER,
	`rodzajstudiow_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`kierunek_id`),
	UNIQUE KEY `kierunek_U_1` (`slug`(128)),
	UNIQUE KEY `kierunek_U_2` (`skrot`(20)),
	INDEX `FI_tkierunek_wydzial1` (`wydzial_id`),
	CONSTRAINT `fk_tkierunek_wydzial1`
		FOREIGN KEY (`wydzial_id`)
		REFERENCES `wydzial` (`wydzial_id`),
	INDEX `FI_tkierunek_rodzajstudiow1` (`rodzajstudiow_id`),
	CONSTRAINT `fk_tkierunek_rodzajstudiow1`
		FOREIGN KEY (`rodzajstudiow_id`)
		REFERENCES `rodzajstudiow` (`rodzajstudiow_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- pracownik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `pracownik`;


CREATE TABLE `pracownik`
(
	`pracownik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(20),
	`nazwisko` VARCHAR(45),
	`skrot` VARCHAR(20),
	`tytul` VARCHAR(20),
	`pokoj_id` INTEGER,
	`stanowisko_id` INTEGER,
	`katedra_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`pracownik_id`),
	UNIQUE KEY `pracownik_U_1` (`slug`(128)),
	INDEX `FI_tpracownik_pokoj1` (`pokoj_id`),
	CONSTRAINT `fk_tpracownik_pokoj1`
		FOREIGN KEY (`pokoj_id`)
		REFERENCES `pokoj` (`pokoj_id`),
	INDEX `FI_tpracownik_stanowisko1` (`stanowisko_id`),
	CONSTRAINT `fk_tpracownik_stanowisko1`
		FOREIGN KEY (`stanowisko_id`)
		REFERENCES `stanowisko` (`stanowisko_id`),
	INDEX `FI_pracownik_katedra1` (`katedra_id`),
	CONSTRAINT `fk_pracownik_katedra1`
		FOREIGN KEY (`katedra_id`)
		REFERENCES `katedra` (`katedra_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- przedmiot
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `przedmiot`;


CREATE TABLE `przedmiot`
(
	`przedmiot_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(255),
	`skrot` VARCHAR(128),
	`godz` INTEGER,
	`zal` VARCHAR(20),
	`liczbagrup` INTEGER,
	`semestr` INTEGER,
	`rok` INTEGER,
	`odbywa_sie` INTEGER,
	`nazwa_alternatywna` VARCHAR(45),
	`zimalato` INTEGER,
	`rodzajzajec_id` INTEGER,
	`kierunek_id` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`przedmiot_id`),
	UNIQUE KEY `przedmiot_U_1` (`slug`(128)),
	INDEX `FI_tprzedmiot_rodzajzajec1` (`rodzajzajec_id`),
	CONSTRAINT `fk_tprzedmiot_rodzajzajec1`
		FOREIGN KEY (`rodzajzajec_id`)
		REFERENCES `rodzajzajec` (`rodzajzajec_id`),
	INDEX `FI_przedmiot_kierunek1` (`kierunek_id`),
	CONSTRAINT `fk_przedmiot_kierunek1`
		FOREIGN KEY (`kierunek_id`)
		REFERENCES `kierunek` (`kierunek_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- przydzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `przydzial`;


CREATE TABLE `przydzial`
(
	`przydzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numergrupy` INTEGER,
	`nazwa_alternatywna` INTEGER,
	`pracownik_id` INTEGER,
	`przedmiot_id` INTEGER,
	PRIMARY KEY (`przydzial_id`),
	INDEX `FI_tprzydzial_pracownik1` (`pracownik_id`),
	CONSTRAINT `fk_tprzydzial_pracownik1`
		FOREIGN KEY (`pracownik_id`)
		REFERENCES `pracownik` (`pracownik_id`),
	INDEX `FI_tprzydzial_przedmiot1` (`przedmiot_id`),
	CONSTRAINT `fk_tprzydzial_przedmiot1`
		FOREIGN KEY (`przedmiot_id`)
		REFERENCES `przedmiot` (`przedmiot_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 09:57
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `angaze`
--

--
-- Zrzut danych tabeli `katedra`
--

INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(1, 'Katedra Historii Szydełkowania', 'KHS', 3, 'katedra_historii_szydelkowania');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(2, 'Katedra Teorii Prac Ręcznych', 'KTPR', 2, 'katedra_teorii_prac_recznych');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(3, 'Katedra Teorii Dowcipkowania', 'KTD', 1, 'katedra_teorii_dowcipkowania');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(4, 'Katedra Historii Dowcipkowania', 'KHD', 1, 'katedra_historii_dowcipkowania');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(5, 'Katedra Teorii Szydełkowania', 'KTS', 3, 'katedra_teorii_szydelkowania');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(6, 'Katedra Zastosowań Dowcipkowania', 'KZD', 1, 'katedra_zastosowan_dowcipkowania');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(7, 'Katedra Zastosowań Szydełkowania', 'KZS', 3, 'katedra_zastosowan_szydelkowania');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(8, 'Ketedra Zastosowań Prac Ręcznych', 'KZPR', 2, 'ketedra_zastosowan_prac_recznych');
INSERT INTO `katedra` (`katedra_id`, `nazwa`, `skrot`, `wydzial_id`, `slug`) VALUES(9, 'Katedra Historii Prac Ręcznych', 'KHPR', 2, 'katedra_historii_prac_recznych');

--
-- Zrzut danych tabeli `kierunek`
--

INSERT INTO `kierunek` (`kierunek_id`, `nazwa`, `skrot`, `sortowanie`, `wydzial_id`, `rodzajstudiow_id`, `slug`) VALUES(1, 'Szydełkowanie i robienie na drutach', 'Szydełkowanie dm', 10, 3, 5, 'szydelkowanie_dm');
INSERT INTO `kierunek` (`kierunek_id`, `nazwa`, `skrot`, `sortowanie`, `wydzial_id`, `rodzajstudiow_id`, `slug`) VALUES(2, 'Robótki ręczne', 'Robótki dz', 50, 2, 2, 'robotki_dz');
INSERT INTO `kierunek` (`kierunek_id`, `nazwa`, `skrot`, `sortowanie`, `wydzial_id`, `rodzajstudiow_id`, `slug`) VALUES(3, 'Robótki ręczne', 'Robótki dm', 40, 2, 5, 'robotki_dm');
INSERT INTO `kierunek` (`kierunek_id`, `nazwa`, `skrot`, `sortowanie`, `wydzial_id`, `rodzajstudiow_id`, `slug`) VALUES(4, 'Szydełkowanie i robienie na drutach', 'Szydełkowanie dz', 20, 3, 2, 'szydelkowanie_dz');

--
-- Zrzut danych tabeli `pokoj`
--

INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(1, '22', '1222', '22', 22);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(2, '117', '1417', '117', 117);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(3, '455', '1707', '455', 455);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(4, '118', '1418', '118', 118);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(5, '23', '1223', '23', 23);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(6, '21', '1221', '21', 21);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(7, '452', '1704', '452', 452);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(8, '115', '1415', '115', 115);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(9, '454', '1706', '454', 454);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(10, '119', '1419', '119', 119);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(11, '453', '1705', '453', 453);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(12, '116', '1416', '116', 116);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(13, '20', '1220', '20', 20);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(14, '456', '1708', '456', 456);
INSERT INTO `pokoj` (`pokoj_id`, `numer`, `telefon`, `slug`, `sortowanie`) VALUES(15, '451', '1703', '451', 451);

--
-- Zrzut danych tabeli `pracownik`
--

INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(1, 'C.', 'Brzoza', 'CB', 'dr', 7, 4, 4, 'brzoza_c');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(2, 'K.', 'Kartofel', 'KK', 'mgr', 6, 5, 7, 'kartofel_k');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(3, 'P.', 'Winogron', 'PW', 'mgr.', 14, 5, 3, 'winogron_p');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(4, 'U.', 'Porzeczka', 'UP', 'mgr.', 14, 5, 3, 'porzeczka_u');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(5, 'H.', 'Wiśnia', 'HW', 'mgr', 5, 5, 5, 'wisnia_h');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(6, 'Z.', 'Jarzębina', 'ZJ', 'mgr.', 9, 5, 4, 'jarzebina_z');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(7, 'P.', 'Gruszka', 'PG', 'mgr', 13, 5, 1, 'gruszka_p');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(8, 'W.', 'Sałata', 'WS', 'mgr', 1, 5, 1, 'salata_w');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(9, 'A.', 'Morela', 'AM', 'prof.', 8, 3, 5, 'morela_a');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(10, 'I.', 'Wiąz', 'IW', 'mgr.', 9, 5, 2, 'wiaz_i');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(11, 'Z.', 'Olcha', 'ZO', 'prof.', 11, 3, 4, 'olcha_z');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(12, 'T.', 'Kokos', 'TK', 'mgr.', 14, 5, 3, 'kokos_t');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(13, 'B.', 'Banan', 'BB', 'prof.', 2, 3, 9, 'banan_b');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(14, 'I.', 'Rzodkiew', 'IR', 'mgr', 12, 5, 1, 'rzodkiew_i');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(15, 'P.', 'Seler', 'PS', 'mgr', 12, 2, 9, 'seler_p');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(16, 'A.', 'Dąb', 'AD', 'mgr.', 10, 5, 8, 'dab_a');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(17, 'E.', 'Kiwi', 'EK', 'dr', 4, 4, 1, 'kiwi_e');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(18, 'U.', 'Brukiew', 'UB', 'mgr', 12, 5, 9, 'brukiew_u');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(19, 'W.', 'Ananas', 'WA', 'mgr.', 4, 5, 1, 'ananas_w');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(20, 'O.', 'Oset', 'OO', 'prof.', 3, 3, 6, 'oset_o');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(21, 'A.', 'Truskawka', 'AT', 'dr', 14, 4, 3, 'truskawka_a');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(22, 'T.', 'Szczypior', 'TS', 'mgr', 5, 5, 5, 'szczypior_t');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(23, 'C.', 'Pietruszka', 'CP', 'dr', 6, 4, 7, 'pietruszka_c');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(24, 'J.', 'Marchewka', 'JM', 'mgr', 13, 5, 7, 'marchewka_j');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(25, 'K.', 'Jodła', 'KJ', 'mgr.', 9, 2, 6, 'jodla_k');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(26, 'C.', 'Klon', 'CK', 'prof.', 15, 3, 2, 'klon_c');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(27, 'K.', 'Lipa', 'KL', 'dr', 7, 4, 2, 'lipa_k');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(28, 'R.', 'Kapusta', 'RK', 'mgr', 1, 2, 5, 'kapusta_r');
INSERT INTO `pracownik` (`pracownik_id`, `imie`, `nazwisko`, `skrot`, `tytul`, `pokoj_id`, `stanowisko_id`, `katedra_id`, `slug`) VALUES(29, 'B.', 'Buk', 'BB', 'mgr.', 10, 5, 8, 'buk_b');

--
-- Zrzut danych tabeli `przedmiot`
--

INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(1, 'Historia szydełkowania', 'Hist. Sz.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 1, 'historia_szydelkowania_szydelkowanie_dm_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(2, 'Historia szydełkowania', 'Hist. Sz.', 30, 'Z', 4, 1, 1, 1, NULL, 1, 6, 1, 'historia_szydelkowania_szydelkowanie_dm_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(3, 'Szydełkowanie wczoraj i dziś', 'Sz. wcz. i dz.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 1, 'szydelkowanie_wczoraj_i_dzis_szydelkowanie_dm_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(4, 'Szydełkowanie wczoraj i dziś', 'Sz. wcz. i dz.', 30, 'Z', 4, 1, 1, 1, NULL, 1, 6, 1, 'szydelkowanie_wczoraj_i_dzis_szydelkowanie_dm_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(5, 'Podstawy szydełkowania', 'Podst. SZ.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 1, 'podstawy_szydelkowania_szydelkowanie_dm_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(6, 'Podstawy szydełkowania', 'Podst. SZ.', 30, 'Z', 4, 1, 1, 1, NULL, 1, 6, 1, 'podstawy_szydelkowania_szydelkowanie_dm_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(7, 'Historia szydełkowania', 'Hist. Sz.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 1, 'historia_szydelkowania_szydelkowanie_dm_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(8, 'Historia szydełkowania', 'Hist. Sz.', 30, 'Z', 4, 2, 1, 1, NULL, 0, 6, 1, 'historia_szydelkowania_szydelkowanie_dm_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(9, 'Szydełkowanie w praktyce', 'Szyd. Prakt.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 1, 'szydelkowanie_w_praktyce_szydelkowanie_dm_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(10, 'Szydełkowanie w praktyce', 'Szyd. Prakt.', 30, 'Z', 4, 2, 1, 1, NULL, 0, 6, 1, 'szydelkowanie_w_praktyce_szydelkowanie_dm_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(11, 'Materiałoznastwo szydełkowe', 'Materiał.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 1, 'materialoznastwo_szydelkowe_szydelkowanie_dm_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(12, 'Materiałoznastwo szydełkowe', 'Materiał.', 30, 'Z', 3, 3, 2, 1, NULL, 1, 6, 1, 'materialoznastwo_szydelkowe_szydelkowanie_dm_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(13, 'Szydełkologia stosowana', 'Szydeł. stos.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 1, 'szydelkologia_stosowana_szydelkowanie_dm_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(14, 'Szydełkologia stosowana', 'Szydeł. stos.', 30, 'Z', 3, 3, 2, 1, NULL, 1, 6, 1, 'szydelkologia_stosowana_szydelkowanie_dm_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(15, 'Rola szydełkowania we współczesnym społeczeństwie', 'Rola. Sz.', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 1, 'rola_szydelkowania_we_wspolczesnym_spoleczenstwie_szydelkowanie_dm_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(16, 'Rola szydełkowania we współczesnym społeczeństwie', 'Rola. Sz.', 30, 'Z', 3, 4, 2, 1, NULL, 0, 6, 1, 'rola_szydelkowania_we_wspolczesnym_spoleczenstwie_szydelkowanie_dm_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(17, 'Szydełka i szydełkownice', 'Sz. i sz.', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 1, 'szydelka_i_szydelkownice_szydelkowanie_dm_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(18, 'Szydełka i szydełkownice', 'Sz. i sz.', 30, 'Z', 4, 4, 2, 1, NULL, 0, 6, 1, 'szydelka_i_szydelkownice_szydelkowanie_dm_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(19, 'Szydełkownictwo medialne', 'Sz. Med.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 1, 'szydelkownictwo_medialne_szydelkowanie_dm_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(20, 'Szydełkownictwo medialne', 'Sz. Med.', 30, 'Z', 3, 5, 3, 1, NULL, 1, 6, 1, 'szydelkownictwo_medialne_szydelkowanie_dm_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(21, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 1, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dm_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(22, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'Z', 3, 5, 3, 1, NULL, 1, 6, 1, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dm_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(23, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 1, 'teoria_szydelkownictwa_szydelkowanie_dm_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(24, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'Z', 2, 5, 3, 1, NULL, 1, 6, 1, 'teoria_szydelkownictwa_szydelkowanie_dm_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(25, 'Szydzydełka nowoczesne', 'Sz. now.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 1, 'szydzydelka_nowoczesne_szydelkowanie_dm_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(26, 'Szydzydełka nowoczesne', 'Sz. now.', 30, 'Z', 2, 6, 3, 1, NULL, 0, 6, 1, 'szydzydelka_nowoczesne_szydelkowanie_dm_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(27, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 1, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dm_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(28, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'Z', 3, 6, 3, 1, NULL, 0, 6, 1, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dm_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(29, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 1, 'teoria_szydelkownictwa_szydelkowanie_dm_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(30, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'Z', 2, 6, 3, 1, NULL, 0, 6, 1, 'teoria_szydelkownictwa_szydelkowanie_dm_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(31, 'Szydlarstwo', 'Szydlarstwo', 30, 'Z', 2, 7, 4, 1, NULL, 1, 1, 1, 'szydlarstwo_szydelkowanie_dm_seminarium_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(32, 'Dziergownictwo', 'Dziergownictwo', 30, 'Z', 2, 7, 4, 1, NULL, 1, 1, 1, 'dziergownictwo_szydelkowanie_dm_seminarium_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(33, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'E', 1, 7, 4, 1, NULL, 1, 5, 1, 'szydla_szydelka_szydelkowanie_dm_wyklady_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(34, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'Z', 3, 7, 4, 1, NULL, 1, 6, 1, 'szydla_szydelka_szydelkowanie_dm_cwiczenia_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(35, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'E', 1, 7, 4, 1, NULL, 1, 5, 1, 'prawo_szydelkowania_szydelkowanie_dm_wyklady_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(36, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'Z', 2, 7, 4, 1, NULL, 1, 6, 1, 'prawo_szydelkowania_szydelkowanie_dm_cwiczenia_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(37, 'Szydlarstwo', 'Szydlarstwo', 30, 'Z', 2, 8, 4, 1, NULL, 0, 1, 1, 'szydlarstwo_szydelkowanie_dm_seminarium_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(38, 'Dziergownictwo', 'Dziergownictwo', 30, 'Z', 2, 8, 4, 1, NULL, 0, 1, 1, 'dziergownictwo_szydelkowanie_dm_seminarium_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(39, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'E', 1, 8, 4, 1, NULL, 0, 5, 1, 'szydla_szydelka_szydelkowanie_dm_wyklady_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(40, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'Z', 3, 8, 4, 1, NULL, 0, 6, 1, 'szydla_szydelka_szydelkowanie_dm_cwiczenia_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(41, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'E', 1, 8, 4, 1, NULL, 0, 5, 1, 'prawo_szydelkowania_szydelkowanie_dm_wyklady_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(42, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'Z', 2, 8, 4, 1, NULL, 0, 6, 1, 'prawo_szydelkowania_szydelkowanie_dm_cwiczenia_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(43, 'Szydlarstwo', 'Szydlarstwo', 30, 'Z', 2, 9, 5, 1, NULL, 1, 1, 1, 'szydlarstwo_szydelkowanie_dm_seminarium_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(44, 'Dziergownictwo', 'Dziergownictwo', 30, 'Z', 2, 9, 5, 1, NULL, 1, 1, 1, 'dziergownictwo_szydelkowanie_dm_seminarium_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(45, 'Kto wymyślił szydło?', 'Kto', 30, 'E', 1, 9, 5, 1, NULL, 1, 5, 1, 'kto_wymyslil_szydlo_szydelkowanie_dm_wyklady_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(46, 'Kto wymyślił szydło?', 'Kto', 30, 'Z', 3, 9, 5, 1, NULL, 1, 6, 1, 'kto_wymyslil_szydlo_szydelkowanie_dm_cwiczenia_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(47, 'Wyszło szydło z worka', 'Worek', 45, 'E', 1, 9, 5, 1, NULL, 1, 5, 1, 'wyszlo_szydlo_z_worka_szydelkowanie_dm_wyklady_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(48, 'Prawo szydełkowania', 'Worek', 45, 'Z', 2, 9, 5, 1, NULL, 1, 6, 1, 'prawo_szydelkowania_szydelkowanie_dm_cwiczenia_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(49, 'Szydlarstwo', 'Szydlarstwo', 30, 'Z', 2, 10, 5, 1, NULL, 0, 1, 1, 'szydlarstwo_szydelkowanie_dm_seminarium_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(50, 'Dziergownictwo', 'Dziergownictwo', 30, 'Z', 2, 10, 5, 1, NULL, 0, 1, 1, 'dziergownictwo_szydelkowanie_dm_seminarium_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(51, 'Kto wymyślił szydło?', 'Kto', 30, 'E', 1, 10, 5, 1, NULL, 0, 5, 1, 'kto_wymyslil_szydlo_szydelkowanie_dm_wyklady_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(52, 'Kto wymyślił szydło?', 'Kto', 30, 'Z', 3, 10, 5, 1, NULL, 0, 6, 1, 'kto_wymyslil_szydlo_szydelkowanie_dm_cwiczenia_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(53, 'Wyszło szydło z worka', 'Worek', 45, 'E', 1, 10, 5, 1, NULL, 0, 5, 1, 'wyszlo_szydlo_z_worka_szydelkowanie_dm_wyklady_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(54, 'Prawo szydełkowania', 'Worek', 45, 'Z', 2, 10, 5, 1, NULL, 0, 6, 1, 'prawo_szydelkowania_szydelkowanie_dm_cwiczenia_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(55, 'Historia szydełkowania', 'Hist. Sz.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 4, 'historia_szydelkowania_szydelkowanie_dz_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(56, 'Historia szydełkowania', 'Hist. Sz.', 30, 'Z', 4, 1, 1, 1, NULL, 1, 6, 4, 'historia_szydelkowania_szydelkowanie_dz_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(57, 'Szydełkowanie wczoraj i dziś', 'Sz. wcz. i dz.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 4, 'szydelkowanie_wczoraj_i_dzis_szydelkowanie_dz_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(58, 'Szydełkowanie wczoraj i dziś', 'Sz. wcz. i dz.', 30, 'Z', 4, 1, 1, 1, NULL, 1, 6, 4, 'szydelkowanie_wczoraj_i_dzis_szydelkowanie_dz_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(59, 'Podstawy szydełkowania', 'Podst. SZ.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 4, 'podstawy_szydelkowania_szydelkowanie_dz_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(60, 'Podstawy szydełkowania', 'Podst. SZ.', 30, 'Z', 4, 1, 1, 1, NULL, 1, 6, 4, 'podstawy_szydelkowania_szydelkowanie_dz_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(61, 'Historia szydełkowania', 'Hist. Sz.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 4, 'historia_szydelkowania_szydelkowanie_dz_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(62, 'Historia szydełkowania', 'Hist. Sz.', 30, 'Z', 4, 2, 1, 1, NULL, 0, 6, 4, 'historia_szydelkowania_szydelkowanie_dz_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(63, 'Szydełkowanie w praktyce', 'Szyd. Prakt.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 4, 'szydelkowanie_w_praktyce_szydelkowanie_dz_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(64, 'Szydełkowanie w praktyce', 'Szyd. Prakt.', 30, 'Z', 4, 2, 1, 1, NULL, 0, 6, 4, 'szydelkowanie_w_praktyce_szydelkowanie_dz_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(65, 'Materiałoznastwo szydełkowe', 'Materiał.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 4, 'materialoznastwo_szydelkowe_szydelkowanie_dz_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(66, 'Materiałoznastwo szydełkowe', 'Materiał.', 30, 'Z', 3, 3, 2, 1, NULL, 1, 6, 4, 'materialoznastwo_szydelkowe_szydelkowanie_dz_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(67, 'Szydełkologia stosowana', 'Szydeł. stos.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 4, 'szydelkologia_stosowana_szydelkowanie_dz_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(68, 'Szydełkologia stosowana', 'Szydeł. stos.', 30, 'Z', 3, 3, 2, 1, NULL, 1, 6, 4, 'szydelkologia_stosowana_szydelkowanie_dz_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(69, 'Rola szydełkowania we współczesnym społeczeństwie', 'Rola. Sz.', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 4, 'rola_szydelkowania_we_wspolczesnym_spoleczenstwie_szydelkowanie_dz_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(70, 'Rola szydełkowania we współczesnym społeczeństwie', 'Rola. Sz.', 30, 'Z', 3, 4, 2, 1, NULL, 0, 6, 4, 'rola_szydelkowania_we_wspolczesnym_spoleczenstwie_szydelkowanie_dz_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(71, 'Szydełka i szydełkownice', 'Sz. i sz.', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 4, 'szydelka_i_szydelkownice_szydelkowanie_dz_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(72, 'Szydełka i szydełkownice', 'Sz. i sz.', 30, 'Z', 4, 4, 2, 1, NULL, 0, 6, 4, 'szydelka_i_szydelkownice_szydelkowanie_dz_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(73, 'Szydełkownictwo medialne', 'Sz. Med.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 4, 'szydelkownictwo_medialne_szydelkowanie_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(74, 'Szydełkownictwo medialne', 'Sz. Med.', 30, 'Z', 3, 5, 3, 1, NULL, 1, 6, 4, 'szydelkownictwo_medialne_szydelkowanie_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(75, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 4, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(76, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'Z', 3, 5, 3, 1, NULL, 1, 6, 4, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(77, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 4, 'teoria_szydelkownictwa_szydelkowanie_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(78, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'Z', 2, 5, 3, 1, NULL, 1, 6, 4, 'teoria_szydelkownictwa_szydelkowanie_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(79, 'Szydlarstwo', 'Szydlarstwo', 30, 'Z', 2, 5, 3, 1, NULL, 1, 1, 4, 'szydlarstwo_szydelkowanie_dz_seminarium_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(80, 'Dziergownictwo', 'Dziergownictwo', 30, 'Z', 2, 5, 3, 1, NULL, 1, 1, 4, 'dziergownictwo_szydelkowanie_dz_seminarium_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(81, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 4, 'szydla_szydelka_szydelkowanie_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(82, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'Z', 3, 5, 3, 1, NULL, 1, 6, 4, 'szydla_szydelka_szydelkowanie_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(83, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'E', 1, 5, 3, 1, NULL, 1, 5, 4, 'prawo_szydelkowania_szydelkowanie_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(84, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'Z', 2, 5, 3, 1, NULL, 1, 6, 4, 'prawo_szydelkowania_szydelkowanie_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(85, 'Szydzydełka nowoczesne', 'Sz. now.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 4, 'szydzydelka_nowoczesne_szydelkowanie_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(86, 'Szydzydełka nowoczesne', 'Sz. now.', 30, 'Z', 2, 6, 3, 1, NULL, 0, 6, 4, 'szydzydelka_nowoczesne_szydelkowanie_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(87, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 4, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(88, 'Informatyka dla szydełkomistrzów', 'Inform. dla Sz.', 30, 'Z', 3, 6, 3, 1, NULL, 0, 6, 4, 'informatyka_dla_szydelkomistrzow_szydelkowanie_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(89, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 4, 'teoria_szydelkownictwa_szydelkowanie_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(90, 'Teoria szydełkownictwa', 'Teoria Sz.', 30, 'Z', 2, 6, 3, 1, NULL, 0, 6, 4, 'teoria_szydelkownictwa_szydelkowanie_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(91, 'Szydlarstwo', 'Szydlarstwo', 30, 'Z', 2, 6, 3, 1, NULL, 0, 1, 4, 'szydlarstwo_szydelkowanie_dz_seminarium_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(92, 'Dziergownictwo', 'Dziergownictwo', 30, 'Z', 2, 6, 3, 1, NULL, 0, 1, 4, 'dziergownictwo_szydelkowanie_dz_seminarium_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(93, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 4, 'szydla_szydelka_szydelkowanie_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(94, 'Szydła-szydełka', 'Szydła-Sz.', 30, 'Z', 3, 6, 3, 1, NULL, 0, 6, 4, 'szydla_szydelka_szydelkowanie_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(95, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'E', 1, 6, 3, 1, NULL, 0, 5, 4, 'prawo_szydelkowania_szydelkowanie_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(96, 'Prawo szydełkowania', 'Prawo Sz.', 45, 'Z', 2, 6, 3, 1, NULL, 0, 6, 4, 'prawo_szydelkowania_szydelkowanie_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(97, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 3, 'dzierganie_praktyczne_robotki_dm_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(98, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'Z', 6, 1, 1, 1, NULL, 1, 6, 3, 'dzierganie_praktyczne_robotki_dm_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(99, 'Podstawy dziergania', 'Pdst. Dzierg.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 3, 'podstawy_dziergania_robotki_dm_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(100, 'Podstawy dziergania', 'Pdst. Dzierg.', 30, 'Z', 6, 1, 1, 1, NULL, 1, 6, 3, 'podstawy_dziergania_robotki_dm_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(101, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 3, 'dzierganie_praktyczne_robotki_dm_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(102, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'Z', 6, 2, 1, 1, NULL, 0, 6, 3, 'dzierganie_praktyczne_robotki_dm_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(103, 'Historia dziergania', 'Hist. Dzierg.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 3, 'historia_dziergania_robotki_dm_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(104, 'Historia dziergania', 'Hist. Dzierg.', 30, 'Z', 6, 2, 1, 1, NULL, 0, 6, 3, 'historia_dziergania_robotki_dm_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(105, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 3, 'dzierganie_teoretyczne_robotki_dm_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(106, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'Z', 6, 3, 2, 1, NULL, 1, 6, 3, 'dzierganie_teoretyczne_robotki_dm_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(107, 'Zastosowania dziergania', 'Zast. Dzierg.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 3, 'zastosowania_dziergania_robotki_dm_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(108, 'Zastosowania dziergania', 'Zast. Dzierg.', 30, 'Z', 6, 3, 2, 1, NULL, 1, 6, 3, 'zastosowania_dziergania_robotki_dm_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(109, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 3, 'dzierganie_teoretyczne_robotki_dm_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(110, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'Z', 6, 4, 2, 1, NULL, 0, 6, 3, 'dzierganie_teoretyczne_robotki_dm_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(111, 'Dziergu-dziergu', 'DD', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 3, 'dziergu_dziergu_robotki_dm_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(112, 'Dziergu-dziergu', 'DD', 30, 'Z', 6, 4, 2, 1, NULL, 0, 6, 3, 'dziergu_dziergu_robotki_dm_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(113, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 3, 'tkanie_i_dzierganie_robotki_dm_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(114, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'Z', 6, 5, 3, 1, NULL, 1, 6, 3, 'tkanie_i_dzierganie_robotki_dm_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(115, 'Maszyny tkackie', 'Maszyny', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 3, 'maszyny_tkackie_robotki_dm_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(116, 'Maszyny tkackie', 'Maszyny', 30, 'Z', 6, 5, 3, 1, NULL, 1, 6, 3, 'maszyny_tkackie_robotki_dm_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(117, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 3, 'obsluga_maszyn_tkackich_robotki_dm_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(118, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'Z', 6, 5, 3, 1, NULL, 1, 6, 3, 'obsluga_maszyn_tkackich_robotki_dm_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(119, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 3, 'tkanie_i_dzierganie_robotki_dm_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(120, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'Z', 6, 6, 3, 1, NULL, 0, 6, 3, 'tkanie_i_dzierganie_robotki_dm_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(121, 'Maszyny tkackie', 'Maszyny', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 3, 'maszyny_tkackie_robotki_dm_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(122, 'Maszyny tkackie', 'Maszyny', 30, 'Z', 6, 6, 3, 1, NULL, 0, 6, 3, 'maszyny_tkackie_robotki_dm_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(123, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 3, 'obsluga_maszyn_tkackich_robotki_dm_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(124, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'Z', 6, 6, 3, 1, NULL, 0, 6, 3, 'obsluga_maszyn_tkackich_robotki_dm_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(125, 'Druty a szydła', 'Druty a sz.', 30, 'E', 1, 7, 4, 1, NULL, 1, 5, 3, 'druty_a_szydla_robotki_dm_wyklady_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(126, 'Druty a szydła', 'Druty a sz.', 30, 'Z', 6, 7, 4, 1, NULL, 1, 6, 3, 'druty_a_szydla_robotki_dm_cwiczenia_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(127, 'Robienie na drutach', 'Robienie na dr.', 30, 'E', 1, 7, 4, 1, NULL, 1, 5, 3, 'robienie_na_drutach_robotki_dm_wyklady_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(128, 'Robienie na drutach', 'Robienie na dr.', 30, 'Z', 6, 7, 4, 1, NULL, 1, 6, 3, 'robienie_na_drutach_robotki_dm_cwiczenia_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(129, 'Swetry &mdash; tkać czy dziergać?', 'Swetry', 30, 'E', 1, 7, 4, 1, NULL, 1, 5, 3, 'swetry_mdash_tkac_czy_dziergac_robotki_dm_wyklady_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(130, 'Swetry &mdash; tkać czy dziergać?', 'Swetry', 30, 'Z', 6, 7, 4, 1, NULL, 1, 6, 3, 'swetry_mdash_tkac_czy_dziergac_robotki_dm_cwiczenia_7');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(131, 'Druty a szydła', 'Druty a sz.', 30, 'E', 1, 8, 4, 1, NULL, 0, 5, 3, 'druty_a_szydla_robotki_dm_wyklady_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(132, 'Druty a szydła', 'Druty a sz.', 30, 'Z', 6, 8, 4, 1, NULL, 0, 6, 3, 'druty_a_szydla_robotki_dm_cwiczenia_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(133, 'Robienie na drutach', 'Robienie na dr.', 30, 'E', 1, 8, 4, 1, NULL, 0, 5, 3, 'robienie_na_drutach_robotki_dm_wyklady_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(134, 'Robienie na drutach', 'Robienie na dr.', 30, 'Z', 6, 8, 4, 1, NULL, 0, 6, 3, 'robienie_na_drutach_robotki_dm_cwiczenia_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(135, 'Swetry &mdash; tkać czy dziergać?', 'Swetry', 30, 'E', 1, 8, 4, 1, NULL, 0, 5, 3, 'swetry_mdash_tkac_czy_dziergac_robotki_dm_wyklady_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(136, 'Swetry &mdash; tkać czy dziergać?', 'Swetry', 30, 'Z', 6, 8, 4, 1, NULL, 0, 6, 3, 'swetry_mdash_tkac_czy_dziergac_robotki_dm_cwiczenia_8');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(137, 'Makrama', 'Makrama', 30, 'Z', 3, 9, 5, 1, NULL, 1, 1, 3, 'makrama_robotki_dm_seminarium_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(138, 'Szydlarstwo przemysłowe', 'Szydlarstwo przemysłowe', 30, 'Z', 3, 9, 5, 1, NULL, 1, 1, 3, 'szydlarstwo_przemyslowe_robotki_dm_seminarium_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(139, 'O efektywnym dzierganiu', 'O efekt. dz.', 30, 'E', 1, 9, 5, 1, NULL, 1, 5, 3, 'o_efektywnym_dzierganiu_robotki_dm_wyklady_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(140, 'O efektywnym dzierganiu', 'O efekt. dz.', 30, 'Z', 4, 9, 5, 1, NULL, 1, 6, 3, 'o_efektywnym_dzierganiu_robotki_dm_cwiczenia_9');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(141, 'Makrama', 'Makrama', 30, 'Z', 3, 10, 5, 1, NULL, 0, 1, 3, 'makrama_robotki_dm_seminarium_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(142, 'Szydlarstwo przemysłowe', 'Szydlarstwo przemysłowe', 30, 'Z', 3, 10, 5, 1, NULL, 0, 1, 3, 'szydlarstwo_przemyslowe_robotki_dm_seminarium_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(143, 'O efektywnym dzierganiu', 'O efekt. dz.', 30, 'E', 1, 10, 5, 1, NULL, 0, 5, 3, 'o_efektywnym_dzierganiu_robotki_dm_wyklady_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(144, 'O efektywnym dzierganiu', 'O efekt. dz.', 30, 'Z', 4, 10, 5, 1, NULL, 0, 6, 3, 'o_efektywnym_dzierganiu_robotki_dm_cwiczenia_10');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(145, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 2, 'dzierganie_praktyczne_robotki_dz_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(146, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'Z', 6, 1, 1, 1, NULL, 1, 6, 2, 'dzierganie_praktyczne_robotki_dz_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(147, 'Podstawy dziergania', 'Pdst. Dzierg.', 30, 'E', 1, 1, 1, 1, NULL, 1, 5, 2, 'podstawy_dziergania_robotki_dz_wyklady_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(148, 'Podstawy dziergania', 'Pdst. Dzierg.', 30, 'Z', 6, 1, 1, 1, NULL, 1, 6, 2, 'podstawy_dziergania_robotki_dz_cwiczenia_1');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(149, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 2, 'dzierganie_praktyczne_robotki_dz_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(150, 'Dzierganie praktyczne', 'Dzierg. Prakt.', 30, 'Z', 6, 2, 1, 1, NULL, 0, 6, 2, 'dzierganie_praktyczne_robotki_dz_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(151, 'Historia dziergania', 'Hist. Dzierg.', 30, 'E', 1, 2, 1, 1, NULL, 0, 5, 2, 'historia_dziergania_robotki_dz_wyklady_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(152, 'Historia dziergania', 'Hist. Dzierg.', 30, 'Z', 6, 2, 1, 1, NULL, 0, 6, 2, 'historia_dziergania_robotki_dz_cwiczenia_2');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(153, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 2, 'dzierganie_teoretyczne_robotki_dz_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(154, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'Z', 6, 3, 2, 1, NULL, 1, 6, 2, 'dzierganie_teoretyczne_robotki_dz_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(155, 'Zastosowania dziergania', 'Zast. Dzierg.', 30, 'E', 1, 3, 2, 1, NULL, 1, 5, 2, 'zastosowania_dziergania_robotki_dz_wyklady_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(156, 'Zastosowania dziergania', 'Zast. Dzierg.', 30, 'Z', 6, 3, 2, 1, NULL, 1, 6, 2, 'zastosowania_dziergania_robotki_dz_cwiczenia_3');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(157, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 2, 'dzierganie_teoretyczne_robotki_dz_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(158, 'Dzierganie teoretyczne', 'Dzierg. Teor.', 30, 'Z', 6, 4, 2, 1, NULL, 0, 6, 2, 'dzierganie_teoretyczne_robotki_dz_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(159, 'Dziergu-dziergu', 'DD', 30, 'E', 1, 4, 2, 1, NULL, 0, 5, 2, 'dziergu_dziergu_robotki_dz_wyklady_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(160, 'Dziergu-dziergu', 'DD', 30, 'Z', 6, 4, 2, 1, NULL, 0, 6, 2, 'dziergu_dziergu_robotki_dz_cwiczenia_4');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(161, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 2, 'tkanie_i_dzierganie_robotki_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(162, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'Z', 6, 5, 3, 1, NULL, 1, 6, 2, 'tkanie_i_dzierganie_robotki_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(163, 'Maszyny tkackie', 'Maszyny', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 2, 'maszyny_tkackie_robotki_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(164, 'Maszyny tkackie', 'Maszyny', 30, 'Z', 6, 5, 3, 1, NULL, 1, 6, 2, 'maszyny_tkackie_robotki_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(165, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'E', 1, 5, 3, 1, NULL, 1, 5, 2, 'obsluga_maszyn_tkackich_robotki_dz_wyklady_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(166, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'Z', 6, 5, 3, 1, NULL, 1, 6, 2, 'obsluga_maszyn_tkackich_robotki_dz_cwiczenia_5');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(167, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 2, 'tkanie_i_dzierganie_robotki_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(168, 'Tkanie i dzierganie', 'Tkanie i dz.', 30, 'Z', 6, 6, 3, 1, NULL, 0, 6, 2, 'tkanie_i_dzierganie_robotki_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(169, 'Maszyny tkackie', 'Maszyny', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 2, 'maszyny_tkackie_robotki_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(170, 'Maszyny tkackie', 'Maszyny', 30, 'Z', 6, 6, 3, 1, NULL, 0, 6, 2, 'maszyny_tkackie_robotki_dz_cwiczenia_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(171, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'E', 1, 6, 3, 1, NULL, 0, 5, 2, 'obsluga_maszyn_tkackich_robotki_dz_wyklady_6');
INSERT INTO `przedmiot` (`przedmiot_id`, `nazwa`, `skrot`, `godz`, `zal`, `liczbagrup`, `semestr`, `rok`, `odbywa_sie`, `nazwa_alternatywna`, `zimalato`, `rodzajzajec_id`, `kierunek_id`, `slug`) VALUES(172, 'Obsługa maszyn tkackich', 'Obsł. Masz.', 30, 'Z', 6, 6, 3, 1, NULL, 0, 6, 2, 'obsluga_maszyn_tkackich_robotki_dz_cwiczenia_6');

--
-- Zrzut danych tabeli `przydzial`
--

INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(1, 1, NULL, NULL, 125);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(2, 1, NULL, NULL, 131);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(3, 1, NULL, NULL, 126);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(4, 2, NULL, 22, 126);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(5, 3, NULL, NULL, 126);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(6, 4, NULL, NULL, 126);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(7, 5, NULL, 22, 126);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(8, 6, NULL, NULL, 126);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(9, 1, NULL, NULL, 132);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(10, 2, NULL, NULL, 132);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(11, 3, NULL, 21, 132);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(12, 4, NULL, NULL, 132);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(13, 5, NULL, NULL, 132);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(14, 6, NULL, NULL, 132);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(15, 1, NULL, NULL, 97);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(16, 1, NULL, NULL, 101);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(17, 1, NULL, NULL, 145);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(18, 1, NULL, NULL, 149);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(19, 1, NULL, NULL, 98);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(20, 2, NULL, 14, 98);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(21, 3, NULL, NULL, 98);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(22, 4, NULL, 20, 98);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(23, 5, NULL, 5, 98);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(24, 6, NULL, NULL, 98);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(25, 1, NULL, 22, 102);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(26, 2, NULL, NULL, 102);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(27, 3, NULL, NULL, 102);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(28, 4, NULL, 15, 102);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(29, 5, NULL, NULL, 102);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(30, 6, NULL, 10, 102);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(31, 1, NULL, NULL, 146);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(32, 2, NULL, 15, 146);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(33, 3, NULL, 2, 146);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(34, 4, NULL, NULL, 146);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(35, 5, NULL, 2, 146);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(36, 6, NULL, NULL, 146);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(37, 1, NULL, NULL, 150);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(38, 2, NULL, NULL, 150);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(39, 3, NULL, NULL, 150);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(40, 4, NULL, NULL, 150);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(41, 5, NULL, 29, 150);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(42, 6, NULL, 14, 150);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(43, 1, NULL, NULL, 105);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(44, 1, NULL, NULL, 109);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(45, 1, NULL, 4, 153);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(46, 1, NULL, NULL, 157);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(47, 1, NULL, NULL, 106);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(48, 2, NULL, 14, 106);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(49, 3, NULL, 26, 106);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(50, 4, NULL, NULL, 106);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(51, 5, NULL, 2, 106);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(52, 6, NULL, NULL, 106);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(53, 1, NULL, NULL, 110);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(54, 2, NULL, NULL, 110);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(55, 3, NULL, 29, 110);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(56, 4, NULL, 20, 110);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(57, 5, NULL, NULL, 110);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(58, 6, NULL, NULL, 110);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(59, 1, NULL, NULL, 154);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(60, 2, NULL, NULL, 154);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(61, 3, NULL, NULL, 154);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(62, 4, NULL, NULL, 154);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(63, 5, NULL, 18, 154);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(64, 6, NULL, NULL, 154);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(65, 1, NULL, 26, 158);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(66, 2, NULL, 2, 158);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(67, 3, NULL, NULL, 158);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(68, 4, NULL, 12, 158);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(69, 5, NULL, NULL, 158);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(70, 6, NULL, NULL, 158);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(71, 1, NULL, 17, 32);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(72, 2, NULL, 7, 32);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(73, 1, NULL, NULL, 38);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(74, 2, NULL, NULL, 38);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(75, 1, NULL, 19, 44);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(76, 2, NULL, NULL, 44);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(77, 1, NULL, 7, 50);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(78, 2, NULL, 7, 50);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(79, 1, NULL, 14, 80);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(80, 2, NULL, NULL, 80);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(81, 1, NULL, NULL, 92);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(82, 2, NULL, NULL, 92);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(83, 1, NULL, NULL, 111);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(84, 1, NULL, 14, 159);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(85, 1, NULL, 29, 112);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(86, 2, NULL, NULL, 112);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(87, 3, NULL, 6, 112);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(88, 4, NULL, NULL, 112);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(89, 5, NULL, NULL, 112);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(90, 6, NULL, NULL, 112);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(91, 1, NULL, NULL, 160);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(92, 2, NULL, NULL, 160);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(93, 3, NULL, NULL, 160);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(94, 4, NULL, 5, 160);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(95, 5, NULL, NULL, 160);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(96, 6, NULL, 5, 160);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(97, 1, NULL, 7, 103);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(98, 1, NULL, 22, 151);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(99, 1, NULL, NULL, 104);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(100, 2, NULL, NULL, 104);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(101, 3, NULL, 22, 104);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(102, 4, NULL, NULL, 104);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(103, 5, NULL, NULL, 104);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(104, 6, NULL, NULL, 104);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(105, 1, NULL, NULL, 152);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(106, 2, NULL, NULL, 152);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(107, 3, NULL, 17, 152);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(108, 4, NULL, NULL, 152);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(109, 5, NULL, NULL, 152);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(110, 6, NULL, NULL, 152);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(111, 1, NULL, NULL, 1);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(112, 1, NULL, NULL, 7);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(113, 1, NULL, NULL, 55);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(114, 1, NULL, 5, 61);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(115, 1, NULL, NULL, 2);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(116, 2, NULL, 28, 2);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(117, 3, NULL, NULL, 2);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(118, 4, NULL, NULL, 2);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(119, 1, NULL, NULL, 8);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(120, 2, NULL, 15, 8);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(121, 3, NULL, 2, 8);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(122, 4, NULL, NULL, 8);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(123, 1, NULL, 9, 56);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(124, 2, NULL, NULL, 56);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(125, 3, NULL, NULL, 56);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(126, 4, NULL, 15, 56);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(127, 1, NULL, NULL, 62);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(128, 2, NULL, NULL, 62);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(129, 3, NULL, NULL, 62);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(130, 4, NULL, NULL, 62);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(131, 1, NULL, NULL, 21);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(132, 1, NULL, NULL, 27);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(133, 1, NULL, NULL, 75);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(134, 1, NULL, NULL, 87);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(135, 1, NULL, NULL, 22);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(136, 2, NULL, 10, 22);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(137, 3, NULL, NULL, 22);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(138, 1, NULL, 10, 28);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(139, 2, NULL, NULL, 28);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(140, 3, NULL, NULL, 28);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(141, 1, NULL, 15, 76);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(142, 2, NULL, NULL, 76);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(143, 3, NULL, NULL, 76);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(144, 1, NULL, NULL, 88);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(145, 2, NULL, 10, 88);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(146, 3, NULL, NULL, 88);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(147, 1, NULL, NULL, 45);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(148, 1, NULL, 24, 51);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(149, 1, NULL, 14, 46);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(150, 2, NULL, NULL, 46);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(151, 3, NULL, NULL, 46);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(152, 1, NULL, 21, 52);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(153, 2, NULL, NULL, 52);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(154, 3, NULL, 27, 52);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(155, 1, NULL, 26, 137);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(156, 2, NULL, NULL, 137);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(157, 3, NULL, NULL, 137);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(158, 1, NULL, 22, 141);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(159, 2, NULL, 13, 141);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(160, 3, NULL, 7, 141);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(161, 1, NULL, NULL, 115);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(162, 1, NULL, NULL, 121);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(163, 1, NULL, NULL, 163);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(164, 1, NULL, 14, 169);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(165, 1, NULL, NULL, 116);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(166, 2, NULL, 3, 116);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(167, 3, NULL, NULL, 116);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(168, 4, NULL, NULL, 116);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(169, 5, NULL, 9, 116);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(170, 6, NULL, NULL, 116);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(171, 1, NULL, NULL, 122);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(172, 2, NULL, NULL, 122);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(173, 3, NULL, NULL, 122);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(174, 4, NULL, NULL, 122);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(175, 5, NULL, NULL, 122);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(176, 6, NULL, 8, 122);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(177, 1, NULL, NULL, 164);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(178, 2, NULL, NULL, 164);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(179, 3, NULL, 10, 164);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(180, 4, NULL, NULL, 164);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(181, 5, NULL, NULL, 164);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(182, 6, NULL, NULL, 164);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(183, 1, NULL, 11, 170);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(184, 2, NULL, 7, 170);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(185, 3, NULL, NULL, 170);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(186, 4, NULL, NULL, 170);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(187, 5, NULL, 15, 170);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(188, 6, NULL, 25, 170);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(189, 1, NULL, 9, 11);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(190, 1, NULL, NULL, 65);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(191, 1, NULL, NULL, 12);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(192, 2, NULL, NULL, 12);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(193, 3, NULL, NULL, 12);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(194, 1, NULL, 18, 66);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(195, 2, NULL, 14, 66);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(196, 3, NULL, NULL, 66);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(197, 1, NULL, NULL, 139);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(198, 1, NULL, NULL, 143);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(199, 1, NULL, NULL, 140);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(200, 2, NULL, 26, 140);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(201, 3, NULL, 18, 140);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(202, 4, NULL, NULL, 140);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(203, 1, NULL, NULL, 144);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(204, 2, NULL, 18, 144);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(205, 3, NULL, 25, 144);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(206, 4, NULL, NULL, 144);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(207, 1, NULL, 22, 117);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(208, 1, NULL, 9, 123);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(209, 1, NULL, 15, 165);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(210, 1, NULL, NULL, 171);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(211, 1, NULL, 13, 118);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(212, 2, NULL, NULL, 118);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(213, 3, NULL, NULL, 118);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(214, 4, NULL, NULL, 118);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(215, 5, NULL, NULL, 118);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(216, 6, NULL, 18, 118);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(217, 1, NULL, 12, 124);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(218, 2, NULL, 13, 124);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(219, 3, NULL, NULL, 124);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(220, 4, NULL, 4, 124);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(221, 5, NULL, 11, 124);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(222, 6, NULL, NULL, 124);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(223, 1, NULL, 13, 166);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(224, 2, NULL, 26, 166);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(225, 3, NULL, NULL, 166);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(226, 4, NULL, NULL, 166);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(227, 5, NULL, 20, 166);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(228, 6, NULL, NULL, 166);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(229, 1, NULL, 10, 172);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(230, 2, NULL, 20, 172);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(231, 3, NULL, NULL, 172);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(232, 4, NULL, NULL, 172);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(233, 5, NULL, NULL, 172);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(234, 6, NULL, 19, 172);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(235, 1, NULL, 17, 99);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(236, 1, NULL, 18, 147);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(237, 1, NULL, 28, 100);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(238, 2, NULL, 21, 100);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(239, 3, NULL, NULL, 100);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(240, 4, NULL, 16, 100);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(241, 5, NULL, 8, 100);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(242, 6, NULL, 7, 100);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(243, 1, NULL, NULL, 148);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(244, 2, NULL, NULL, 148);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(245, 3, NULL, NULL, 148);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(246, 4, NULL, NULL, 148);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(247, 5, NULL, NULL, 148);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(248, 6, NULL, NULL, 148);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(249, 1, NULL, 16, 5);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(250, 1, NULL, NULL, 59);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(251, 1, NULL, 17, 6);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(252, 2, NULL, NULL, 6);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(253, 3, NULL, 6, 6);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(254, 4, NULL, 10, 6);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(255, 1, NULL, NULL, 60);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(256, 2, NULL, NULL, 60);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(257, 3, NULL, NULL, 60);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(258, 4, NULL, NULL, 60);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(259, 1, NULL, 17, 35);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(260, 1, NULL, NULL, 41);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(261, 1, NULL, NULL, 83);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(262, 1, NULL, 17, 95);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(263, 1, NULL, NULL, 36);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(264, 2, NULL, NULL, 36);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(265, 1, NULL, 23, 42);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(266, 2, NULL, NULL, 42);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(267, 1, NULL, NULL, 48);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(268, 2, NULL, 24, 48);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(269, 1, NULL, NULL, 54);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(270, 2, NULL, NULL, 54);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(271, 1, NULL, NULL, 84);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(272, 2, NULL, NULL, 84);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(273, 1, NULL, 29, 96);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(274, 2, NULL, NULL, 96);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(275, 1, NULL, 23, 127);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(276, 1, NULL, 17, 133);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(277, 1, NULL, 11, 128);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(278, 2, NULL, 3, 128);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(279, 3, NULL, NULL, 128);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(280, 4, NULL, 23, 128);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(281, 5, NULL, NULL, 128);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(282, 6, NULL, NULL, 128);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(283, 1, NULL, 28, 134);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(284, 2, NULL, 1, 134);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(285, 3, NULL, 4, 134);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(286, 4, NULL, 8, 134);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(287, 5, NULL, 9, 134);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(288, 6, NULL, NULL, 134);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(289, 1, NULL, NULL, 15);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(290, 1, NULL, NULL, 69);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(291, 1, NULL, 2, 16);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(292, 2, NULL, 9, 16);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(293, 3, NULL, 12, 16);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(294, 1, NULL, NULL, 70);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(295, 2, NULL, NULL, 70);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(296, 3, NULL, NULL, 70);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(297, 1, NULL, NULL, 129);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(298, 1, NULL, 10, 135);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(299, 1, NULL, 14, 130);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(300, 2, NULL, NULL, 130);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(301, 3, NULL, NULL, 130);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(302, 4, NULL, NULL, 130);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(303, 5, NULL, 20, 130);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(304, 6, NULL, 8, 130);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(305, 1, NULL, NULL, 136);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(306, 2, NULL, NULL, 136);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(307, 3, NULL, NULL, 136);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(308, 4, NULL, NULL, 136);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(309, 5, NULL, 18, 136);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(310, 6, NULL, NULL, 136);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(311, 1, NULL, NULL, 17);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(312, 1, NULL, 18, 71);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(313, 1, NULL, 3, 18);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(314, 2, NULL, 13, 18);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(315, 3, NULL, NULL, 18);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(316, 4, NULL, 24, 18);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(317, 1, NULL, 1, 72);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(318, 2, NULL, 7, 72);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(319, 3, NULL, NULL, 72);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(320, 4, NULL, NULL, 72);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(321, 1, NULL, NULL, 13);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(322, 1, NULL, 28, 67);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(323, 1, NULL, NULL, 14);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(324, 2, NULL, NULL, 14);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(325, 3, NULL, NULL, 14);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(326, 1, NULL, NULL, 68);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(327, 2, NULL, NULL, 68);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(328, 3, NULL, NULL, 68);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(329, 1, NULL, NULL, 9);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(330, 1, NULL, NULL, 63);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(331, 1, NULL, NULL, 10);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(332, 2, NULL, 2, 10);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(333, 3, NULL, 4, 10);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(334, 4, NULL, 1, 10);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(335, 1, NULL, NULL, 64);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(336, 2, NULL, 6, 64);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(337, 3, NULL, 29, 64);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(338, 4, NULL, NULL, 64);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(339, 1, NULL, NULL, 3);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(340, 1, NULL, NULL, 57);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(341, 1, NULL, NULL, 4);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(342, 2, NULL, NULL, 4);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(343, 3, NULL, NULL, 4);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(344, 4, NULL, NULL, 4);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(345, 1, NULL, NULL, 58);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(346, 2, NULL, NULL, 58);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(347, 3, NULL, 7, 58);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(348, 4, NULL, NULL, 58);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(349, 1, NULL, NULL, 19);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(350, 1, NULL, 10, 73);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(351, 1, NULL, NULL, 20);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(352, 2, NULL, NULL, 20);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(353, 3, NULL, 25, 20);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(354, 1, NULL, NULL, 74);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(355, 2, NULL, NULL, 74);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(356, 3, NULL, NULL, 74);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(357, 1, NULL, 4, 31);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(358, 2, NULL, 29, 31);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(359, 1, NULL, 16, 37);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(360, 2, NULL, 24, 37);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(361, 1, NULL, NULL, 43);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(362, 2, NULL, NULL, 43);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(363, 1, NULL, 19, 49);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(364, 2, NULL, 26, 49);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(365, 1, NULL, 10, 79);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(366, 2, NULL, NULL, 79);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(367, 1, NULL, NULL, 91);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(368, 2, NULL, NULL, 91);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(369, 1, NULL, 12, 138);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(370, 2, NULL, 21, 138);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(371, 3, NULL, NULL, 138);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(372, 1, NULL, 14, 142);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(373, 2, NULL, 8, 142);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(374, 3, NULL, NULL, 142);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(375, 1, NULL, 9, 33);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(376, 1, NULL, 24, 39);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(377, 1, NULL, 7, 81);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(378, 1, NULL, NULL, 93);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(379, 1, NULL, NULL, 34);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(380, 2, NULL, 17, 34);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(381, 3, NULL, NULL, 34);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(382, 1, NULL, NULL, 40);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(383, 2, NULL, 18, 40);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(384, 3, NULL, NULL, 40);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(385, 1, NULL, 21, 82);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(386, 2, NULL, 7, 82);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(387, 3, NULL, 14, 82);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(388, 1, NULL, NULL, 94);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(389, 2, NULL, 26, 94);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(390, 3, NULL, 6, 94);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(391, 1, NULL, NULL, 25);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(392, 1, NULL, 25, 85);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(393, 1, NULL, 1, 26);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(394, 2, NULL, 17, 26);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(395, 1, NULL, 20, 86);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(396, 2, NULL, NULL, 86);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(397, 1, NULL, 6, 23);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(398, 1, NULL, 28, 29);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(399, 1, NULL, NULL, 77);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(400, 1, NULL, NULL, 89);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(401, 1, NULL, 2, 24);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(402, 2, NULL, NULL, 24);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(403, 1, NULL, NULL, 30);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(404, 2, NULL, NULL, 30);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(405, 1, NULL, 21, 78);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(406, 2, NULL, NULL, 78);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(407, 1, NULL, NULL, 90);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(408, 2, NULL, NULL, 90);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(409, 1, NULL, 26, 113);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(410, 1, NULL, NULL, 119);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(411, 1, NULL, NULL, 161);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(412, 1, NULL, 16, 167);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(413, 1, NULL, NULL, 114);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(414, 2, NULL, NULL, 114);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(415, 3, NULL, NULL, 114);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(416, 4, NULL, 19, 114);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(417, 5, NULL, NULL, 114);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(418, 6, NULL, 25, 114);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(419, 1, NULL, NULL, 120);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(420, 2, NULL, 23, 120);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(421, 3, NULL, NULL, 120);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(422, 4, NULL, 19, 120);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(423, 5, NULL, NULL, 120);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(424, 6, NULL, NULL, 120);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(425, 1, NULL, 5, 162);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(426, 2, NULL, 2, 162);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(427, 3, NULL, NULL, 162);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(428, 4, NULL, NULL, 162);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(429, 5, NULL, NULL, 162);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(430, 6, NULL, NULL, 162);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(431, 1, NULL, NULL, 168);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(432, 2, NULL, NULL, 168);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(433, 3, NULL, 22, 168);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(434, 4, NULL, NULL, 168);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(435, 5, NULL, NULL, 168);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(436, 6, NULL, 28, 168);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(437, 1, NULL, NULL, 47);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(438, 1, NULL, 18, 53);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(439, 1, NULL, 14, 107);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(440, 1, NULL, 14, 155);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(441, 1, NULL, 26, 108);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(442, 2, NULL, 3, 108);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(443, 3, NULL, 14, 108);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(444, 4, NULL, NULL, 108);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(445, 5, NULL, 29, 108);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(446, 6, NULL, NULL, 108);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(447, 1, NULL, NULL, 156);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(448, 2, NULL, 1, 156);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(449, 3, NULL, NULL, 156);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(450, 4, NULL, NULL, 156);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(451, 5, NULL, NULL, 156);
INSERT INTO `przydzial` (`przydzial_id`, `numergrupy`, `nazwa_alternatywna`, `pracownik_id`, `przedmiot_id`) VALUES(452, 6, NULL, NULL, 156);

--
-- Zrzut danych tabeli `rodzajstudiow`
--

INSERT INTO `rodzajstudiow` (`rodzajstudiow_id`, `nazwa`, `skrot`, `semestry`, `lata`, `slug`) VALUES(1, 'podyplomowe', 'podypl.', 4, 2, 'podyplomowe');
INSERT INTO `rodzajstudiow` (`rodzajstudiow_id`, `nazwa`, `skrot`, `semestry`, `lata`, `slug`) VALUES(2, 'dzienne zawodowe', 'd. z.', 6, 3, 'dzienne_zawodowe');
INSERT INTO `rodzajstudiow` (`rodzajstudiow_id`, `nazwa`, `skrot`, `semestry`, `lata`, `slug`) VALUES(3, 'zaoczne zawodowe', 'z. z.', 6, 3, 'zaoczne_zawodowe');
INSERT INTO `rodzajstudiow` (`rodzajstudiow_id`, `nazwa`, `skrot`, `semestry`, `lata`, `slug`) VALUES(4, 'zaoczne uzupełniające', 'uz.', 4, 2, 'zaoczne_uzupelniajace');
INSERT INTO `rodzajstudiow` (`rodzajstudiow_id`, `nazwa`, `skrot`, `semestry`, `lata`, `slug`) VALUES(5, 'dzienne magisterskie', 'd. m.', 10, 5, 'dzienne_magisterskie');

--
-- Zrzut danych tabeli `rodzajzajec`
--

INSERT INTO `rodzajzajec` (`rodzajzajec_id`, `nazwa`, `skrot`, `grupy`, `sortowanie`, `slug`) VALUES(1, 'seminarium', 'sem.', 1, 30, 'seminarium');
INSERT INTO `rodzajzajec` (`rodzajzajec_id`, `nazwa`, `skrot`, `grupy`, `sortowanie`, `slug`) VALUES(2, 'pracownia magisterska', 'p.m.', 1, 40, 'pracownia_magisterska');
INSERT INTO `rodzajzajec` (`rodzajzajec_id`, `nazwa`, `skrot`, `grupy`, `sortowanie`, `slug`) VALUES(3, 'pracownia dyplomowa', 'p.d.', 1, 50, 'pracownia_dyplomowa');
INSERT INTO `rodzajzajec` (`rodzajzajec_id`, `nazwa`, `skrot`, `grupy`, `sortowanie`, `slug`) VALUES(4, 'konwersatorium', 'kon.', 0, 20, 'konwersatorium');
INSERT INTO `rodzajzajec` (`rodzajzajec_id`, `nazwa`, `skrot`, `grupy`, `sortowanie`, `slug`) VALUES(5, 'wykłady', 'wyk.', 0, 10, 'wyklady');
INSERT INTO `rodzajzajec` (`rodzajzajec_id`, `nazwa`, `skrot`, `grupy`, `sortowanie`, `slug`) VALUES(6, 'ćwiczenia', 'ćw.', 1, 60, 'cwiczenia');

--
-- Zrzut danych tabeli `stanowisko`
--

INSERT INTO `stanowisko` (`stanowisko_id`, `nazwa`, `skrot`, `pensum`, `sortowanie`, `slug`) VALUES(1, 'starszy wykładowca', 'st. wyk. bez dr', 300, 25, 'starszy_wykladowca');
INSERT INTO `stanowisko` (`stanowisko_id`, `nazwa`, `skrot`, `pensum`, `sortowanie`, `slug`) VALUES(2, 'wykładowca', 'wykładowca', 360, 30, 'wykladowca');
INSERT INTO `stanowisko` (`stanowisko_id`, `nazwa`, `skrot`, `pensum`, `sortowanie`, `slug`) VALUES(3, 'profesor', 'profesor', 210, 10, 'profesor');
INSERT INTO `stanowisko` (`stanowisko_id`, `nazwa`, `skrot`, `pensum`, `sortowanie`, `slug`) VALUES(4, 'adiunkt', 'adiunkt', 210, 20, 'adiunkt');
INSERT INTO `stanowisko` (`stanowisko_id`, `nazwa`, `skrot`, `pensum`, `sortowanie`, `slug`) VALUES(5, 'asystent', 'asystent', 210, 40, 'asystent');

--
-- Zrzut danych tabeli `wydzial`
--

INSERT INTO `wydzial` (`wydzial_id`, `nazwa`, `skrot`, `slug`) VALUES(1, 'Wydział Dowcipkowania', 'WD', 'wydzial_dowcipkowania');
INSERT INTO `wydzial` (`wydzial_id`, `nazwa`, `skrot`, `slug`) VALUES(2, 'Wydział Prac Ręcznych', 'WPR', 'wydzial_prac_recznych');
INSERT INTO `wydzial` (`wydzial_id`, `nazwa`, `skrot`, `slug`) VALUES(3, 'Wydział Szydełkowania', 'WS', 'wydzial_szydelkowania');

SET FOREIGN_KEY_CHECKS=1;
