<?php

require_once 'propel/om/BaseObject.php';

require_once 'propel/om/Persistent.php';


include_once 'propel/util/Criteria.php';

include_once 'cpp/ZadaniePeer.php';

/**
 * Base class that represents a row from the 'zadanie' table.
 *
 * 
 *
 * This class was autogenerated by Propel on:
 *
 * 05/16/08 07:48:27
 *
 * @package    cpp.om
 */
abstract class BaseZadanie extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        ZadaniePeer
	 */
	protected static $peer;


	/**
	 * The value for the zadanie_id field.
	 * @var        int
	 */
	protected $zadanie_id;


	/**
	 * The value for the rozdzial_id field.
	 * @var        int
	 */
	protected $rozdzial_id;


	/**
	 * The value for the numer field.
	 * @var        int
	 */
	protected $numer;


	/**
	 * The value for the tekst field.
	 * @var        string
	 */
	protected $tekst;


	/**
	 * The value for the rozwiazanie field.
	 * @var        string
	 */
	protected $rozwiazanie;

	/**
	 * @var        Rozdzial
	 */
	protected $aRozdzial;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [zadanie_id] column value.
	 * 
	 * @return     int
	 */
	public function getZadanieId()
	{

		return $this->zadanie_id;
	}

	/**
	 * Get the [rozdzial_id] column value.
	 * 
	 * @return     int
	 */
	public function getRozdzialId()
	{

		return $this->rozdzial_id;
	}

	/**
	 * Get the [numer] column value.
	 * 
	 * @return     int
	 */
	public function getNumer()
	{

		return $this->numer;
	}

	/**
	 * Get the [tekst] column value.
	 * 
	 * @return     string
	 */
	public function getTekst()
	{

		return $this->tekst;
	}

	/**
	 * Get the [rozwiazanie] column value.
	 * 
	 * @return     string
	 */
	public function getRozwiazanie()
	{

		return $this->rozwiazanie;
	}

	/**
	 * Set the value of [zadanie_id] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setZadanieId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->zadanie_id !== $v) {
			$this->zadanie_id = $v;
			$this->modifiedColumns[] = ZadaniePeer::ZADANIE_ID;
		}

	} // setZadanieId()

	/**
	 * Set the value of [rozdzial_id] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setRozdzialId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->rozdzial_id !== $v) {
			$this->rozdzial_id = $v;
			$this->modifiedColumns[] = ZadaniePeer::ROZDZIAL_ID;
		}

		if ($this->aRozdzial !== null && $this->aRozdzial->getRozdzialId() !== $v) {
			$this->aRozdzial = null;
		}

	} // setRozdzialId()

	/**
	 * Set the value of [numer] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setNumer($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->numer !== $v) {
			$this->numer = $v;
			$this->modifiedColumns[] = ZadaniePeer::NUMER;
		}

	} // setNumer()

	/**
	 * Set the value of [tekst] column.
	 * 
	 * @param      string $v new value
	 * @return     void
	 */
	public function setTekst($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->tekst !== $v) {
			$this->tekst = $v;
			$this->modifiedColumns[] = ZadaniePeer::TEKST;
		}

	} // setTekst()

	/**
	 * Set the value of [rozwiazanie] column.
	 * 
	 * @param      string $v new value
	 * @return     void
	 */
	public function setRozwiazanie($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->rozwiazanie !== $v) {
			$this->rozwiazanie = $v;
			$this->modifiedColumns[] = ZadaniePeer::ROZWIAZANIE;
		}

	} // setRozwiazanie()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (1-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      ResultSet $rs The ResultSet class with cursor advanced to desired record pos.
	 * @param      int $startcol 1-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate(ResultSet $rs, $startcol = 1)
	{
		try {

			$this->zadanie_id = $rs->getInt($startcol + 0);

			$this->rozdzial_id = $rs->getInt($startcol + 1);

			$this->numer = $rs->getInt($startcol + 2);

			$this->tekst = $rs->getString($startcol + 3);

			$this->rozwiazanie = $rs->getString($startcol + 4);

			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 5; // 5 = ZadaniePeer::NUM_COLUMNS - ZadaniePeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Zadanie object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      Connection $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete($con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ZadaniePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ZadaniePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      Connection $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save($con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ZadaniePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      Connection $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave($con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aRozdzial !== null) {
				if ($this->aRozdzial->isModified()) {
					$affectedRows += $this->aRozdzial->save($con);
				}
				$this->setRozdzial($this->aRozdzial);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ZadaniePeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setZadanieId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += ZadaniePeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aRozdzial !== null) {
				if (!$this->aRozdzial->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aRozdzial->getValidationFailures());
				}
			}


			if (($retval = ZadaniePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants TYPE_PHPNAME,
	 *                     TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ZadaniePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getZadanieId();
				break;
			case 1:
				return $this->getRozdzialId();
				break;
			case 2:
				return $this->getNumer();
				break;
			case 3:
				return $this->getTekst();
				break;
			case 4:
				return $this->getRozwiazanie();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType One of the class type constants TYPE_PHPNAME,
	 *                        TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ZadaniePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getZadanieId(),
			$keys[1] => $this->getRozdzialId(),
			$keys[2] => $this->getNumer(),
			$keys[3] => $this->getTekst(),
			$keys[4] => $this->getRozwiazanie(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants TYPE_PHPNAME,
	 *                     TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ZadaniePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setZadanieId($value);
				break;
			case 1:
				$this->setRozdzialId($value);
				break;
			case 2:
				$this->setNumer($value);
				break;
			case 3:
				$this->setTekst($value);
				break;
			case 4:
				$this->setRozwiazanie($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME,
	 * TYPE_NUM. The default key type is the column's phpname (e.g. 'authorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ZadaniePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setZadanieId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setRozdzialId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setNumer($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setTekst($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setRozwiazanie($arr[$keys[4]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(ZadaniePeer::DATABASE_NAME);

		if ($this->isColumnModified(ZadaniePeer::ZADANIE_ID)) $criteria->add(ZadaniePeer::ZADANIE_ID, $this->zadanie_id);
		if ($this->isColumnModified(ZadaniePeer::ROZDZIAL_ID)) $criteria->add(ZadaniePeer::ROZDZIAL_ID, $this->rozdzial_id);
		if ($this->isColumnModified(ZadaniePeer::NUMER)) $criteria->add(ZadaniePeer::NUMER, $this->numer);
		if ($this->isColumnModified(ZadaniePeer::TEKST)) $criteria->add(ZadaniePeer::TEKST, $this->tekst);
		if ($this->isColumnModified(ZadaniePeer::ROZWIAZANIE)) $criteria->add(ZadaniePeer::ROZWIAZANIE, $this->rozwiazanie);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ZadaniePeer::DATABASE_NAME);

		$criteria->add(ZadaniePeer::ZADANIE_ID, $this->zadanie_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getZadanieId();
	}

	/**
	 * Generic method to set the primary key (zadanie_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setZadanieId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Zadanie (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setRozdzialId($this->rozdzial_id);

		$copyObj->setNumer($this->numer);

		$copyObj->setTekst($this->tekst);

		$copyObj->setRozwiazanie($this->rozwiazanie);


		$copyObj->setNew(true);

		$copyObj->setZadanieId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Zadanie Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     ZadaniePeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ZadaniePeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Rozdzial object.
	 *
	 * @param      Rozdzial $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setRozdzial($v)
	{


		if ($v === null) {
			$this->setRozdzialId(NULL);
		} else {
			$this->setRozdzialId($v->getRozdzialId());
		}


		$this->aRozdzial = $v;
	}


	/**
	 * Get the associated Rozdzial object
	 *
	 * @param      Connection Optional Connection object.
	 * @return     Rozdzial The associated Rozdzial object.
	 * @throws     PropelException
	 */
	public function getRozdzial($con = null)
	{
		// include the related Peer class
		include_once 'cpp/om/BaseRozdzialPeer.php';

		if ($this->aRozdzial === null && ($this->rozdzial_id !== null)) {

			$this->aRozdzial = RozdzialPeer::retrieveByPK($this->rozdzial_id, $con);

			/* The following can be used instead of the line above to
			   guarantee the related object contains a reference
			   to this object, but this level of coupling
			   may be undesirable in many circumstances.
			   As it can lead to a db query with many results that may
			   never be used.
			   $obj = RozdzialPeer::retrieveByPK($this->rozdzial_id, $con);
			   $obj->addRozdzials($this);
			 */
		}
		return $this->aRozdzial;
	}

} // BaseZadanie
