SET NAMES utf8 COLLATE utf8_polish_ci;

DROP DATABASE IF EXISTS produkty;

CREATE DATABASE produkty DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci;

GRANT
    ALL
ON
    produkty.*
TO
    produktyadm@localhost
IDENTIFIED BY
    'produktypass';

FLUSH PRIVILEGES;

USE produkty;
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- produkt
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `produkt`;


CREATE TABLE `produkt`
(
	`produkt_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`produkt` VARCHAR(45),
	`ilosc` INTEGER,
	`cena` FLOAT,
	PRIMARY KEY (`produkt_id`)
)Type=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 2.11.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 15 Maj 2008, 09:00
-- Wersja serwera: 5.0.45
-- Wersja PHP: 5.2.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Baza danych: `produkty`
--

--
-- Zrzut danych tabeli `produkt`
--

INSERT INTO `produkt` (`produkt_id`, `produkt`, `ilosc`, `cena`) VALUES(1, 'Zeszyt', 14, 1.4);
INSERT INTO `produkt` (`produkt_id`, `produkt`, `ilosc`, `cena`) VALUES(2, 'Ołówek', 80, 0.4);
INSERT INTO `produkt` (`produkt_id`, `produkt`, `ilosc`, `cena`) VALUES(3, 'Flamaster', 120, 2.5);
