<?php

/*
 *
 *    db-frame-tool ver. 1.1
 *    http://db-frame-tool.net 
 *
 *    Copyright (C) 2009 Wodzimierz Gajda, http://gajdaw.pl
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */




require_once 'Smarty.class.php';

function set_defaults($conf)
{
    $defaults = array(
        'host'         => 'localhost',
        'database'     => 'mydb',
        'username'     => 'myuser',
        'password'     => 'mypassword',
        'filename'     => 'model.xml',
        'root'         => 'root',
        'rootpassword' => '',
        'encoding'     => 'utf8',
    );
    $default_keys = array_diff(array_keys($defaults), array_keys($conf));
    
    $result = array();
    
    foreach ($default_keys as $k) {
        $result[$k] = $defaults[$k];        
    }
    
    return array_merge($result, $conf);
}

$conf = parse_ini_file('input/conf.ini');
$conf = set_defaults($conf);

$conf['modelfilename'] = 'input/' . $conf['filename'];

if (!file_exists($conf['modelfilename'])) {
    die('model not found');
}
copy($conf['modelfilename'], 'output/propel/schema.xml');

$s = new Smarty();

$s->template_dir = './app/templates/';
$s->compile_dir = './app/templates_c/';

$s->assign('conf', $conf);
file_put_contents('output/propel/build.properties', $s->fetch('build.properties.tpl'));
file_put_contents('output/propel/runtime-conf.xml', $s->fetch('runtime-conf.xml.tpl'));
file_put_contents('output/sql/sql-create-base.sql', $s->fetch('sql-create-base.sql.tpl'));
file_put_contents('create-db.bat', $s->fetch('create-db.bat.tpl'));
file_put_contents('create-db-filled.bat', $s->fetch('create-db-filled.bat.tpl'));


