<?php


/**
 * This class adds structure of 'model_has_auto' table to 'autokomis' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    autokomis.map
 */
class ModelHasAutoMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'autokomis.map.ModelHasAutoMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ModelHasAutoPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ModelHasAutoPeer::TABLE_NAME);
		$tMap->setPhpName('ModelHasAuto');
		$tMap->setClassname('ModelHasAuto');

		$tMap->setUseIdGenerator(false);

		$tMap->addForeignPrimaryKey('MODEL_ID', 'ModelId', 'INTEGER' , 'model', 'MODEL_ID', true, null);

		$tMap->addForeignPrimaryKey('AUTO_ID', 'AutoId', 'INTEGER' , 'auto', 'AUTO_ID', true, null);

	} // doBuild()

} // ModelHasAutoMapBuilder
