set names utf8;
drop database if exists slownik;
create database slownik default character set utf8 collate utf8_polish_ci;
grant all on slownik.* to admin@localhost identified by 'password';
flush privileges;
use slownik;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- kolor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kolor`;


CREATE TABLE `kolor`
(
	`kolor_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`en` VARCHAR(45),
	`pl` VARCHAR(45),
	PRIMARY KEY (`kolor_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- zwierze
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `zwierze`;


CREATE TABLE `zwierze`
(
	`zwierze_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`en` VARCHAR(45),
	`pl` VARCHAR(45),
	PRIMARY KEY (`zwierze_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 08:09
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `slownik`
--

--
-- Zrzut danych tabeli `kolor`
--

INSERT INTO `kolor` (`kolor_id`, `en`, `pl`) VALUES(1, 'blue', 'niebieski');
INSERT INTO `kolor` (`kolor_id`, `en`, `pl`) VALUES(2, 'yellow', 'żółty');
INSERT INTO `kolor` (`kolor_id`, `en`, `pl`) VALUES(3, 'red', 'czerwony');

--
-- Zrzut danych tabeli `zwierze`
--

INSERT INTO `zwierze` (`zwierze_id`, `en`, `pl`) VALUES(1, 'seal', 'foka');
INSERT INTO `zwierze` (`zwierze_id`, `en`, `pl`) VALUES(2, 'horse', 'koń');

SET FOREIGN_KEY_CHECKS=1;
