<?php

require 'autokomis/om/BaseAutoPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'auto' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    autokomis
 */
class AutoPeer extends BaseAutoPeer {

    public static function insert($dane)
    {
        $tmp = new Auto();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }
    
    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        
        $criteria->addJoin(AutoPeer::MODEL_ID, ModelPeer::MODEL_ID);
        $criteria->addJoin(ModelPeer::MARKA_ID, MarkaPeer::MARKA_ID);
        
        $criteria->addAscendingOrderByColumn(MarkaPeer::NAZWA);
        $criteria->addAscendingOrderByColumn(ModelPeer::NAZWA);
        $criteria->addAscendingOrderByColumn(AutoPeer::ROCZNIK);
        return parent::doSelect($criteria, $con);
    }

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }



} // AutoPeer
