<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'panstwa_miasta/Kontynent.php';

require_once 'slugs.inc.php';

Propel::init('panstwa_miasta-conf.php');

$plk = file('panstwa-miasta.txt');
shuffle($plk);
foreach ($plk as $l) {
    $miasta = explode(',', trim($l));
    $miasta = array_map('trim', $miasta);
    
    $str_kontynent = $miasta[0];
    $str_panstwo = $miasta[1];

    array_shift($miasta);
    array_shift($miasta);
    shuffle($miasta);
    
    $c = new Criteria();
    $c->add(KontynentPeer::NAZWA, $str_kontynent);
    $kontynent = KontynentPeer::doSelectOne($c);
    if (!$kontynent) {
        $kontynent = new Kontynent();
        $kontynent->setNazwa($str_kontynent);
        $kontynent->setSlug(string2slug($str_kontynent));
        $kontynent->save();
    }

    $c = new Criteria();
    $c->add(PanstwoPeer::NAZWA, $str_panstwo);
    $panstwo = PanstwoPeer::doSelectOne($c);
    if (!$panstwo) {
        $panstwo = new Panstwo();
        $panstwo->setNazwa($str_panstwo);
        $panstwo->setSlug(string2slug($str_panstwo));
        $panstwo->setKontynent($kontynent);
        $panstwo->save();
    }

    foreach ($miasta as $str_miasto) {
        $c = new Criteria();
        $c->add(MiastoPeer::NAZWA, $str_miasto);
        $miasto = MiastoPeer::doSelectOne($c);
        if (!$miasto) {
            $miasto = new Miasto();
            $miasto->setNazwa($str_miasto);
            $miasto->setSlug(string2slug($str_miasto));
            $miasto->setPanstwo($panstwo);
            $miasto->save();
        }
    }
}