set names utf8;
drop database if exists panstwa_miasta;
create database panstwa_miasta default character set utf8 collate utf8_polish_ci;
grant all on panstwa_miasta.* to admin@localhost identified by 'password';
flush privileges;
use panstwa_miasta;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- panstwo
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `panstwo`;


CREATE TABLE `panstwo`
(
	`panstwo_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	`kontynent_id` INTEGER,
	PRIMARY KEY (`panstwo_id`),
	INDEX `FI_panstwo_kontynent` (`kontynent_id`),
	CONSTRAINT `fk_panstwo_kontynent`
		FOREIGN KEY (`kontynent_id`)
		REFERENCES `kontynent` (`kontynent_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- miasto
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `miasto`;


CREATE TABLE `miasto`
(
	`miasto_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	`panstwo_id` INTEGER,
	PRIMARY KEY (`miasto_id`),
	INDEX `FI_miasto_panstwo` (`panstwo_id`),
	CONSTRAINT `fk_miasto_panstwo`
		FOREIGN KEY (`panstwo_id`)
		REFERENCES `panstwo` (`panstwo_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- kontynent
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kontynent`;


CREATE TABLE `kontynent`
(
	`kontynent_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	PRIMARY KEY (`kontynent_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 08:32
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `panstwa_miasta`
--

--
-- Zrzut danych tabeli `kontynent`
--

INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(1, 'Europa', 'europa');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(2, 'Azja', 'azja');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(3, 'Afryka', 'afryka');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(4, 'Ameryka Południowa', 'ameryka_poludniowa');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(5, 'Ameryka Północna', 'ameryka_polnocna');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(6, 'Australia', 'australia');

--
-- Zrzut danych tabeli `miasto`
--

INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(1, 'Luksemburg', 'luksemburg', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(2, 'Kyrdżali', 'kyrdzali', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(3, 'Łom', 'lom', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(4, 'Burgas', 'burgas', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(5, 'Ruse', 'ruse', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(6, 'Sofia', 'sofia', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(7, 'Płowdiw', 'plowdiw', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(8, 'Montana', 'montana', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(9, 'Blagoewgrad', 'blagoewgrad', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(10, 'Dimitrowgrad', 'dimitrowgrad', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(11, 'Chaskowo', 'chaskowo', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(12, 'Wraca', 'wraca', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(13, 'Szumen', 'szumen', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(14, 'Wielkie Tyrnowo', 'wielkie_tyrnowo', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(15, 'Łowecz', 'lowecz', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(16, 'Pernik', 'pernik', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(17, 'Dobricz', 'dobricz', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(18, 'Widin', 'widin', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(19, 'Razgrad', 'razgrad', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(20, 'Stara Zagora', 'stara_zagora', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(21, 'Plewen', 'plewen', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(22, 'Kojamputtur', 'kojamputtur', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(23, 'Bombaj', 'bombaj', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(24, 'Kalkuta', 'kalkuta', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(25, 'Lakhnau', 'lakhnau', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(26, 'Faisalabad', 'faisalabad', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(27, 'Maduraj', 'maduraj', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(28, 'Patna', 'patna', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(29, 'New Delhi', 'new_delhi', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(30, 'Labaur', 'labaur', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(31, 'Delhi', 'delhi', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(32, 'Rawalpindi', 'rawalpindi', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(33, 'Mosfellsbaer', 'mosfellsbaer', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(34, 'Borgarfjorour', 'borgarfjorour', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(35, 'Egilsstadhir', 'egilsstadhir', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(36, 'Vogar', 'vogar', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(37, 'Selfoss', 'selfoss', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(38, 'Reykjavik', 'reykjavik', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(39, 'Husavik', 'husavik', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(40, 'Hella', 'hella', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(41, 'Vik', 'vik', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(42, 'Hvammstangi', 'hvammstangi', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(43, 'Neskaupstadhur', 'neskaupstadhur', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(44, 'Djupivogur', 'djupivogur', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(45, 'Dalvik', 'dalvik', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(46, 'Keflavik', 'keflavik', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(47, 'Grindavik', 'grindavik', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(48, 'Akureyri', 'akureyri', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(49, 'Blonduos', 'blonduos', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(50, 'Hafnarfordhur', 'hafnarfordhur', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(51, 'Porklakshofn', 'porklakshofn', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(52, 'Kinberley', 'kinberley', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(53, 'Johannesburg. Bloemfontein', 'johannesburg_bloemfontein', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(54, 'Port Elizabeth', 'port_elizabeth', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(55, 'Pretoria', 'pretoria', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(56, 'Richards', 'richards', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(57, 'East London', 'east_london', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(58, 'Bay', 'bay', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(59, 'Durban', 'durban', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(60, 'Newcastle', 'newcastle', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(61, 'Kapsztad', 'kapsztad', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(62, 'El Limon', 'el_limon', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(63, 'Cumana', 'cumana', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(64, 'Merida', 'merida', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(65, 'Caracas', 'caracas', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(66, 'Barinas', 'barinas', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(67, 'Valencia', 'valencia', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(68, 'Maracaibo', 'maracaibo', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(69, 'Ciudad Bolivar', 'ciudad_bolivar', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(70, 'San Cristobal', 'san_cristobal', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(71, 'Barcelona', 'barcelona', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(72, 'Maturin', 'maturin', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(73, 'Narwik', 'narwik', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(74, 'Steinkjer', 'steinkjer', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(75, 'Drammen', 'drammen', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(76, 'Bergen', 'bergen', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(77, 'Mo i Tana', 'mo_i_tana', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(78, 'Namosos', 'namosos', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(79, 'Sarbsborg', 'sarbsborg', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(80, 'Stavanger', 'stavanger', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(81, 'Notodden', 'notodden', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(82, 'Bodo', 'bodo', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(83, 'Alesund', 'alesund', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(84, 'Oslo', 'oslo', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(85, 'Trondheim', 'trondheim', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(86, 'Kristiansund', 'kristiansund', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(87, 'Gjovik', 'gjovik', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(88, 'Kamar', 'kamar', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(89, 'Alta', 'alta', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(90, 'Haugesund', 'haugesund', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(91, 'Ciudad Juarez', 'ciudad_juarez', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(92, 'Tampico', 'tampico', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(93, 'Meksyk', 'meksyk', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(94, 'Mexicali', 'mexicali', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(95, 'Guadalajara', 'guadalajara', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(96, 'Torreon', 'torreon', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(97, 'Chihuahua', 'chihuahua', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(98, 'Monterrey', 'monterrey', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(99, 'San Luis Potosi', 'san_luis_potosi', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(100, 'Peubla', 'peubla', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(101, 'Tijuana', 'tijuana', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(102, 'Sarajewo', 'sarajewo', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(103, 'Brhac', 'brhac', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(104, 'Konjic', 'konjic', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(105, 'Zenica', 'zenica', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(106, 'Tuluza', 'tuluza', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(107, 'Vareś', 'vares', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(108, 'Mostar', 'mostar', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(109, 'Banja luka', 'banja_luka', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(110, 'Bosanski Brod', 'bosanski_brod', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(111, 'Tallinn', 'tallinn', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(112, 'Audruo', 'audruo', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(113, 'Pamu', 'pamu', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(114, 'Vijandi', 'vijandi', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(115, 'Kohtla-Jarve', 'kohtla_jarve', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(116, 'Parnwa', 'parnwa', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(117, 'Vasalemma', 'vasalemma', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(118, 'Taebla', 'taebla', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(119, 'Kivioli', 'kivioli', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(120, 'Keila', 'keila', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(121, 'Narva', 'narva', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(122, 'Sindii', 'sindii', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(123, 'Halinga', 'halinga', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(124, 'Sindi', 'sindi', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(125, 'Vinni', 'vinni', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(126, 'Kunda', 'kunda', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(127, 'Kehtna', 'kehtna', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(128, 'Marjamaa', 'marjamaa', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(129, 'Tidala', 'tidala', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(130, 'Tartu', 'tartu', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(131, 'Nultal', 'nultal', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(132, 'Quetta', 'quetta', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(133, 'Multan', 'multan', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(134, 'Skkur', 'skkur', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(135, 'Karachi', 'karachi', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(136, 'Hoshab', 'hoshab', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(137, 'Hyderabad', 'hyderabad', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(138, 'Islambad', 'islambad', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(139, 'Okara', 'okara', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(140, 'Lahore', 'lahore', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(141, 'Jhang', 'jhang', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(142, 'Panigur', 'panigur', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(143, 'Sao Paulo', 'sao_paulo', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(144, 'Porto Alegre', 'porto_alegre', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(145, 'Belem', 'belem', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(146, 'Rio de Janeiro', 'rio_de_janeiro', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(147, 'Goiania', 'goiania', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(148, 'Kurytyba', 'kurytyba', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(149, 'Manaus', 'manaus', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(150, 'Brasilia', 'brasilia', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(151, 'Salvador', 'salvador', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(152, 'Belo Horizonte', 'belo_horizonte', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(153, 'Rio Branco', 'rio_branco', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(154, 'Fortalaza', 'fortalaza', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(155, 'Charikar', 'charikar', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(156, 'Kandahar', 'kandahar', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(157, 'Farah', 'farah', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(158, 'Meymaneh', 'meymaneh', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(159, 'Herat', 'herat', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(160, 'Mazare Sharif', 'mazare_sharif', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(161, 'Lashkar Gah', 'lashkar_gah', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(162, 'Qonduz', 'qonduz', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(163, 'Sheberghan', 'sheberghan', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(164, 'Baghian', 'baghian', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(165, 'Kabul', 'kabul', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(166, 'Ffestiniog', 'ffestiniog', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(167, 'Holyhead', 'holyhead', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(168, 'Valley', 'valley', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(169, 'Nefyn', 'nefyn', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(170, 'Porthmadog', 'porthmadog', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(171, 'Neath', 'neath', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(172, 'Welshpool', 'welshpool', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(173, 'Morriston', 'morriston', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(174, 'Barmouth', 'barmouth', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(175, 'Caernarfon', 'caernarfon', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(176, 'Barry', 'barry', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(177, 'Newport', 'newport', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(178, 'Buckley', 'buckley', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(179, 'Llandwrog', 'llandwrog', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(180, 'Swansea', 'swansea', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(181, 'Cardiff', 'cardiff', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(182, 'Wrexham', 'wrexham', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(183, 'Knighton', 'knighton', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(184, 'Buenos Aires', 'buenos_aires', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(185, 'Parana', 'parana', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(186, 'Santa Fe', 'santa_fe', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(187, 'Mendoza', 'mendoza', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(188, 'San Carlos de Bariloche', 'san_carlos_de_bariloche', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(189, 'Formosa', 'formosa', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(190, 'Cordoba', 'cordoba', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(191, 'Resistencja', 'resistencja', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(192, 'Deseado', 'deseado', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(193, 'Salta', 'salta', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(194, 'Las Heras', 'las_heras', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(195, 'Tosario', 'tosario', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(196, 'Rezina', 'rezina', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(197, 'Nisporeni', 'nisporeni', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(198, 'Orhei', 'orhei', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(199, 'Kagul', 'kagul', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(200, 'Tarakliya', 'tarakliya', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(201, 'Ialoveni', 'ialoveni', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(202, 'Kiszyniów', 'kiszyniow', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(203, 'Cantemir', 'cantemir', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(204, 'Ryshkany', 'ryshkany', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(205, 'Bessarabka', 'bessarabka', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(206, 'Criuleni', 'criuleni', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(207, 'Chisianau', 'chisianau', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(208, 'Leova', 'leova', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(209, 'Ocnita', 'ocnita', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(210, 'Komrat', 'komrat', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(211, 'Soroca', 'soroca', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(212, 'Drochia', 'drochia', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(213, 'Anenii Noi', 'anenii_noi', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(214, 'Al-Ubajid', 'al_ubajid', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(215, 'Al-Faszir', 'al_faszir', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(216, 'Chartum', 'chartum', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(217, 'Port Sudan', 'port_sudan', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(218, 'Wadi Halfa', 'wadi_halfa', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(219, 'Nyala', 'nyala', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(220, 'Dżuba', 'dzuba', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(221, 'Omdurman', 'omdurman', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(222, 'Wau', 'wau', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(223, 'Whitehorse', 'whitehorse', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(224, 'Quebec', 'quebec', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(225, 'Yellownife', 'yellownife', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(226, 'Halifax', 'halifax', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(227, 'Edmonton', 'edmonton', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(228, 'Tredericton', 'tredericton', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(229, 'Montreal', 'montreal', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(230, 'St. Jon''s', 'st_jon_s', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(231, 'Toronto', 'toronto', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(232, 'Ottawa', 'ottawa', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(233, 'Vancouver', 'vancouver', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(234, 'Calgary', 'calgary', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(235, 'Andora', 'andora', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(236, 'Karlstad', 'karlstad', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(237, 'Linkoping', 'linkoping', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(238, 'Goteborg', 'goteborg', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(239, 'Gavle', 'gavle', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(240, 'Sztokholm', 'sztokholm', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(241, 'Falum', 'falum', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(242, 'Boden', 'boden', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(243, 'Kalmar', 'kalmar', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(244, 'Lund', 'lund', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(245, 'Trollhattan', 'trollhattan', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(246, 'Trelleborg', 'trelleborg', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(247, 'Oxelosund', 'oxelosund', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(248, 'Harnosand', 'harnosand', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(249, 'Malmo', 'malmo', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(250, 'Norrkoping', 'norrkoping', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(251, 'Eskilstuna', 'eskilstuna', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(252, 'Boras', 'boras', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(253, 'Uppsala', 'uppsala', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(254, 'Orebro', 'orebro', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(255, 'Vasteras', 'vasteras', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(256, 'Oran', 'oran', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(257, 'Ain Temouchent', 'ain_temouchent', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(258, 'Algier', 'algier', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(259, 'Annaba', 'annaba', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(260, 'Touggourt', 'touggourt', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(261, 'Medea', 'medea', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(262, 'Sidi Bei Abbes', 'sidi_bei_abbes', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(263, 'Selic', 'selic', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(264, 'Batna', 'batna', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(265, 'Golea', 'golea', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(266, 'Lwów', 'lwow', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(267, 'Mikołajów', 'mikolajow', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(268, 'Odessa', 'odessa', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(269, 'Za', 'za', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(270, 'Kijów', 'kijow', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(271, 'Bar', 'bar', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(272, 'Podgorica', 'podgorica', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(273, 'Niksic', 'niksic', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(274, 'Nevers', 'nevers', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(275, 'Vichy', 'vichy', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(276, 'Marsylia', 'marsylia', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(277, 'Paryż', 'paryz', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(278, 'Agen', 'agen', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(279, 'Nantes', 'nantes', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(280, 'Lyon', 'lyon', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(281, 'Montauban', 'montauban', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(282, 'Strasburg', 'strasburg', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(283, 'St-Brieuc', 'st_brieuc', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(284, 'Le Creusot', 'le_creusot', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(285, 'La Rochelle', 'la_rochelle', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(286, 'Poitiers', 'poitiers', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(287, 'Rochefort', 'rochefort', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(288, 'chalons sur-Marne', 'chalons_sur_marne', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(289, 'Le Mans', 'le_mans', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(290, 'Hawr', 'hawr', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(291, 'Bordeaux', 'bordeaux', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(292, 'Vierzon', 'vierzon', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(293, 'Cozoco', 'cozoco', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(294, 'Grocio', 'grocio', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(295, 'Moquequa', 'moquequa', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(296, 'Huacho', 'huacho', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(297, 'Lima', 'lima', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(298, 'Ciclayo', 'ciclayo', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(299, 'Trujillo', 'trujillo', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(300, 'Juliaca', 'juliaca', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(301, 'Plura', 'plura', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(302, 'Tumbes', 'tumbes', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(303, 'Jaen', 'jaen', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(304, 'Talara', 'talara', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(305, 'Kochani', 'kochani', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(306, 'Strumitsa', 'strumitsa', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(307, 'Zhelino', 'zhelino', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(308, 'Probishtip', 'probishtip', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(309, 'Gostivar', 'gostivar', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(310, 'Skopje', 'skopje', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(311, 'Debar', 'debar', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(312, 'Vinitsa', 'vinitsa', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(313, 'Sveti Nikole', 'sveti_nikole', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(314, 'Kumanovo', 'kumanovo', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(315, 'Shtip', 'shtip', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(316, 'Studenichani', 'studenichani', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(317, 'Berovo', 'berovo', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(318, 'Resen', 'resen', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(319, 'Demir', 'demir', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(320, 'Delchevo', 'delchevo', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(321, 'Tetovo', 'tetovo', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(322, 'Gevgelija', 'gevgelija', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(323, 'Mogila', 'mogila', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(324, 'Bitola', 'bitola', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(325, 'Atlanta', 'atlanta', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(326, 'Miami', 'miami', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(327, 'Columbus', 'columbus', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(328, 'Los Angeles', 'los_angeles', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(329, 'Baltimore', 'baltimore', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(330, 'Nowy Jork', 'nowy_jork', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(331, 'Tampa', 'tampa', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(332, 'Cleveland', 'cleveland', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(333, 'Boston', 'boston', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(334, 'San Francisco', 'san_francisco', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(335, 'Waszyngton', 'waszyngton', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(336, 'Chicago', 'chicago', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(337, 'Elgin', 'elgin', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(338, 'Greenock', 'greenock', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(339, 'Dundee', 'dundee', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(340, 'Glasgow', 'glasgow', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(341, 'Edinburgh', 'edinburgh', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(342, 'Nairn', 'nairn', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(343, 'Stirling', 'stirling', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(344, 'Peterhead', 'peterhead', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(345, 'Ullapool', 'ullapool', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(346, 'Forfar', 'forfar', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(347, 'Stonehaven', 'stonehaven', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(348, 'Falkirk', 'falkirk', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(349, 'Alness', 'alness', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(350, 'Inverness', 'inverness', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(351, 'Livingston', 'livingston', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(352, 'Kilmarnock', 'kilmarnock', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(353, 'Paisley', 'paisley', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(354, 'Arboroath', 'arboroath', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(355, 'Tain', 'tain', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(356, 'Hamilton', 'hamilton', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(357, 'Leoben', 'leoben', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(358, 'Klagenfurt', 'klagenfurt', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(359, 'Wiener Neustadt', 'wiener_neustadt', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(360, 'Landeck', 'landeck', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(361, 'Villach', 'villach', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(362, 'Wiedeń', 'wieden', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(363, 'Judenburg', 'judenburg', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(364, 'Krems', 'krems', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(365, 'Schwechat', 'schwechat', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(366, 'Innsbruck', 'innsbruck', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(367, 'Bischofshofen', 'bischofshofen', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(368, 'Eisenerz', 'eisenerz', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(369, 'Salzburg', 'salzburg', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(370, 'Graz', 'graz', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(371, 'Steyr', 'steyr', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(372, 'Kitzbuhel', 'kitzbuhel', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(373, 'Wels', 'wels', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(374, 'St. Polten', 'st_polten', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(375, 'Gmund', 'gmund', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(376, 'Linz', 'linz', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(377, 'Szolnok', 'szolnok', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(378, 'Tokaj', 'tokaj', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(379, 'Eger', 'eger', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(380, 'Zalaegerszeg', 'zalaegerszeg', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(381, 'Nagykanizsa', 'nagykanizsa', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(382, 'Budapeszt', 'budapeszt', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(383, 'Szombathely', 'szombathely', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(384, 'Dunaujvaros', 'dunaujvaros', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(385, 'Szazhalombatta', 'szazhalombatta', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(386, 'Salgotarjan', 'salgotarjan', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(387, 'Cegled', 'cegled', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(388, 'Baja', 'baja', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(389, 'Debreczyn', 'debreczyn', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(390, 'Miszkolc', 'miszkolc', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(391, 'Pecz', 'pecz', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(392, 'Hodmezovasarnely', 'hodmezovasarnely', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(393, 'Veszprem', 'veszprem', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(394, 'Segedyn', 'segedyn', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(395, 'Nyiregyhaza', 'nyiregyhaza', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(396, 'Tatabanya', 'tatabanya', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(397, 'Buenacentura', 'buenacentura', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(398, 'Medellin', 'medellin', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(399, 'Popayan', 'popayan', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(400, 'Cali', 'cali', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(401, 'Bogota', 'bogota', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(402, 'Pereira', 'pereira', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(403, 'Armenia', 'armenia', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(404, 'Neiva', 'neiva', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(405, 'Villavinencio', 'villavinencio', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(406, 'Macizales', 'macizales', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(407, 'Tulua', 'tulua', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(408, 'Pasto', 'pasto', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(409, 'Arad', 'arad', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(410, 'Tesita', 'tesita', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(411, 'Suceava', 'suceava', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(412, 'Brasov', 'brasov', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(413, 'Baia Mare', 'baia_mare', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(414, 'Ploiesti', 'ploiesti', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(415, 'Iasi', 'iasi', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(416, 'Focsani', 'focsani', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(417, 'Craiova', 'craiova', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(418, 'Constanta', 'constanta', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(419, 'Oradea', 'oradea', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(420, 'Galati', 'galati', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(421, 'Sibiu', 'sibiu', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(422, 'Botosani', 'botosani', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(423, 'Bukareszt', 'bukareszt', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(424, 'Braila', 'braila', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(425, 'Timisoara', 'timisoara', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(426, 'Turnu-severin', 'turnu_severin', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(427, 'Alice Springs', 'alice_springs', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(428, 'Mount Isa', 'mount_isa', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(429, 'Birdm', 'birdm', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(430, 'Adelaide', 'adelaide', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(431, 'Hobart', 'hobart', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(432, 'Sydney', 'sydney', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(433, 'Canberra', 'canberra', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(434, 'Perth', 'perth', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(435, 'Brisbane', 'brisbane', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(436, 'Kalgoorlie', 'kalgoorlie', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(437, 'Darwin', 'darwin', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(438, 'Melbourne', 'melbourne', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(439, 'Aalborg', 'aalborg', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(440, 'Varde', 'varde', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(441, 'Haderslev', 'haderslev', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(442, 'Sonderborg', 'sonderborg', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(443, 'Kopenhaga', 'kopenhaga', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(444, 'Herming', 'herming', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(445, 'Nibe', 'nibe', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(446, 'Vodskov', 'vodskov', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(447, 'Logstor', 'logstor', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(448, 'Holstebro', 'holstebro', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(449, 'Viborg', 'viborg', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(450, 'Svendborg', 'svendborg', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(451, 'Slagelse', 'slagelse', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(452, 'Koge', 'koge', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(453, 'Skive', 'skive', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(454, 'Odense', 'odense', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(455, 'Fredericia', 'fredericia', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(456, 'Esbjerg', 'esbjerg', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(457, 'Kolding', 'kolding', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(458, 'Vejen', 'vejen', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(459, 'Atyrau', 'atyrau', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(460, 'Almaty', 'almaty', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(461, 'Ust-kamenogorsk', 'ust_kamenogorsk', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(462, 'Ekibastuz', 'ekibastuz', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(463, 'Uralsk', 'uralsk', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(464, 'Rudnyy', 'rudnyy', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(465, 'Astana', 'astana', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(466, 'Semipalatinsk', 'semipalatinsk', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(467, 'Pavlodar', 'pavlodar', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(468, 'Balkhash', 'balkhash', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(469, 'Karaganda', 'karaganda', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(470, 'Kustanay', 'kustanay', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(471, 'Żar', 'zar', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(472, 'Łuczeniec', 'luczeniec', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(473, 'Bratysława', 'bratyslawa', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(474, 'Pieszczyny', 'pieszczyny', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(475, 'Nitra', 'nitra', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(476, 'Trnava', 'trnava', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(477, 'Żylina', 'zylina', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(478, 'Bańska Bystrzyca', 'banska_bystrzyca', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(479, 'Komarno', 'komarno', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(480, 'Preszów', 'preszow', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(481, 'Roznava', 'roznava', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(482, 'Koszyce', 'koszyce', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(483, 'Spiska', 'spiska', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(484, 'Humenne', 'humenne', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(485, 'Al Farsh', 'al_farsh', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(486, 'Ar-Rijad', 'ar_rijad', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(487, 'Gabouk', 'gabouk', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(488, 'Brydah', 'brydah', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(489, 'Jizan', 'jizan', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(490, 'Ank', 'ank', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(491, 'Ar Riyad', 'ar_riyad', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(492, 'Jeddah', 'jeddah', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(493, 'Kuba', 'kuba', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(494, 'Khamis Mushayt', 'khamis_mushayt', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(495, 'Leeuwarden', 'leeuwarden', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(496, 'Amsterdam', 'amsterdam', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(497, 'Maastricht', 'maastricht', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(498, 'Haga', 'haga', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(499, 'Zwolle', 'zwolle', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(500, 'Breda', 'breda', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(501, 'Haarlem', 'haarlem', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(502, 'Vlissingen', 'vlissingen', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(503, 'Den Helder', 'den_helder', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(504, 'Eindhoven', 'eindhoven', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(505, 'Arnhem', 'arnhem', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(506, 'Tilburg', 'tilburg', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(507, 'Enschede', 'enschede', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(508, 'Nimegen', 'nimegen', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(509, 'San Marino', 'san_marino', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(510, 'Rzeszów', 'rzeszow', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(511, 'Gdańsk', 'gdansk', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(512, 'Zakopane', 'zakopane', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(513, 'Radom', 'radom', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(514, 'Wrocław', 'wroclaw', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(515, 'Kraków', 'krakow', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(516, 'Opole', 'opole', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(517, 'Lublin', 'lublin', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(518, 'Warszawa', 'warszawa', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(519, 'Łódź', 'lodz', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(520, 'Katowice', 'katowice', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(521, 'Szczecin', 'szczecin', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(522, 'Elbląg', 'elblag', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(523, 'Chorzów', 'chorzow', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(524, 'Zamość', 'zamosc', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(525, 'Tarnobrzeg', 'tarnobrzeg', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(526, 'Gdynia', 'gdynia', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(527, 'Olsztyn', 'olsztyn', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(528, 'Poznań', 'poznan', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(529, 'Hamburg', 'hamburg', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(530, 'Salzwedel', 'salzwedel', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(531, 'Dortmund', 'dortmund', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(532, 'Celle', 'celle', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(533, 'Bonn', 'bonn', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(534, 'Stuttgart', 'stuttgart', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(535, 'Pluda', 'pluda', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(536, 'Paderborn', 'paderborn', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(537, 'Kolonia', 'kolonia', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(538, 'Uelzen', 'uelzen', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(539, 'Berlin', 'berlin', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(540, 'Kempten', 'kempten', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(541, 'Frankfurt', 'frankfurt', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(542, 'Monachium', 'monachium', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(543, 'Hanower', 'hanower', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(544, 'Wittenberga', 'wittenberga', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(545, 'Ingolstadt', 'ingolstadt', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(546, 'Eisenach', 'eisenach', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(547, 'Amberg', 'amberg', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(548, 'Brema', 'brema', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(549, 'Mykeny', 'mykeny', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(550, 'Pireus', 'pireus', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(551, 'Agrinion', 'agrinion', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(552, 'Teby', 'teby', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(553, 'Edesa', 'edesa', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(554, 'Larisa', 'larisa', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(555, 'Arta', 'arta', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(556, 'Janina', 'janina', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(557, 'Kastoria', 'kastoria', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(558, 'Patras', 'patras', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(559, 'Komotini', 'komotini', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(560, 'Saloniki', 'saloniki', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(561, 'Korynt', 'korynt', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(562, 'Kalamata', 'kalamata', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(563, 'Drama', 'drama', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(564, 'Kawala', 'kawala', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(565, 'Ksanthi', 'ksanthi', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(566, 'Ateny', 'ateny', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(567, 'Aolos', 'aolos', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(568, 'Thalkis', 'thalkis', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(569, 'Namibe', 'namibe', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(570, 'Benguela', 'benguela', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(571, 'Huambo', 'huambo', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(572, 'Luanda', 'luanda', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(573, 'Lobito', 'lobito', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(574, 'Lubango', 'lubango', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(575, 'Malange', 'malange', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(576, 'Chur', 'chur', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(577, 'Fryburg', 'fryburg', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(578, 'Biel', 'biel', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(579, 'Neuchatel', 'neuchatel', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(580, 'Brig', 'brig', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(581, 'Davos', 'davos', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(582, 'Berno', 'berno', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(583, 'Bazylea', 'bazylea', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(584, 'Lozanna', 'lozanna', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(585, 'Szafuza', 'szafuza', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(586, 'Thun', 'thun', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(587, 'Genewa', 'genewa', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(588, 'Winterthur', 'winterthur', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(589, 'Zurych', 'zurych', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(590, 'Interlaken', 'interlaken', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(591, 'St. Mortiz', 'st_mortiz', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(592, 'Montreux', 'montreux', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(593, 'Lugano', 'lugano', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(594, 'St. Gallen', 'st_gallen', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(595, 'Locarno', 'locarno', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(596, 'Tullamore', 'tullamore', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(597, 'Swords', 'swords', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(598, 'Waterford', 'waterford', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(599, 'Kikenny', 'kikenny', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(600, 'Claremorris', 'claremorris', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(601, 'Limerick', 'limerick', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(602, 'Wicklow', 'wicklow', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(603, 'Dublin', 'dublin', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(604, 'Mullingar', 'mullingar', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(605, 'Tuam', 'tuam', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(606, 'Arklow', 'arklow', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(607, 'Galway', 'galway', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(608, 'Drogheda', 'drogheda', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(609, 'Wexford', 'wexford', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(610, 'Clonmel', 'clonmel', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(611, 'Cork', 'cork', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(612, 'New Ross', 'new_ross', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(613, 'Castlebar', 'castlebar', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(614, 'Ballinrobe', 'ballinrobe', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(615, 'Atholne', 'atholne', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(616, 'Lahti', 'lahti', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(617, 'Espoo', 'espoo', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(618, 'Vaasa', 'vaasa', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(619, 'Wyborg', 'wyborg', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(620, 'Kuopio', 'kuopio', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(621, 'Tampere', 'tampere', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(622, 'Pori', 'pori', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(623, 'Turku', 'turku', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(624, 'Kotka', 'kotka', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(625, 'Oulu', 'oulu', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(626, 'Helsinki', 'helsinki', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(627, 'Kemi', 'kemi', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(628, 'Ryga', 'ryga', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(629, 'Valmiera', 'valmiera', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(630, 'Jełgawa', 'jelgawa', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(631, 'Dyneburg', 'dyneburg', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(632, 'Lipawa', 'lipawa', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(633, 'Olaine', 'olaine', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(634, 'Windawa', 'windawa', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(635, 'Rzeżyca', 'rzezyca', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(636, 'Maktuguri', 'maktuguri', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(637, 'Ollorin', 'ollorin', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(638, 'Benin City', 'benin_city', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(639, 'Kano', 'kano', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(640, 'Ibadan', 'ibadan', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(641, 'Zaria', 'zaria', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(642, 'Abudża', 'abudza', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(643, 'Lagos', 'lagos', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(644, 'Port Harcourt', 'port_harcourt', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(645, 'Kduna', 'kduna', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(646, 'Calabar', 'calabar', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(647, 'Setubal', 'setubal', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(648, 'Beja', 'beja', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(649, 'Sines', 'sines', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(650, 'Lizbona', 'lizbona', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(651, 'Faro', 'faro', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(652, 'Braganca', 'braganca', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(653, 'Castelo Branco', 'castelo_branco', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(654, 'Evora', 'evora', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(655, 'Coimbra', 'coimbra', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(656, 'Barreiro', 'barreiro', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(657, 'Braga', 'braga', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(658, 'Vila Real', 'vila_real', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(659, 'Covilha', 'covilha', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(660, 'Viseu', 'viseu', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(661, 'Porto', 'porto', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(662, 'Alexandia', 'alexandia', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(663, 'Luxor', 'luxor', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(664, 'Kharga Oasis', 'kharga_oasis', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(665, 'Aswan', 'aswan', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(666, 'Kair', 'kair', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(667, 'Asyut', 'asyut', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(668, 'Kindu', 'kindu', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(669, 'Keleme', 'keleme', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(670, 'Kananga', 'kananga', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(671, 'Kisangani', 'kisangani', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(672, 'Kinszasa', 'kinszasa', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(673, 'Lubumbashi', 'lubumbashi', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(674, 'Mbandaka', 'mbandaka', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(675, 'Mbuji-Mayi', 'mbuji_mayi', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(676, 'Znojmo', 'znojmo', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(677, 'Kladno', 'kladno', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(678, 'Karlowe Wary', 'karlowe_wary', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(679, 'Czeskie', 'czeskie', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(680, 'Brno', 'brno', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(681, 'Liberec', 'liberec', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(682, 'Pilzno', 'pilzno', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(683, 'Pardubice', 'pardubice', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(684, 'Ołomurie', 'olomurie', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(685, 'Cheb', 'cheb', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(686, 'Uście', 'uscie', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(687, 'Teplica', 'teplica', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(688, 'Igława', 'iglawa', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(689, 'Mlada Boleslav', 'mlada_boleslav', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(690, 'Jablonec', 'jablonec', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(691, 'Most', 'most', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(692, 'Praga', 'praga', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(693, 'Hradec Kralove', 'hradec_kralove', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(694, 'Tabor', 'tabor', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(695, 'Brugia', 'brugia', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(696, 'Bruksela', 'bruksela', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(697, 'Antwerpia', 'antwerpia', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(698, 'Arlon', 'arlon', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(699, 'Ostenda', 'ostenda', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(700, 'Charleroi', 'charleroi', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(701, 'Namur', 'namur', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(702, 'Liege', 'liege', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(703, 'Gandawa', 'gandawa', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(704, 'Madryt', 'madryt', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(705, 'Bilbao', 'bilbao', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(706, 'Murcja', 'murcja', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(707, 'Tortosa', 'tortosa', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(708, 'Cuenca', 'cuenca', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(709, 'Orihuela', 'orihuela', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(710, 'Burgos', 'burgos', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(711, 'Sewilla', 'sewilla', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(712, 'La Linea', 'la_linea', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(713, 'Soria', 'soria', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(714, 'Palencia', 'palencia', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(715, 'Malaga', 'malaga', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(716, 'Saragossa', 'saragossa', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(717, 'Ecija', 'ecija', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(718, 'Algeciras', 'algeciras', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(719, 'Walencja', 'walencja', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(720, 'Santander', 'santander', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(721, 'Albacete', 'albacete', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(722, 'Chelmsford', 'chelmsford', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(723, 'Norwich', 'norwich', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(724, 'Bristol', 'bristol', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(725, 'Brimingham', 'brimingham', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(726, 'Plymuth', 'plymuth', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(727, 'Leeds', 'leeds', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(728, 'Hull', 'hull', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(729, 'Darlington', 'darlington', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(730, 'Manchester', 'manchester', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(731, 'Luton', 'luton', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(732, 'Swindon', 'swindon', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(733, 'Gloucester', 'gloucester', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(734, 'Middlesbrouch', 'middlesbrouch', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(735, 'Grimsby', 'grimsby', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(736, 'Liverpool', 'liverpool', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(737, 'Stoke-on-Trent', 'stoke_on_trent', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(738, 'Londyn', 'londyn', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(739, 'Sunderland', 'sunderland', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(740, 'Telford', 'telford', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(741, 'Szkodra', 'szkodra', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(742, 'Durres', 'durres', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(743, 'Berat', 'berat', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(744, 'Korcza', 'korcza', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(745, 'Gjirokastra', 'gjirokastra', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(746, 'Fieri', 'fieri', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(747, 'Elbasan', 'elbasan', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(748, 'Vlore', 'vlore', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(749, 'Tirana', 'tirana', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(750, 'Lubana', 'lubana', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(751, 'Kranj', 'kranj', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(752, 'Titoco', 'titoco', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(753, 'Celije', 'celije', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(754, 'Postojna', 'postojna', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(755, 'Gorycja', 'gorycja', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(756, 'Maribor', 'maribor', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(757, 'Pekin', 'pekin', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(758, 'Wenzhou', 'wenzhou', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(759, 'Harbin', 'harbin', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(760, 'Wuhan', 'wuhan', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(761, 'Jilin', 'jilin', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(762, 'Chandsha', 'chandsha', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(763, 'Jinan', 'jinan', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(764, 'Tianjin', 'tianjin', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(765, 'Zhengzhou', 'zhengzhou', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(766, 'Shenyang', 'shenyang', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(767, 'Huainan', 'huainan', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(768, 'Kanton', 'kanton', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(769, 'Kazań', 'kazan', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(770, 'Jarosław', 'jaroslaw', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(771, 'Orenburg', 'orenburg', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(772, 'Perersburg', 'perersburg', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(773, 'Perm', 'perm', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(774, 'Ufa', 'ufa', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(775, 'Penza', 'penza', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(776, 'Samara', 'samara', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(777, 'Lżewsk', 'lzewsk', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(778, 'Krasnodar', 'krasnodar', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(779, 'Saratów', 'saratow', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(780, 'Woroneż', 'woronez', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(781, 'Jekaterynburg', 'jekaterynburg', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(782, 'Moskwa', 'moskwa', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(783, 'Czelabińssk', 'czelabinssk', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(784, 'Tuła', 'tula', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(785, 'Uljanowsk', 'uljanowsk', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(786, 'Wołgograd', 'wolgograd', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(787, 'Rostów nad Donem', 'rostow_nad_donem', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(788, 'Togliatti', 'togliatti', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(789, 'Kiejdany', 'kiejdany', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(790, 'Janów', 'janow', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(791, 'OlitaKowno', 'olitakowno', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(792, 'Kłajpeda', 'klajpeda', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(793, 'Szawle', 'szawle', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(794, 'Wilno', 'wilno', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(795, 'Poniewież', 'poniewiez', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(796, 'Virovitica', 'virovitica', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(797, 'Osijek', 'osijek', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(798, 'Pula', 'pula', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(799, 'Knin', 'knin', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(800, 'Split', 'split', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(801, 'Biograd', 'biograd', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(802, 'Vinkovici', 'vinkovici', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(803, 'Senj', 'senj', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(804, 'Zagrzeb', 'zagrzeb', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(805, 'Rijeka', 'rijeka', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(806, 'Karlovac', 'karlovac', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(807, 'Varazdin', 'varazdin', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(808, 'Sisak', 'sisak', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(809, 'Zadar', 'zadar', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(810, 'Opatija', 'opatija', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(811, 'Dubrownik', 'dubrownik', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(812, 'Ploce', 'ploce', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(813, 'Szybenik', 'szybenik', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(814, 'Belgrad', 'belgrad', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(815, 'Nowy Sad', 'nowy_sad', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(816, 'Vrasac', 'vrasac', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(817, 'Prizren', 'prizren', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(818, 'Kosovska Mitrovica', 'kosovska_mitrovica', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(819, 'Valjevo', 'valjevo', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(820, 'Leskovac', 'leskovac', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(821, 'Cacak', 'cacak', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(822, 'Kikinda', 'kikinda', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(823, 'Zrenjanin', 'zrenjanin', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(824, 'Subotica', 'subotica', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(825, 'Peć', 'pec', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(826, 'Pirot', 'pirot', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(827, 'Sabac', 'sabac', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(828, 'Prisztina', 'prisztina', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(829, 'Novi Pazar', 'novi_pazar', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(830, 'Pancevo', 'pancevo', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(831, 'Sombor', 'sombor', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(832, 'Kragujevac', 'kragujevac', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(833, 'Bor', 'bor', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(834, 'Baranowicze', 'baranowicze', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(835, 'Grodno', 'grodno', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(836, 'Nowopłock', 'nowoplock', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(837, 'Mohylew', 'mohylew', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(838, 'Witebsk', 'witebsk', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(839, 'Borysów', 'borysow', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(840, 'Bobrujsk', 'bobrujsk', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(841, 'Pińsk', 'pinsk', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(842, 'Brześć', 'brzesc', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(843, 'Mozyrz', 'mozyrz', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(844, 'Homel', 'homel', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(845, 'Mińsk', 'minsk', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(846, 'Orsza', 'orsza', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(847, 'Neyshabur', 'neyshabur', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(848, 'Shiraz', 'shiraz', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(849, 'Zahedan', 'zahedan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(850, 'Qum', 'qum', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(851, 'Gorgan', 'gorgan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(852, 'Mashhad', 'mashhad', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(853, 'Esfahan', 'esfahan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(854, 'Sabzevar', 'sabzevar', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(855, 'Bojnurd', 'bojnurd', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(856, 'Karaj', 'karaj', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(857, 'Hamadan', 'hamadan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(858, 'Teheran', 'teheran', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(859, 'Turyn', 'turyn', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(860, 'Mediolan', 'mediolan', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(861, 'Paola', 'paola', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(862, 'Rzym', 'rzym', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(863, 'Genua', 'genua', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(864, 'Siena', 'siena', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(865, 'Teramo', 'teramo', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(866, 'Potenza', 'potenza', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(867, 'Prato', 'prato', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(868, 'Mesyna', 'mesyna', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(869, 'Isernia', 'isernia', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(870, 'Arezzo', 'arezzo', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(871, 'Ankora', 'ankora', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(872, 'L''Aquilla', 'l_aquilla', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(873, 'Bolonia', 'bolonia', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(874, 'Palermo', 'palermo', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(875, 'Cosenza', 'cosenza', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(876, 'Macerata', 'macerata', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(877, 'Neapol', 'neapol', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(878, 'Rieti', 'rieti', 65);

--
-- Zrzut danych tabeli `panstwo`
--

INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(1, 'Luksemburg', 'luksemburg', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(2, 'Bułgaria', 'bulgaria', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(3, 'Indie', 'indie', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(4, 'Islandia', 'islandia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(5, 'Republika Południowej Afryki', 'republika_poludniowej_afryki', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(6, 'Wenezuela', 'wenezuela', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(7, 'Norwegia', 'norwegia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(8, 'Meksyk', 'meksyk', 5);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(9, 'Bośnia i Hercegownia', 'bosnia_i_hercegownia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(10, 'Estonia', 'estonia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(11, 'Pakistan', 'pakistan', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(12, 'Brazylia', 'brazylia', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(13, 'Afganistan', 'afganistan', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(14, 'Walia', 'walia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(15, 'Argentyna', 'argentyna', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(16, 'Mołdawia', 'moldawia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(17, 'Sudan', 'sudan', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(18, 'Kanada', 'kanada', 5);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(19, 'Andora', 'andora', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(20, 'Szwecja', 'szwecja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(21, 'Algieria', 'algieria', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(22, 'Ukraina', 'ukraina', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(23, 'Czarnogóra', 'czarnogora', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(24, 'Francja', 'francja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(25, 'Peru', 'peru', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(26, 'Macedonia', 'macedonia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(27, 'Stany Zjednoczone', 'stany_zjednoczone', 5);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(28, 'Szkocja', 'szkocja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(29, 'Austria', 'austria', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(30, 'Węgry', 'wegry', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(31, 'Kolumbia', 'kolumbia', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(32, 'Rumunia', 'rumunia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(33, 'Australia', 'australia', 6);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(34, 'Dania', 'dania', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(35, 'Kazachstan', 'kazachstan', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(36, 'Słowacja', 'slowacja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(37, 'Arabia Saudyjska', 'arabia_saudyjska', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(38, 'Holandia', 'holandia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(39, 'San Marino', 'san_marino', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(40, 'Polska', 'polska', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(41, 'Niemcy', 'niemcy', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(42, 'Grecja', 'grecja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(43, 'Angola', 'angola', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(44, 'Szwajcaria', 'szwajcaria', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(45, 'Irlandia', 'irlandia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(46, 'Finlandia', 'finlandia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(47, 'Łotwa', 'lotwa', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(48, 'Nigieria', 'nigieria', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(49, 'Portugalia', 'portugalia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(50, 'Egipt', 'egipt', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(51, 'Demokratyczna Republika Konga', 'demokratyczna_republika_konga', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(52, 'Czechy', 'czechy', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(53, 'Belgia', 'belgia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(54, 'Hiszpania', 'hiszpania', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(55, 'Anglia', 'anglia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(56, 'Albania', 'albania', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(57, 'Słowenia', 'slowenia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(58, 'Chiny', 'chiny', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(59, 'Rosja', 'rosja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(60, 'Litwa', 'litwa', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(61, 'Chorwacja', 'chorwacja', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(62, 'Serbia', 'serbia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(63, 'Białoruś', 'bialorus', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(64, 'Iran', 'iran', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(65, 'Włochy', 'wlochy', 1);

SET FOREIGN_KEY_CHECKS=1;
