set names utf8;
drop database if exists panstwa_miasta;
create database panstwa_miasta default character set utf8 collate utf8_polish_ci;
grant all on panstwa_miasta.* to admin@localhost identified by 'password';
flush privileges;
use panstwa_miasta;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- panstwo
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `panstwo`;


CREATE TABLE `panstwo`
(
	`panstwo_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	`kontynent_id` INTEGER,
	PRIMARY KEY (`panstwo_id`),
	INDEX `FI_panstwo_kontynent` (`kontynent_id`),
	CONSTRAINT `fk_panstwo_kontynent`
		FOREIGN KEY (`kontynent_id`)
		REFERENCES `kontynent` (`kontynent_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- miasto
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `miasto`;


CREATE TABLE `miasto`
(
	`miasto_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	`panstwo_id` INTEGER,
	PRIMARY KEY (`miasto_id`),
	INDEX `FI_miasto_panstwo` (`panstwo_id`),
	CONSTRAINT `fk_miasto_panstwo`
		FOREIGN KEY (`panstwo_id`)
		REFERENCES `panstwo` (`panstwo_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- kontynent
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kontynent`;


CREATE TABLE `kontynent`
(
	`kontynent_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	PRIMARY KEY (`kontynent_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
